<?php
/**
 * BU DOSYA SEPET SAYFASINDA VEYA KUPON ONAYLAMA (AJAX) DOSYANDA OLMALIDIR.
 * Gelen kişinin bayilik durumuna göre kuponu filtreler.
 */

require_once 'private/config.php';

// 1. Önce giriş yapan kişinin tipini belirleyelim
// Varsayalım ki: $_SESSION['user_id'] varsa üye, $_SESSION['user_role'] == 'dealer' ise bayidir.
$currentUserGroup = 0; // Varsayılan: Ziyaretçi (Misafir)

if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
    $currentUserGroup = 1; // Standart Üye
    
    // Eğer bayi kontrolün varsa:
    if (isset($_SESSION['user_type']) && $_SESSION['user_type'] === 'bayi') {
        $currentUserGroup = 2; // Bayi (B2B)
    }
}

// 2. Müşterinin girdiği kupon kodunu alalım
$enteredCode = strtoupper(trim($_POST['coupon_code']));

// 3. Veritabanından kuponu sorgulayalım
$stmt = $db->prepare("SELECT * FROM hediye_cekleri WHERE cek_kodu = ? AND durum = 1 LIMIT 1");
$stmt->execute([$enteredCode]);
$coupon = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$coupon) {
    die("Hata: Geçersiz veya süresi dolmuş kupon kodu.");
}

// --- KRİTİK FİLTRELEME BURADA BAŞLIYOR (KANKACIM BURASI ÖNEMLİ) ---

// Kuponun hedef grubu ile mevcut kullanıcının grubunu kıyasla
// hedef_grup: 0 (Herkes), 1 (Sadece Üye), 2 (Sadece Bayi)

if ($coupon['hedef_grup'] != 0) { // Eğer kupon "herkese açık" değilse
    
    if ($coupon['hedef_grup'] == 1 && $currentUserGroup != 1) {
        // Kupon sadece ÜYELERE özel ama gelen kişi Üye değil (Misafir veya Bayi olabilir)
        die("Hata: Bu kupon sadece kayıtlı üyelerimize özeldir.");
    }
    
    if ($coupon['hedef_grup'] == 2 && $currentUserGroup != 2) {
        // Kupon sadece BAYİLERE özel ama gelen kişi Bayi değil
        die("Hata: Bu kupon sadece B2B bayilerimize özel tanımlanmıştır.");
    }
}

// 4. Diğer Kontroller (Tarih, Limit, Min Sepet)
$now = date('Y-m-d H:i:s');
if ($coupon['baslangic_tarihi'] && $now < $coupon['baslangic_tarihi']) die("Bu kampanya henüz başlamadı.");
if ($coupon['bitis_tarihi'] && $now > $coupon['bitis_tarihi']) die("Bu kuponun süresi dolmuş.");
if ($coupon['kullanim_limiti'] > 0 && $coupon['kullanilan_adet'] >= $coupon['kullanim_limiti']) die("Bu kuponun kullanım limiti doldu.");

// Eğer buraya kadar geldiyse kupon geçerlidir!
echo "Tebrikler! İndirim uygulandı.";
// İndirim hesaplama işlemlerine devam edebilirsin...
?>