<?php
require_once '../private/config.php';

// Oturum Kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$message = "";
$messageType = "";

// --- İŞLEM 1: SİLME ---
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    try {
        $db->prepare("DELETE FROM kargo_firmalari WHERE id = ?")->execute([$id]);
        header("Location: kargo-ayar.php?msg=deleted");
        exit;
    } catch(PDOException $e) {
        $message = "Silme işlemi başarısız: " . $e->getMessage();
        $messageType = "error";
    }
}

// --- İŞLEM 2: EKLEME / GÜNCELLEME ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $is_edit = isset($_POST['kargo_id']) && !empty($_POST['kargo_id']);
    $kargo_id = $is_edit ? intval($_POST['kargo_id']) : 0;
    
    $firma_adi = trim($_POST['firma_adi']);
    $ucretsiz_kargo_limiti = floatval($_POST['ucretsiz_kargo_limiti']);
    $sira = intval($_POST['sira']);
    $durum = isset($_POST['durum']) ? 1 : 0;

    try {
        $db->beginTransaction();

        if ($is_edit) {
            // Firmayı Güncelle
            $sql = "UPDATE kargo_firmalari SET firma_adi=?, ucretsiz_kargo_limiti=?, sira=?, durum=? WHERE id=?";
            $stmt = $db->prepare($sql);
            $stmt->execute([$firma_adi, $ucretsiz_kargo_limiti, $sira, $durum, $kargo_id]);
            $message = "Kargo firması başarıyla güncellendi.";
            
            // Eski baremleri temizle
            $db->prepare("DELETE FROM kargo_baremleri WHERE kargo_id = ?")->execute([$kargo_id]);
        } else {
            // Yeni Firma Ekle
            $sql = "INSERT INTO kargo_firmalari (firma_adi, ucretsiz_kargo_limiti, sira, durum) VALUES (?, ?, ?, ?)";
            $stmt = $db->prepare($sql);
            $stmt->execute([$firma_adi, $ucretsiz_kargo_limiti, $sira, $durum]);
            $kargo_id = $db->lastInsertId();
            $message = "Yeni kargo firması başarıyla eklendi.";
        }

        // Baremleri Ekle
        if (isset($_POST['alt_limit']) && is_array($_POST['alt_limit'])) {
            $baremSql = "INSERT INTO kargo_baremleri (kargo_id, alt_limit, kargo_ucreti) VALUES (?, ?, ?)";
            $baremStmt = $db->prepare($baremSql);
            
            foreach ($_POST['alt_limit'] as $key => $altLimit) {
                $alt = floatval($altLimit);
                $ucret = floatval($_POST['kargo_ucreti'][$key]);
                
                if ($alt >= 0 && $ucret >= 0) {
                    $baremStmt->execute([$kargo_id, $alt, $ucret]);
                }
            }
        }

        $db->commit();
        $messageType = "success";
        if(!$is_edit) { header("Refresh: 1.5; url=kargo-ayar.php"); }

    } catch (PDOException $e) {
        $db->rollBack();
        $message = "Hata: " . $e->getMessage();
        $messageType = "error";
    }
}

// --- DÜZENLEME VERİSİ ---
$editData = null;
$editBaremler = [];
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $editData = $db->query("SELECT * FROM kargo_firmalari WHERE id = $id")->fetch(PDO::FETCH_ASSOC);
    $editBaremler = $db->query("SELECT * FROM kargo_baremleri WHERE kargo_id = $id ORDER BY alt_limit ASC")->fetchAll(PDO::FETCH_ASSOC);
}

// --- LİSTELEME ---
$kargolar = $db->query("SELECT * FROM kargo_firmalari ORDER BY sira ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kargo Ayarları | Panel</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/kargo-ayar.css">
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <h2>Kargo ve Teslimat Ayarları</h2>
            </div>
            <div class="user-info">
                <span>Hoş geldin, <strong><?php echo $_SESSION['admin_username'] ?? 'Yönetici'; ?></strong></span>
            </div>
        </header>
        
        <div class="content-body">
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?>">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <div class="page-grid">
                
                <!-- SOL TARAF: FORM -->
                <div class="form-section">
                    <div class="panel-card">
                        <div class="card-header">
                            <h3>
                                <i class="fa-solid <?php echo $editData ? 'fa-pen-to-square' : 'fa-truck-fast'; ?>"></i>
                                <?php echo $editData ? 'Kargo Firmasını Düzenle' : 'Yeni Kargo Firması Ekle'; ?>
                            </h3>
                            <?php if($editData): ?>
                                <a href="kargo-ayar.php" class="btn-xs btn-outline">İptal / Yeni Ekle</a>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <?php if($editData): ?>
                                    <input type="hidden" name="kargo_id" value="<?php echo $editData['id']; ?>">
                                <?php endif; ?>

                                <div class="form-group">
                                    <label>Kargo Firma Adı <span class="required">*</span></label>
                                    <input type="text" name="firma_adi" required value="<?php echo $editData['firma_adi'] ?? ''; ?>" placeholder="Örn: Yurtiçi Kargo, Aras Kargo">
                                </div>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Ücretsiz Kargo Limiti (₺)</label>
                                        <div class="input-with-icon">
                                            <input type="number" step="0.01" name="ucretsiz_kargo_limiti" value="<?php echo $editData['ucretsiz_kargo_limiti'] ?? '0.00'; ?>">
                                            <span class="currency">₺</span>
                                        </div>
                                        <small class="helper-text">Sepet tutarı bu rakamı aşarsa kargo ücretsiz olur. 0 yazarsanız limit kapalı olur.</small>
                                    </div>
                                    <div class="form-group col">
                                        <label>Sıra No</label>
                                        <input type="number" name="sira" value="<?php echo $editData['sira'] ?? '0'; ?>">
                                    </div>
                                </div>

                                <hr class="divider">
                                
                                <div class="barem-section">
                                    <div class="barem-header">
                                        <h4><i class="fa-solid fa-layer-group"></i> Fiyatlandırma Baremleri</h4>
                                        <button type="button" class="btn-add-barem" onclick="addBaremRow()">
                                            <i class="fa-solid fa-plus"></i> Barem Ekle
                                        </button>
                                    </div>
                                    <p class="helper-text mb-15">Örn: 0₺ Üzeri -> 50₺ Kargo | 500₺ Üzeri -> 20₺ Kargo</p>

                                    <div id="baremContainer">
                                        <?php if($editBaremler): ?>
                                            <?php foreach($editBaremler as $index => $barem): ?>
                                                <div class="barem-row">
                                                    <div class="b-group">
                                                        <label>Sepet Alt Limiti</label>
                                                        <div class="input-with-icon">
                                                            <input type="number" step="0.01" name="alt_limit[]" value="<?php echo $barem['alt_limit']; ?>" required>
                                                            <span class="currency">₺ Üzeri</span>
                                                        </div>
                                                    </div>
                                                    <i class="fa-solid fa-arrow-right-long text-muted"></i>
                                                    <div class="b-group">
                                                        <label>Kargo Ücreti</label>
                                                        <div class="input-with-icon">
                                                            <input type="number" step="0.01" name="kargo_ucreti[]" value="<?php echo $barem['kargo_ucreti']; ?>" required>
                                                            <span class="currency">₺</span>
                                                        </div>
                                                    </div>
                                                    <button type="button" class="btn-remove-barem" onclick="this.parentElement.remove()"><i class="fa-solid fa-trash-can"></i></button>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <!-- Varsayılan 1 satır -->
                                            <div class="barem-row">
                                                <div class="b-group">
                                                    <label>Sepet Alt Limiti</label>
                                                    <div class="input-with-icon">
                                                        <input type="number" step="0.01" name="alt_limit[]" value="0" required>
                                                        <span class="currency">₺ Üzeri</span>
                                                    </div>
                                                </div>
                                                <i class="fa-solid fa-arrow-right-long text-muted"></i>
                                                <div class="b-group">
                                                    <label>Kargo Ücreti</label>
                                                    <div class="input-with-icon">
                                                        <input type="number" step="0.01" name="kargo_ucreti[]" value="50.00" required>
                                                        <span class="currency">₺</span>
                                                    </div>
                                                </div>
                                                <button type="button" class="btn-remove-barem" onclick="this.parentElement.remove()"><i class="fa-solid fa-trash-can"></i></button>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <hr class="divider">

                                <div class="settings-toggles">
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="durum" <?php echo (!isset($editData) || $editData['durum'] == 1) ? 'checked' : ''; ?>>
                                        <span class="slider"></span>
                                        <span class="label-text">Kargo Firması Aktif Seçilebilir</span>
                                    </label>
                                </div>

                                <button type="submit" class="save-btn btn-full">
                                    <i class="fa-solid fa-floppy-disk"></i> <?php echo $editData ? 'Kargoyu Güncelle' : 'Kargoyu Kaydet'; ?>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- SAĞ TARAF: LİSTE -->
                <div class="list-section">
                    <div class="panel-card">
                        <div class="card-header">
                            <h3><i class="fa-solid fa-list-check"></i> Mevcut Kargo Firmaları</h3>
                        </div>
                        <div class="card-body p-0">
                            <?php if(empty($kargolar)): ?>
                                <div class="empty-state">Henüz kargo firması eklenmemiş.</div>
                            <?php else: ?>
                                <div class="cargo-list">
                                    <?php foreach($kargolar as $kargo): 
                                        // Bu kargonun baremlerini çek
                                        $baremler = $db->query("SELECT * FROM kargo_baremleri WHERE kargo_id = " . $kargo['id'] . " ORDER BY alt_limit ASC")->fetchAll(PDO::FETCH_ASSOC);
                                    ?>
                                        <div class="cargo-item <?php echo $kargo['durum'] == 0 ? 'passive' : ''; ?>">
                                            <div class="cargo-item-header">
                                                <div class="c-title">
                                                    <strong><?php echo $kargo['firma_adi']; ?></strong>
                                                    <?php if($kargo['durum'] == 1): ?>
                                                        <span class="badge badge-active">Aktif</span>
                                                    <?php else: ?>
                                                        <span class="badge badge-passive">Pasif</span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="action-buttons">
                                                    <a href="?edit=<?php echo $kargo['id']; ?>" class="btn-icon btn-edit" title="Düzenle"><i class="fa-solid fa-pen"></i></a>
                                                    <a href="?delete=<?php echo $kargo['id']; ?>" class="btn-icon btn-delete" title="Sil" onclick="return confirm('Bu kargo firmasını silmek istediğinize emin misiniz?')"><i class="fa-solid fa-trash"></i></a>
                                                </div>
                                            </div>
                                            
                                            <div class="cargo-item-body">
                                                <div class="free-limit">
                                                    <i class="fa-solid fa-gift"></i> Ücretsiz Kargo Limiti: 
                                                    <strong><?php echo $kargo['ucretsiz_kargo_limiti'] > 0 ? number_format($kargo['ucretsiz_kargo_limiti'], 2) . ' ₺' : 'Yok'; ?></strong>
                                                </div>
                                                
                                                <div class="barem-list">
                                                    <?php if($baremler): ?>
                                                        <?php foreach($baremler as $b): ?>
                                                            <div class="barem-badge">
                                                                <?php echo number_format($b['alt_limit'], 0); ?>₺ Üzeri <i class="fa-solid fa-arrow-right"></i> <?php echo number_format($b['kargo_ucreti'], 2); ?> ₺
                                                            </div>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <span class="text-muted" style="font-size:0.8rem;">Barem tanımlanmamış.</span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        
        <footer class="panel-footer">
            &copy; <?php echo date("Y"); ?> Yönetim Paneli
        </footer>
    </main>
</div>

<script>
    function addBaremRow() {
        const container = document.getElementById('baremContainer');
        const row = document.createElement('div');
        row.className = 'barem-row';
        row.innerHTML = `
            <div class="b-group">
                <label>Sepet Alt Limiti</label>
                <div class="input-with-icon">
                    <input type="number" step="0.01" name="alt_limit[]" placeholder="Örn: 500" required>
                    <span class="currency">₺ Üzeri</span>
                </div>
            </div>
            <i class="fa-solid fa-arrow-right-long text-muted" style="margin-top: 25px;"></i>
            <div class="b-group">
                <label>Kargo Ücreti</label>
                <div class="input-with-icon">
                    <input type="number" step="0.01" name="kargo_ucreti[]" placeholder="Örn: 20" required>
                    <span class="currency">₺</span>
                </div>
            </div>
            <button type="button" class="btn-remove-barem" onclick="this.parentElement.remove()" style="margin-top: 25px;"><i class="fa-solid fa-trash-can"></i></button>
        `;
        container.appendChild(row);
    }

    // Mobil Menü
    const toggleBtn = document.getElementById('toggleSidebar');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            document.getElementById('sidebar').classList.add('active');
            document.getElementById('sidebarOverlay').classList.add('active');
        });
    }
    const overlay = document.getElementById('sidebarOverlay');
    if(overlay) {
        overlay.addEventListener('click', () => {
            document.getElementById('sidebar').classList.remove('active');
            overlay.classList.remove('active');
        });
    }
</script>
</body>
</html>