<?php
require_once '../private/config.php';

// Güvenlik: Eğer verification yapılmamışsa geri gönder
if (!isset($_SESSION['is_verified']) || $_SESSION['is_verified'] !== true) {
    header("Location: verification.php");
    exit;
}

// Eğer zaten giriş yapmışsa panele gönder
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header("Location: panel.php");
    exit;
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    
    if (empty($username) || empty($password)) {
        $error = "Lütfen tüm alanları doldurunuz.";
    } else {
        try {
            $stmt = $db->prepare("SELECT * FROM yoneticiler WHERE kadi = :kadi AND durum = 1 LIMIT 1");
            $stmt->bindParam(':kadi', $username, PDO::PARAM_STR);
            $stmt->execute();
            $user = $stmt->fetch();
            
            if ($user && password_verify($password, $user['sifre'])) {
                $_SESSION['admin_logged_in'] = true;
                $_SESSION['admin_id'] = $user['id'];
                $_SESSION['admin_username'] = $user['kadi'];
                $_SESSION['admin_adsoyad'] = $user['ad_soyad'];
                
                $updateStmt = $db->prepare("UPDATE yoneticiler SET son_giris = NOW() WHERE id = :id");
                $updateStmt->execute(['id' => $user['id']]);
                
                header("Location: panel.php");
                exit;
            } else {
                $error = "Kullanıcı adı veya şifre hatalı!";
            }
        } catch (PDOException $e) {
            $error = "Bir hata oluştu.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yönetici Girişi</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- CSS Dosya Yolu: Ana dizindeki assets klasörü -->
    <link rel="stylesheet" href="../assets/login.css">
    <style>
        /* Sol tarafı kaldırdığımız için konteyneri ortalayıp küçültüyoruz */
        .login-container {
            width: 400px;
            height: auto;
            flex-direction: column;
        }
        .login-left {
            display: none;
        }
        .login-right {
            padding: 40px;
            width: 100%;
        }
        .form-wrapper {
            max-width: 100%;
        }
        .login-btn {
            margin-top: 20px;
        }
    </style>
</head>
<body>

<div class="login-container">
    
    <div class="login-right">
        <div class="form-wrapper">
            <div class="logo-area">
                <!-- Logo Yolu Güncellendi -->
                <img src="../uploads/logo.png" alt="Admin Logo" onerror="this.src='https://placehold.co/150x50/232f3e/white?text=LOGO'">
            </div>
            
            <h3 style="text-align:center;">Yönetici Girişi</h3>
            
            <?php if($error): ?>
                <div class="alert-error"><i class="fa-solid fa-circle-exclamation"></i> <?php echo $error; ?></div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="input-box">
                    <label>Kullanıcı Adı</label>
                    <div class="input-field">
                        <i class="fa-regular fa-user"></i>
                        <input type="text" name="username" placeholder="Kullanıcı adınız" required autocomplete="username">
                    </div>
                </div>

                <div class="input-box">
                    <label>Şifre</label>
                    <div class="input-field">
                        <i class="fa-solid fa-lock"></i>
                        <input type="password" name="password" placeholder="Şifreniz" required autocomplete="current-password">
                    </div>
                </div>

                <!-- Beni Hatırla ve Şifremi Unuttum kaldırıldı -->

                <button type="submit" class="login-btn">Giriş Yap</button>
            </form>
        </div>
    </div>
</div>

</body>
</html>