<?php
require_once '../private/config.php';

// Oturum Kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$message = "";
$messageType = "";

// --- İŞLEM 1: SİLME ---
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    
    // Resmi diskten sil
    $stmtImg = $db->prepare("SELECT resim_yolu FROM markalar WHERE id = :id");
    $stmtImg->execute(['id' => $id]);
    $img = $stmtImg->fetch();
    if($img && $img['resim_yolu'] && file_exists('../uploads/markalar/' . $img['resim_yolu'])) {
        @unlink('../uploads/markalar/' . $img['resim_yolu']);
    }

    $stmt = $db->prepare("DELETE FROM markalar WHERE id = :id");
    if ($stmt->execute(['id' => $id])) {
        header("Location: marka-ekle.php?msg=deleted");
        exit;
    }
}

// --- İŞLEM 2: EKLEME / GÜNCELLEME ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $is_edit = isset($_POST['marka_id']) && !empty($_POST['marka_id']);
    
    $marka_adi = isset($_POST['marka_adi']) ? trim($_POST['marka_adi']) : '';
    $web_servis_kodu = isset($_POST['web_servis_kodu']) ? trim($_POST['web_servis_kodu']) : '';
    $sira = isset($_POST['sira']) ? intval($_POST['sira']) : 0;
    $durum = isset($_POST['durum']) ? 1 : 0;

    // Resim İşlemleri
    $resim_yolu = isset($_POST['mevcut_resim']) ? $_POST['mevcut_resim'] : null;

    // 1. Resmi Silme İsteği
    if (isset($_POST['resim_sil']) && $_POST['resim_sil'] == '1') {
        if ($resim_yolu && file_exists('../uploads/markalar/' . $resim_yolu)) {
            @unlink('../uploads/markalar/' . $resim_yolu);
        }
        $resim_yolu = null;
    }

    // 2. Yeni Resim Yükleme
    if (isset($_FILES['resim']) && $_FILES['resim']['error'] == 0) {
        $allowed = ['image/jpeg', 'image/png', 'image/webp'];
        if (in_array($_FILES['resim']['type'], $allowed)) {
            $uploadDir = '../uploads/markalar/';
            if (!file_exists($uploadDir)) { mkdir($uploadDir, 0777, true); }
            
            $ext = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $fileName = 'brand_' . time() . '_' . rand(100,999) . '.' . $ext;
            $targetPath = $uploadDir . $fileName;
            
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $targetPath)) {
                // Eski resmi temizle
                if ($resim_yolu && $resim_yolu !== $fileName && file_exists($uploadDir . $resim_yolu)) {
                    @unlink($uploadDir . $resim_yolu);
                }
                $resim_yolu = $fileName;
            }
        }
    }

    try {
        if ($is_edit) {
            // GÜNCELLEME
            $sql = "UPDATE markalar SET 
                    marka_adi=:adi, web_servis_kodu=:ws, resim_yolu=:resim, sira=:sira, durum=:durum 
                    WHERE id=:id";
            $stmt = $db->prepare($sql);
            $stmt->execute([
                'adi' => $marka_adi, 'ws' => $web_servis_kodu, 'resim' => $resim_yolu,
                'sira' => $sira, 'durum' => $durum, 'id' => $_POST['marka_id']
            ]);
            $message = "Marka başarıyla güncellendi.";
        } else {
            // EKLEME
            $sql = "INSERT INTO markalar (marka_adi, web_servis_kodu, resim_yolu, sira, durum) 
                    VALUES (:adi, :ws, :resim, :sira, :durum)";
            $stmt = $db->prepare($sql);
            $stmt->execute([
                'adi' => $marka_adi, 'ws' => $web_servis_kodu, 'resim' => $resim_yolu,
                'sira' => $sira, 'durum' => $durum
            ]);
            $message = "Yeni marka başarıyla oluşturuldu.";
        }
        $messageType = "success";
        
        if(!$is_edit) { header("Refresh: 1.5; url=marka-ekle.php"); }

    } catch (PDOException $e) {
        $message = "Hata: " . $e->getMessage();
        $messageType = "error";
    }
}

// --- DÜZENLEME VERİSİ ---
$editData = null;
if (isset($_GET['edit'])) {
    $stmt = $db->prepare("SELECT * FROM markalar WHERE id = :id");
    $stmt->execute(['id' => $_GET['edit']]);
    $editData = $stmt->fetch();
}

// --- LİSTELEME ---
$markalar = $db->query("SELECT * FROM markalar ORDER BY sira ASC, marka_adi ASC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Marka Yönetimi | Panel</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/marka-ekle.css">
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <h2>Marka Yönetimi</h2>
            </div>
            <div class="user-info">
                <span>Hoş geldin, <strong><?php echo $_SESSION['admin_username'] ?? 'Yönetici'; ?></strong></span>
            </div>
        </header>
        
        <div class="content-body">
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?>">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <div class="page-grid">
                
                <!-- SOL: FORM -->
                <div class="form-section">
                    <div class="panel-card">
                        <div class="card-header">
                            <h3>
                                <i class="fa-solid <?php echo $editData ? 'fa-pen-to-square' : 'fa-plus-circle'; ?>"></i>
                                <?php echo $editData ? 'Markayı Düzenle' : 'Yeni Marka Ekle'; ?>
                            </h3>
                            <?php if($editData): ?>
                                <a href="marka-ekle.php" class="btn-xs btn-outline">İptal</a>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="" enctype="multipart/form-data">
                                <?php if($editData): ?>
                                    <input type="hidden" name="marka_id" value="<?php echo $editData['id']; ?>">
                                    <input type="hidden" name="mevcut_resim" value="<?php echo $editData['resim_yolu']; ?>">
                                <?php endif; ?>

                                <div class="form-group">
                                    <label>Marka Adı <span class="required">*</span></label>
                                    <input type="text" name="marka_adi" required value="<?php echo $editData['marka_adi'] ?? ''; ?>" placeholder="Örn: Samsung">
                                </div>
                                
                                <div class="form-group">
                                    <label>Web Servis Kodu</label>
                                    <input type="text" name="web_servis_kodu" value="<?php echo $editData['web_servis_kodu'] ?? ''; ?>" placeholder="Örn: BR-001">
                                    <small style="color:#666; font-size:0.8rem;">ERP entegrasyonu için eşleşme kodu.</small>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Sıra No</label>
                                        <input type="number" name="sira" value="<?php echo $editData['sira'] ?? '0'; ?>">
                                    </div>
                                    <div class="form-group col">
                                        <label>Marka Logosu</label>
                                        <input type="file" name="resim" accept=".jpg,.png,.webp">
                                        <?php if(isset($editData['resim_yolu']) && $editData['resim_yolu']): ?>
                                            <div class="img-preview-mini">
                                                <img src="../uploads/markalar/<?php echo $editData['resim_yolu']; ?>" alt="">
                                                <div style="display:flex; flex-direction:column; justify-content:center;">
                                                    <label class="delete-img-check">
                                                        <input type="checkbox" name="resim_sil" value="1"> 
                                                        <i class="fa-solid fa-trash-can"></i> Sil
                                                    </label>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="settings-toggles">
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="durum" <?php echo (!isset($editData) || $editData['durum'] == 1) ? 'checked' : ''; ?>>
                                        <span class="slider"></span>
                                        <span class="label-text">Marka Aktif</span>
                                    </label>
                                </div>

                                <button type="submit" class="save-btn btn-full">
                                    <i class="fa-solid fa-floppy-disk"></i> <?php echo $editData ? 'Markayı Güncelle' : 'Markayı Kaydet'; ?>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- SAĞ: LİSTE -->
                <div class="list-section">
                    <div class="panel-card">
                        <div class="card-header">
                            <h3><i class="fa-solid fa-copyright"></i> Marka Listesi</h3>
                            <div class="list-search-wrapper">
                                <input type="text" id="brandSearch" placeholder="Marka ara..." class="search-input">
                                <i class="fa-solid fa-search"></i>
                            </div>
                        </div>
                        <div class="card-body p-0 table-responsive">
                            <table class="data-table" id="brandTable">
                                <thead>
                                    <tr>
                                        <th width="60">Logo</th>
                                        <th>Marka Adı</th>
                                        <th>WS Kodu</th>
                                        <th>Durum</th>
                                        <th width="90">İşlem</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(count($markalar) > 0): ?>
                                        <?php foreach($markalar as $marka): ?>
                                            <tr class="brand-row" data-name="<?php echo strtolower($marka['marka_adi']); ?>">
                                                <td>
                                                    <?php if($marka['resim_yolu']): ?>
                                                        <img src="../uploads/markalar/<?php echo $marka['resim_yolu']; ?>" class="table-img">
                                                    <?php else: ?>
                                                        <div class="no-img"><i class="fa-regular fa-image"></i></div>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <strong><?php echo $marka['marka_adi']; ?></strong>
                                                </td>
                                                <td>
                                                    <?php echo $marka['web_servis_kodu'] ? '<span class="badge badge-gray">'.$marka['web_servis_kodu'].'</span>' : '-'; ?>
                                                </td>
                                                <td>
                                                    <?php if($marka['durum'] == 1): ?>
                                                        <span class="dot status-active"></span> <small>Aktif</small>
                                                    <?php else: ?>
                                                        <span class="dot status-passive"></span> <small>Pasif</small>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <div class="action-buttons">
                                                        <a href="?edit=<?php echo $marka['id']; ?>" class="btn-icon btn-edit"><i class="fa-solid fa-pen"></i></a>
                                                        <a href="?delete=<?php echo $marka['id']; ?>" class="btn-icon btn-delete" onclick="return confirm('Bu markayı silmek istediğine emin misin?')"><i class="fa-solid fa-trash"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr><td colspan="5" class="text-center" style="padding:20px;">Henüz marka eklenmemiş.</td></tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        
        <footer class="panel-footer">
            &copy; <?php echo date("Y"); ?> Yönetim Paneli
        </footer>
    </main>
</div>

<script>
    // Arama Fonksiyonu
    const searchInput = document.getElementById('brandSearch');
    const tableRows = document.querySelectorAll('#brandTable tbody tr.brand-row');

    if(searchInput) {
        searchInput.addEventListener('keyup', function() {
            const filter = this.value.toLowerCase();
            tableRows.forEach(row => {
                const name = row.getAttribute('data-name');
                if(name.includes(filter)) {
                    row.style.display = "";
                } else {
                    row.style.display = "none";
                }
            });
        });
    }

    // Mobil Menü
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    const toggleBtn = document.getElementById('toggleSidebar');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            sidebar.classList.add('active');
            overlay.classList.add('active');
        });
    }
    if(overlay) {
        overlay.addEventListener('click', () => {
            sidebar.classList.remove('active');
            overlay.classList.remove('active');
        });
    }
</script>
</body>
</html>