<?php
require_once '../private/config.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$message = "";
$messageType = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $kk_durum = isset($_POST['kk_durum']) ? 1 : 0;
    $kk_saglayici = $_POST['kk_saglayici'];
    $paytr_merchant_id = trim($_POST['paytr_merchant_id']);
    $paytr_merchant_key = trim($_POST['paytr_merchant_key']);
    $paytr_merchant_salt = trim($_POST['paytr_merchant_salt']);
    
    $kapida_odeme_durum = isset($_POST['kapida_odeme_durum']) ? 1 : 0;
    $kapida_odeme_bedeli = floatval($_POST['kapida_odeme_bedeli']);

    $havale_durum = isset($_POST['havale_durum']) ? 1 : 0;
    $havale_aciklama = trim($_POST['havale_aciklama']);

    try {
        $sql = "UPDATE odeme_ayarlari SET 
                kk_durum=?, kk_saglayici=?, 
                paytr_merchant_id=?, paytr_merchant_key=?, paytr_merchant_salt=?, 
                kapida_odeme_durum=?, kapida_odeme_bedeli=?, 
                havale_durum=?, havale_aciklama=? 
                WHERE id=1";
        
        $stmt = $db->prepare($sql);
        $stmt->execute([
            $kk_durum, $kk_saglayici, 
            $paytr_merchant_id, $paytr_merchant_key, $paytr_merchant_salt, 
            $kapida_odeme_durum, $kapida_odeme_bedeli, 
            $havale_durum, $havale_aciklama
        ]);

        $message = "Ödeme ayarları başarıyla güncellendi.";
        $messageType = "success";
    } catch (PDOException $e) {
        $message = "Hata: " . $e->getMessage();
        $messageType = "error";
    }
}

$ayar = $db->query("SELECT * FROM odeme_ayarlari WHERE id = 1")->fetch(PDO::FETCH_ASSOC);

// Kankacım Bildirim URL'yi burada otomatik oluşturuyoruz ki PayTR paneline yapıştırasın
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
$bildirim_url = $protocol . "://" . $_SERVER['HTTP_HOST'] . "/paytr-bildirim.php";
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Ödeme Yöntemleri | Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/odeme-yontemi.css">
    <style>
        .notify-box { background: #fffbeb; border: 1px solid #fcd34d; padding: 15px; border-radius: 8px; margin-bottom: 20px; }
        .notify-box code { background: #fff; padding: 4px 8px; border-radius: 4px; font-weight: bold; color: #b45309; border: 1px solid #fde68a; }
    </style>
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <h2>Ödeme Yöntemleri Yapılandırması</h2>
            </div>
        </header>
        
        <div class="content-body">
            <?php if($message): ?><div class="alert-box <?php echo $messageType; ?>"><?php echo $message; ?></div><?php endif; ?>

            <div class="notify-box">
                <h4 style="margin-top:0;"><i class="fa-solid fa-circle-info"></i> PayTR Bildirim URL Bilgisi</h4>
                <p>PayTR Mağaza Paneli'ne girerek <strong>"Ayarlar"</strong> sekmesindeki Bildirim URL kısmına aşağıdaki adresi yapıştırın:</p>
                <code><?php echo $bildirim_url; ?></code>
            </div>

            <form method="POST" action="">
                <div class="settings-grid">
                    
                    <!-- KREDİ KARTI -->
                    <div class="panel-card mb-20">
                        <div class="card-header">
                            <h3><i class="fa-regular fa-credit-card"></i> Kredi Kartı (PayTR Entegrasyonu)</h3>
                            <label class="toggle-switch"><input type="checkbox" name="kk_durum" <?php echo $ayar['kk_durum'] == 1 ? 'checked' : ''; ?>><span class="slider"></span></label>
                        </div>
                        <div class="card-body">
                            <input type="hidden" name="kk_saglayici" value="paytr">
                            <div class="form-group"><label>Mağaza Numarası (Merchant ID)</label><input type="text" name="paytr_merchant_id" value="<?php echo $ayar['paytr_merchant_id']; ?>"></div>
                            <div class="form-row">
                                <div class="form-group col"><label>Mağaza Parolası (Merchant Key)</label><input type="text" name="paytr_merchant_key" value="<?php echo $ayar['paytr_merchant_key']; ?>"></div>
                                <div class="form-group col"><label>Mağaza Gizli Anahtarı (Merchant Salt)</label><input type="text" name="paytr_merchant_salt" value="<?php echo $ayar['paytr_merchant_salt']; ?>"></div>
                            </div>
                        </div>
                    </div>

                    <!-- DİĞERLERİ -->
                    <div>
                        <div class="panel-card mb-20">
                            <div class="card-header">
                                <h3><i class="fa-solid fa-box-open"></i> Kapıda Ödeme</h3>
                                <label class="toggle-switch"><input type="checkbox" name="kapida_odeme_durum" <?php echo $ayar['kapida_odeme_durum'] == 1 ? 'checked' : ''; ?>><span class="slider"></span></label>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Hizmet Bedeli</label>
                                    <div class="input-with-icon"><input type="number" step="0.01" name="kapida_odeme_bedeli" value="<?php echo $ayar['kapida_odeme_bedeli']; ?>"><span class="currency">₺</span></div>
                                </div>
                            </div>
                        </div>

                        <div class="panel-card">
                            <div class="card-header">
                                <h3><i class="fa-solid fa-building-columns"></i> Havale / EFT</h3>
                                <label class="toggle-switch"><input type="checkbox" name="havale_durum" <?php echo $ayar['havale_durum'] == 1 ? 'checked' : ''; ?>><span class="slider"></span></label>
                            </div>
                            <div class="card-body">
                                <textarea name="havale_aciklama" rows="5"><?php echo $ayar['havale_aciklama']; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="sticky-footer mt-20">
                    <button type="submit" class="save-btn btn-lg"><i class="fa-solid fa-floppy-disk"></i> Ayarları Kaydet</button>
                </div>
            </form>
        </div>
    </main>
</div>
</body>
</html>