<?php
// Güvenlik ve Config Dosyası
require_once '../private/config.php';

// Oturum Kontrolü: Giriş yapmamışsa login sayfasına at
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yönetim Paneli | Anasayfa</title>
    
    <!-- Fontlar -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- CSS Dosyaları (Ana dizindeki assets klasöründen) -->
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
</head>
<body>

<div class="admin-layout">
    
    <!-- Mobilde Sidebar açılınca arka planı karartmak için -->
    <div class="overlay" id="sidebarOverlay"></div>

    <!-- 1. SIDEBAR (Modüler yapı) -->
    <?php include 'sidebar.php'; ?>

    <!-- 2. ANA İÇERİK ALANI -->
    <main class="main-content">
        
        <!-- Üst Bar (Header) -->
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <!-- Mobil Hamburger Butonu -->
                <button id="toggleSidebar" class="hamburger">
                    <i class="fa-solid fa-bars"></i>
                </button>
                <h2>Panel Anasayfa</h2>
            </div>
            
            <div class="user-info">
                <span>Hoş geldin, <strong><?php echo $_SESSION['admin_username'] ?? 'Yönetici'; ?></strong></span>
            </div>
        </header>
        
        <!-- Sayfa İçeriği -->
        <div class="content-body">
            <div class="welcome-box">
                <h1>Hoş Geldiniz!</h1>
                <p>Katalog Yönetim Paneli'ne başarıyla giriş yaptınız. Sol menüden işlemlere başlayabilirsiniz.</p>
            </div>
        </div>

        <!-- Telif Hakkı (Footer) -->
        <footer class="panel-footer">
            &copy; <?php echo date("Y"); ?> Katalog Yönetim Paneli - Tüm Hakları Saklıdır.
        </footer>

    </main>
</div>

<!-- Mobil Menü JavaScript -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');
        const toggleBtn = document.getElementById('toggleSidebar');
        const closeBtn = document.getElementById('closeSidebar');

        function openSidebar() {
            sidebar.classList.add('active');
            overlay.classList.add('active');
            document.body.style.overflow = 'hidden'; // Sayfa kaymasını engelle
        }

        function closeSidebar() {
            sidebar.classList.remove('active');
            overlay.classList.remove('active');
            document.body.style.overflow = 'auto';
        }

        if(toggleBtn) toggleBtn.addEventListener('click', openSidebar);
        if(closeBtn) closeBtn.addEventListener('click', closeSidebar);
        if(overlay) overlay.addEventListener('click', closeSidebar);
    });
</script>

</body>
</html>