<?php
require_once '../private/config.php';

// Oturum Kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$message = "";
$messageType = "";

// --- İŞLEM: VARSAYILAN YAPMA ---
if (isset($_GET['set_default'])) {
    $id = intval($_GET['set_default']);
    try {
        // Hepsini 0 yap
        $db->query("UPDATE para_birimleri SET varsayilan = 0");
        // Seçileni 1 yap ve kurunu 1.00'e sabitle (Ana para birimi her zaman 1'dir)
        $stmt = $db->prepare("UPDATE para_birimleri SET varsayilan = 1, kur = 1.0000 WHERE id = ?");
        $stmt->execute([$id]);
        
        $message = "Varsayılan para birimi değiştirildi. Lütfen diğer kurları buna göre güncelleyiniz.";
        $messageType = "success";
    } catch (PDOException $e) {
        $message = "Hata: " . $e->getMessage();
        $messageType = "error";
    }
}

// --- İŞLEM: SİLME ---
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    
    // Varsayılan para birimi silinemez kontrolü
    $check = $db->prepare("SELECT varsayilan FROM para_birimleri WHERE id = ?");
    $check->execute([$id]);
    $isDefault = $check->fetchColumn();

    if ($isDefault) {
        $message = "Varsayılan para birimi silinemez! Önce başka bir birimi varsayılan yapın.";
        $messageType = "error";
    } else {
        $stmt = $db->prepare("DELETE FROM para_birimleri WHERE id = ?");
        if ($stmt->execute([$id])) {
            header("Location: para-birimi-ekle-duzenle-ayar.php?msg=deleted");
            exit;
        }
    }
}

// --- İŞLEM: KAYDETME / GÜNCELLEME ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $p_id = isset($_POST['p_id']) ? intval($_POST['p_id']) : 0;
    
    $baslik = trim($_POST['baslik']);
    $kod = strtoupper(trim($_POST['kod']));
    $sembol = trim($_POST['sembol']);
    $kur = floatval($_POST['kur']);
    $sira = intval($_POST['sira']);
    
    // DÜZELTME: Select kutusu '0' gönderirse isset true döner ama değer 0'dır. Bu yüzden intval kullanıyoruz.
    $durum = isset($_POST['durum']) ? intval($_POST['durum']) : 0;

    // Eğer bu varsayılan para birimi ise kur zorla 1 olmalı
    if ($p_id > 0) {
        $checkDef = $db->prepare("SELECT varsayilan FROM para_birimleri WHERE id = ?");
        $checkDef->execute([$p_id]);
        if($checkDef->fetchColumn() == 1) {
            $kur = 1.0000;
        }
    }

    try {
        if ($p_id > 0) {
            // GÜNCELLEME
            $sql = "UPDATE para_birimleri SET baslik=?, kod=?, sembol=?, kur=?, sira=?, durum=? WHERE id=?";
            $stmt = $db->prepare($sql);
            $stmt->execute([$baslik, $kod, $sembol, $kur, $sira, $durum, $p_id]);
            $message = "Para birimi güncellendi.";
        } else {
            // EKLEME
            // İlk eklenen kayıt mı? Eğer tablo boşsa bunu varsayılan yap.
            $count = $db->query("SELECT COUNT(*) FROM para_birimleri")->fetchColumn();
            $varsayilan = ($count == 0) ? 1 : 0;
            if($varsayilan) $kur = 1.0000;

            $sql = "INSERT INTO para_birimleri (baslik, kod, sembol, kur, sira, durum, varsayilan) VALUES (?, ?, ?, ?, ?, ?, ?)";
            $stmt = $db->prepare($sql);
            $stmt->execute([$baslik, $kod, $sembol, $kur, $sira, $durum, $varsayilan]);
            $message = "Yeni para birimi eklendi.";
        }
        $messageType = "success";
        
        // Temiz sayfa için yönlendirme (Edit modunda kalmaması için veya mesajı göstermek için)
        if (!isset($_GET['edit'])) {
             // header("Refresh: 1; url=para-birimi-ekle-duzenle-ayar.php");
        }

    } catch (PDOException $e) {
        $message = "Veritabanı Hatası: " . $e->getMessage();
        $messageType = "error";
    }
}

// --- LİSTELEME ---
$currencies = $db->query("SELECT * FROM para_birimleri ORDER BY sira ASC")->fetchAll();

// Varsayılan para birimini bul (Kur hesaplama notu için)
$defaultCurrency = "TL";
foreach($currencies as $c) {
    if($c['varsayilan'] == 1) { $defaultCurrency = $c['kod']; break; }
}

// --- DÜZENLEME VERİSİ ---
$editData = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $stmt = $db->prepare("SELECT * FROM para_birimleri WHERE id = ?");
    $stmt->execute([$id]);
    $editData = $stmt->fetch();
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Para Birimi Ayarları | Panel</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/para-birimi-ekle-duzenle-ayar.css">
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <h2>Para Birimi Yönetimi</h2>
            </div>
            <div class="user-info">
                <span>Hoş geldin, <strong><?php echo $_SESSION['admin_username'] ?? 'Yönetici'; ?></strong></span>
            </div>
        </header>
        
        <div class="content-body">
            
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?>">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <div class="page-grid">
                
                <!-- SOL TARAF: FORM -->
                <div class="form-section">
                    <div class="panel-card">
                        <div class="card-header">
                            <h3>
                                <i class="fa-solid fa-coins"></i> 
                                <?php echo $editData ? 'Para Birimini Düzenle' : 'Yeni Para Birimi Ekle'; ?>
                            </h3>
                            <?php if($editData): ?>
                                <a href="para-birimi-ekle-duzenle-ayar.php" class="btn-xs btn-outline">İptal</a>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <?php if($editData): ?>
                                    <input type="hidden" name="p_id" value="<?php echo $editData['id']; ?>">
                                <?php endif; ?>

                                <div class="form-group">
                                    <label>Para Birimi Adı</label>
                                    <input type="text" name="baslik" required value="<?php echo $editData['baslik'] ?? ''; ?>" placeholder="Örn: Amerikan Doları">
                                </div>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Kod (ISO)</label>
                                        <input type="text" name="kod" required value="<?php echo $editData['kod'] ?? ''; ?>" placeholder="USD, EUR" maxlength="3" style="text-transform:uppercase;">
                                    </div>
                                    <div class="form-group col">
                                        <label>Sembol</label>
                                        <input type="text" name="sembol" value="<?php echo $editData['sembol'] ?? ''; ?>" placeholder="$, €">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label>Kur Değeri</label>
                                    <div class="input-with-text">
                                        <span class="prefix">1 <?php echo (isset($editData['kod']) && $editData['kod']) ? $editData['kod'] : 'Birim'; ?> =</span>
                                        <input type="number" step="0.0001" name="kur" required value="<?php echo $editData['kur'] ?? '1.0000'; ?>" <?php echo (isset($editData) && $editData['varsayilan'] == 1) ? 'readonly' : ''; ?>>
                                        <span class="suffix"><?php echo $defaultCurrency; ?></span>
                                    </div>
                                    <small class="helper-text">
                                        <?php if(isset($editData) && $editData['varsayilan'] == 1): ?>
                                            <span style="color:#e67e22;">* Varsayılan para biriminin kuru her zaman 1.00'dir.</span>
                                        <?php else: ?>
                                            Sitenin ana para birimi <b><?php echo $defaultCurrency; ?></b> olduğu için, buraya 1 birimin kaç <?php echo $defaultCurrency; ?> ettiğini yazın.
                                        <?php endif; ?>
                                    </small>
                                </div>

                                <div class="form-row align-center">
                                    <div class="form-group col">
                                        <label>Sıra No</label>
                                        <input type="number" name="sira" value="<?php echo $editData['sira'] ?? '0'; ?>">
                                    </div>
                                    <div class="form-group col">
                                        <label>Durum</label>
                                        <!-- DÜZELTME: Basit Select Kutusu -->
                                        <select name="durum" style="width: 100%; padding: 10px 12px; border: 1px solid #d1d5db; border-radius: 6px; background-color: #fff; color: #374151;">
                                            <option value="1" <?php echo (!isset($editData) || $editData['durum'] == 1) ? 'selected' : ''; ?>>Aktif</option>
                                            <option value="0" <?php echo (isset($editData) && $editData['durum'] == 0) ? 'selected' : ''; ?>>Pasif</option>
                                        </select>
                                    </div>
                                </div>

                                <button type="submit" class="save-btn btn-full">
                                    <i class="fa-solid fa-floppy-disk"></i> Kaydet
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- SAĞ TARAF: LİSTE -->
                <div class="list-section">
                    <div class="panel-card">
                        <div class="card-header">
                            <h3><i class="fa-solid fa-list-ul"></i> Para Birimleri</h3>
                        </div>
                        <div class="card-body p-0 table-responsive">
                            <table class="data-table">
                                <thead>
                                    <tr>
                                        <th>Başlık</th>
                                        <th>Kod</th>
                                        <th>Sembol</th>
                                        <th>Kur</th>
                                        <th class="text-center">Varsayılan</th>
                                        <th>Durum</th>
                                        <th width="90">İşlem</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($currencies as $cur): ?>
                                        <tr class="<?php echo $cur['varsayilan'] == 1 ? 'row-default' : ''; ?>">
                                            <td><strong><?php echo $cur['baslik']; ?></strong></td>
                                            <td><span class="badge-code"><?php echo $cur['kod']; ?></span></td>
                                            <td><?php echo $cur['sembol']; ?></td>
                                            <td>
                                                <?php echo number_format($cur['kur'], 4); ?>
                                            </td>
                                            <td class="text-center">
                                                <?php if($cur['varsayilan'] == 1): ?>
                                                    <span class="badge-default"><i class="fa-solid fa-check-circle"></i> Varsayılan</span>
                                                <?php else: ?>
                                                    <a href="?set_default=<?php echo $cur['id']; ?>" class="btn-make-default" title="Varsayılan Yap" onclick="return confirm('Sitenin ana para birimini <?php echo $cur['kod']; ?> yapmak istediğine emin misin? Tüm kurları buna göre güncellemen gerekecek!')">
                                                        Seç
                                                    </a>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($cur['durum'] == 1): ?>
                                                    <span class="dot status-active"></span>
                                                <?php else: ?>
                                                    <span class="dot status-passive"></span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="action-buttons">
                                                    <a href="?edit=<?php echo $cur['id']; ?>" class="btn-icon btn-edit"><i class="fa-solid fa-pen"></i></a>
                                                    <?php if($cur['varsayilan'] != 1): ?>
                                                        <a href="?delete=<?php echo $cur['id']; ?>" class="btn-icon btn-delete" onclick="return confirm('Silmek istediğine emin misin?')"><i class="fa-solid fa-trash"></i></a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <div class="info-note">
                        <i class="fa-solid fa-circle-info"></i> 
                        <strong>Bilgi:</strong> "Varsayılan" olarak seçilen para birimi sitenin ana kurudur. Diğer para birimlerinin kurlarını (Multiplier) bu ana para birimine göre girmeniz gerekir.
                    </div>
                </div>

            </div>
        </div>
        
        <footer class="panel-footer">
            &copy; <?php echo date("Y"); ?> Yönetim Paneli
        </footer>
    </main>
</div>

<script>
    // Mobil Menü
    const toggleBtn = document.getElementById('toggleSidebar');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            document.getElementById('sidebar').classList.add('active');
            document.getElementById('sidebarOverlay').classList.add('active');
        });
    }
    const overlay = document.getElementById('sidebarOverlay');
    if(overlay) {
        overlay.addEventListener('click', () => {
            document.getElementById('sidebar').classList.remove('active');
            overlay.classList.remove('active');
        });
    }
</script>
</body>
</html>