<?php
require_once '../private/config.php';

// Oturum Kontrolü (Admin)
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$message = "";
$messageType = "";

// 1. ID KONTROLÜ
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: siparisler.php");
    exit;
}
$sid = intval($_GET['id']);

// --- İŞLEM: DURUM VE KARGO GÜNCELLEME ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_order'])) {
    $new_status = $_POST['durum'];
    $kargo_firma = $_POST['kargo_firma'];
    $takip_no = trim($_POST['kargo_takip_no']);

    $stmt = $db->prepare("UPDATE siparisler SET durum = ?, kargo_firma = ?, kargo_takip_no = ? WHERE id = ?");
    if($stmt->execute([$new_status, $kargo_firma, $takip_no, $sid])) {
        $message = "Sipariş bilgileri başarıyla güncellendi.";
        $messageType = "success";
    }
}

// 2. VERİLERİ ÇEK
$sqlSiparis = "SELECT s.*, kf.firma_adi as secilen_kargo_adi 
               FROM siparisler s 
               LEFT JOIN kargo_firmalari kf ON s.kargo_id = kf.id 
               WHERE s.id = $sid";

try {
    $siparis = $db->query($sqlSiparis)->fetch(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $siparis = $db->query("SELECT * FROM siparisler WHERE id = $sid")->fetch(PDO::FETCH_ASSOC);
    $siparis['secilen_kargo_adi'] = null;
}

if (!$siparis) { die("Sipariş bulunamadı."); }

// Sipariş Ürünlerini Çek
$sqlUrunler = "SELECT su.*, u.ana_resim, u.kdv_orani as aktif_kdv_orani 
               FROM siparis_urunler su 
               LEFT JOIN urunler u ON su.urun_id = u.id 
               WHERE su.siparis_id = $sid";
$urunler = $db->query($sqlUrunler)->fetchAll(PDO::FETCH_ASSOC);

$kargolar = $db->query("SELECT * FROM kargo_firmalari WHERE durum = 1 ORDER BY sira ASC")->fetchAll(PDO::FETCH_ASSOC);

// Para birimi sembolünü çekelim
$defaultCurrency = $db->query("SELECT * FROM para_birimleri WHERE varsayilan=1 AND durum=1")->fetch(PDO::FETCH_ASSOC);
$sembol = $defaultCurrency['sembol'] ?? '₺'; 

// Veritabanındaki net kalemleri alıyoruz
$final_urunler_toplami = $siparis['urunler_toplami'] ?? 0;
$final_net_tutar = $siparis['net_tutar'] ?? 0;
$final_kdv_toplam = $siparis['kdv_tutar'] ?? 0;
$final_indirim = $siparis['indirim_tutari'] ?? 0;
$used_coupon = $siparis['kupon_kodu'] ?? null;
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sipariş #<?php echo $siparis['siparis_kodu']; ?> | Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/siparis-detay.css?v=<?php echo time(); ?>">
    <style>
        .status-select-detail { width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #cbd5e1; font-weight: 700; text-transform: uppercase; font-size: 0.85rem; background-color: #f8fafc; }
        .form-select, .form-control-input { width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #cbd5e1; font-size: 0.9rem; }
        .btn-update-detail { background: #10b981; color: #fff; border: none; padding: 12px 25px; border-radius: 8px; font-weight: 700; cursor: pointer; transition: .2s; display: inline-flex; align-items: center; gap: 8px; }
        .btn-update-detail:hover { background: #059669; }
        .selected-cargo-badge { display: block; margin-top: 8px; font-size: 0.8rem; color: #2563eb; background: #eff6ff; padding: 8px 12px; border-radius: 6px; border: 1px solid #dbeafe; }
        .text-green { color: #10b981 !important; font-weight: 600; }
        .text-danger { color: #ef4444 !important; font-weight: 600; }
        /* Kupon Etiketi Stili */
        .coupon-tag { 
            font-size: 0.75rem; 
            background: #fef2f2; 
            color: #ef4444; 
            border: 1px dashed #fca5a5; 
            padding: 2px 8px; 
            border-radius: 4px; 
            font-weight: 700; 
            margin-left: 5px;
            display: inline-flex;
            align-items: center;
            gap: 4px;
        }
    </style>
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar no-print">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <a href="siparisler.php" class="back-btn"><i class="fa-solid fa-arrow-left"></i></a>
                <h2>Sipariş Detayı <small style="font-weight:400; color:#64748b;">#<?php echo $siparis['siparis_kodu']; ?></small></h2>
            </div>
            <div class="header-actions">
                <button onclick="window.print()" class="btn-print"><i class="fa-solid fa-print"></i> Hazırlama Fişi Yazdır</button>
            </div>
        </header>
        
        <div class="content-body">
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?> no-print">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <div class="detail-grid">
                <div class="main-info">
                    <div class="panel-card">
                        <div class="card-header"><h3><i class="fa-solid fa-box"></i> Sipariş İçeriği</h3></div>
                        <div class="table-responsive">
                            <table class="order-items-table">
                                <thead>
                                    <tr>
                                        <th width="70">Görsel</th>
                                        <th>Ürün Bilgisi</th>
                                        <th class="text-right">Birim Fiyat</th>
                                        <th class="text-center">KDV</th>
                                        <th class="text-center">Adet</th>
                                        <th class="text-right">Toplam</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($urunler as $u): ?>
                                    <tr>
                                        <td><div class="prod-img"><img src="../uploads/urunler/<?php echo $u['ana_resim']; ?>" onerror="this.src='https://placehold.co/60x60?text=Resim+Yok'"></div></td>
                                        <td><a href="../urun-detay.php?id=<?php echo $u['urun_id']; ?>" target="_blank" class="prod-link"><?php echo htmlspecialchars($u['urun_adi']); ?></a></td>
                                        <td class="text-right"><?php echo number_format($u['birim_fiyat'], 2, ',', '.'); ?> <?php echo $sembol; ?></td>
                                        <td class="text-center"><small class="text-muted">%<?php echo intval($u['aktif_kdv_orani'] ?? 20); ?></small></td>
                                        <td class="text-center"><strong>x<?php echo $u['miktar']+0; ?></strong></td>
                                        <td class="text-right" style="font-weight:700; color:#0f172a;"><?php echo number_format($u['birim_fiyat'] * $u['miktar'], 2, ',', '.'); ?> <?php echo $sembol; ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="panel-card no-print mt-20">
                        <div class="card-header"><h3><i class="fa-solid fa-truck-ramp-box"></i> Operasyon ve Kargo Yönetimi</h3></div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <div class="form-row">
                                    <div class="form-group">
                                        <label>Sipariş Durumu</label>
                                        <select name="durum" class="status-select-detail">
                                            <option value="Ödeme Bekliyor" <?php echo $siparis['durum']=='Ödeme Bekliyor'?'selected':''; ?>>Ödeme Bekliyor</option>
                                            <option value="Bekliyor" <?php echo $siparis['durum']=='Bekliyor'?'selected':''; ?>>Bekliyor (Onay)</option>
                                            <option value="Hazırlanıyor" <?php echo $siparis['durum']=='Hazırlanıyor'?'selected':''; ?>>Hazırlanıyor</option>
                                            <option value="Kargoya Verildi" <?php echo $siparis['durum']=='Kargoya Verildi'?'selected':''; ?>>Kargoya Verildi</option>
                                            <option value="Tamamlandı" <?php echo $siparis['durum']=='Tamamlandı'?'selected':''; ?>>Tamamlandı</option>
                                            <option value="İptal" <?php echo $siparis['durum']=='İptal'?'selected':''; ?>>İptal Edildi</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Gönderim Yapılan Kargo</label>
                                        <select name="kargo_firma" class="form-select">
                                            <option value="">-- Kargo Seçin --</option>
                                            <?php foreach($kargolar as $kf): ?>
                                                <option value="<?php echo $kf['firma_adi']; ?>" <?php echo ($siparis['kargo_firma'] == $kf['firma_adi']) ? 'selected' : ''; ?>><?php echo $kf['firma_adi']; ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <?php if(isset($siparis['secilen_kargo_adi']) && $siparis['secilen_kargo_adi']): ?>
                                            <span class="selected-cargo-badge"><i class="fa-solid fa-info-circle"></i> Müşteri Tercihi: <strong><?php echo $siparis['secilen_kargo_adi']; ?></strong></span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group">
                                        <label>Kargo Takip No</label>
                                        <input type="text" name="kargo_takip_no" class="form-control-input" value="<?php echo htmlspecialchars($siparis['kargo_takip_no'] ?? ''); ?>" placeholder="Takip numarasını girin">
                                    </div>
                                </div>
                                <div class="text-right mt-20"><button type="submit" name="update_order" class="btn-update-detail"><i class="fa-solid fa-save"></i> Bilgileri Güncelle</button></div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="side-info">
                    <div class="panel-card">
                        <div class="card-header"><h3><i class="fa-solid fa-user-tag"></i> Müşteri Bilgileri</h3></div>
                        <div class="card-body customer-summary">
                            <div class="c-row"><strong>Ad Soyad:</strong> <span><?php echo $siparis['ad_soyad']; ?></span></div>
                            <div class="c-row"><strong>E-Posta:</strong> <span><?php echo $siparis['email']; ?></span></div>
                            <div class="c-row"><strong>Telefon:</strong> <span><?php echo $siparis['telefon']; ?></span></div>
                            <div class="c-row"><strong>Grup:</strong> 
                                <?php 
                                    if($siparis['bayi_id']) echo '<span class="badge badge-dealer">Bayi</span>';
                                    elseif($siparis['uye_id']) echo '<span class="badge badge-member">Üye</span>';
                                    else echo '<span class="badge badge-guest">Ziyaretçi</span>';
                                ?>
                            </div>
                            <div class="address-box">
                                <strong>Teslimat Adresi:</strong>
                                <p><?php echo nl2br(htmlspecialchars($siparis['adres'])); ?></p>
                                <p style="margin-top:5px; font-weight:700; color:#1e293b;"><?php echo strtoupper($siparis['ilce'] ?? ''); ?> / <?php echo strtoupper($siparis['il'] ?? ''); ?></p>
                            </div>
                        </div>
                    </div>

                    <div class="panel-card">
                        <div class="card-header"><h3><i class="fa-solid fa-receipt"></i> Sipariş Özeti</h3></div>
                        <div class="card-body">
                            <div class="summary-row"><span>Sepet Toplamı:</span> <span><?php echo number_format($final_urunler_toplami, 2, ',', '.'); ?> <?php echo $sembol; ?></span></div>
                            <div class="summary-row"><span>Ara Toplam (Net):</span> <span><?php echo number_format($final_net_tutar, 2, ',', '.'); ?> <?php echo $sembol; ?></span></div>

                            <?php if($final_indirim > 0): ?>
                                <div class="summary-row text-danger">
                                    <span>
                                        Toplam İndirimler
                                        <?php if($used_coupon): ?>
                                            <span class="coupon-tag" title="Kupon Kodu Uygulandı"><i class="fa-solid fa-ticket"></i> <?php echo $used_coupon; ?></span>
                                        <?php endif; ?>
                                        :
                                    </span> 
                                    <span>-<?php echo number_format($final_indirim, 2, ',', '.'); ?> <?php echo $sembol; ?></span>
                                </div>
                            <?php endif; ?>

                            <div class="summary-row"><span>KDV Toplamı:</span> <span><?php echo number_format($final_kdv_toplam, 2, ',', '.'); ?> <?php echo $sembol; ?></span></div>
                            <div class="summary-row"><span>Kargo Ücreti:</span> <span><?php echo number_format($siparis['kargo_ucreti'], 2, ',', '.'); ?> <?php echo $sembol; ?></span></div>

                            <?php if($siparis['kapida_odeme_farki'] > 0): ?>
                                <div class="summary-row"><span>Hizmet Bedeli:</span> <span><?php echo number_format($siparis['kapida_odeme_farki'], 2, ',', '.'); ?> <?php echo $sembol; ?></span></div>
                            <?php endif; ?>
                            
                            <div class="grand-total-detail"><span>TOPLAM:</span><span><?php echo number_format($siparis['toplam_tutar'], 2, ',', '.'); ?> <?php echo $sembol; ?></span></div>
                            <div class="payment-method-box"><i class="fa-solid fa-wallet"></i> Ödeme: <strong><?php echo strtoupper($siparis['odeme_tipi'] == 'kk' ? 'Kredi Kartı' : ($siparis['odeme_tipi'] == 'kapida' ? 'Kapıda Ödeme' : 'Havale / EFT')); ?></strong></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <footer class="panel-footer no-print">&copy; <?php echo date("Y"); ?> Katalog Yönetim Paneli</footer>
    </main>
</div>

<script>
    const toggleBtn = document.getElementById('toggleSidebar');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            document.getElementById('sidebar').classList.add('active');
            document.getElementById('sidebarOverlay').classList.add('active');
        });
    }
</script>
</body>
</html>