<?php
require_once '../private/config.php';

// Oturum Kontrolü (Admin)
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// --- 1. VARSAYILAN PARA BİRİMİNİ ÇEK ---
$defaultCurrency = $db->query("SELECT * FROM para_birimleri WHERE varsayilan=1 AND durum=1")->fetch(PDO::FETCH_ASSOC);
if(!$defaultCurrency) {
    $defaultCurrency = ['kur' => 1.0000, 'sembol' => '₺', 'kod' => 'TL'];
}
$defSembol = $defaultCurrency['sembol'];

$message = "";
$messageType = "";

// --- İŞLEM: DURUM GÜNCELLEME ---
if (isset($_POST['update_status'])) {
    $sid = intval($_POST['order_id']);
    $new_status = $_POST['new_status'];
    $stmt = $db->prepare("UPDATE siparisler SET durum = ? WHERE id = ?");
    if($stmt->execute([$new_status, $sid])) {
        $message = "Sipariş durumu güncellendi.";
        $messageType = "success";
    }
}

// --- İŞLEM: SİLME ---
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $db->prepare("DELETE FROM siparis_urunler WHERE siparis_id = ?")->execute([$id]);
    $db->prepare("DELETE FROM siparisler WHERE id = ?")->execute([$id]);
    header("Location: siparisler.php?msg=deleted");
    exit;
}

// --- 2. FİLTRELEME VE SAYFALAMA (KANKACIM BURASI GÜNCELLENDİ) ---
$q = isset($_GET['q']) ? trim($_GET['q']) : '';
$status_f = isset($_GET['status']) ? $_GET['status'] : '';
$group_f = isset($_GET['group']) ? $_GET['group'] : '';
$date_start = isset($_GET['ds']) ? $_GET['ds'] : '';
$date_end = isset($_GET['de']) ? $_GET['de'] : '';

// Sayfalama Ayarları
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
if($page < 1) $page = 1;
$limit = 10; // KANKACIM: İstediğin gibi her sayfada 10 sipariş
$offset = ($page - 1) * $limit;

// --- SQL KURGUSU ---
$sqlBase = " FROM siparisler WHERE 1=1";
$params = [];

if ($q) {
    $sqlBase .= " AND (siparis_kodu LIKE ? OR ad_soyad LIKE ? OR email LIKE ?)";
    $params[] = "%$q%"; $params[] = "%$q%"; $params[] = "%$q%";
}
if ($status_f) {
    $sqlBase .= " AND durum = ?";
    $params[] = $status_f;
}
if ($group_f !== '') {
    if($group_f == 'guest') $sqlBase .= " AND uye_id IS NULL AND bayi_id IS NULL";
    elseif($group_f == 'member') $sqlBase .= " AND uye_id IS NOT NULL";
    elseif($group_f == 'dealer') $sqlBase .= " AND bayi_id IS NOT NULL";
}
if ($date_start) {
    $sqlBase .= " AND siparis_tarihi >= ?";
    $params[] = $date_start . " 00:00:00";
}
if ($date_end) {
    $sqlBase .= " AND siparis_tarihi <= ?";
    $params[] = $date_end . " 23:59:59";
}

// Toplam Kayıt Sayısını Bul
$totalCount = $db->prepare("SELECT COUNT(*) " . $sqlBase);
$totalCount->execute($params);
$totalRecords = $totalCount->fetchColumn();
$totalPages = ceil($totalRecords / $limit);

// Verileri Çek
$sql = "SELECT * " . $sqlBase . " ORDER BY id DESC LIMIT $limit OFFSET $offset";
$stmt = $db->prepare($sql);
$stmt->execute($params);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

// İstatistikler (Filtreden bağımsız genel durum)
$stats = $db->query("SELECT 
    COUNT(*) as toplam,
    SUM(CASE WHEN durum = 'Bekliyor' THEN 1 ELSE 0 END) as bekleyen,
    SUM(CASE WHEN durum = 'Hazırlanıyor' THEN 1 ELSE 0 END) as hazir,
    SUM(toplam_tutar) as ciro
    FROM siparisler")->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sipariş Yönetimi | Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/siparisler.css?v=<?php echo time(); ?>">
    <style>
        /* KANKACIM: 085.PNG'deki taşma sorununu çözen yeni Grid CSS */
        .filter-row {
            display: grid;
            grid-template-columns: 1.5fr 1fr 1fr 1fr 1fr auto;
            gap: 15px;
            align-items: flex-end;
        }
        @media (max-width: 1200px) {
            .filter-row { grid-template-columns: 1fr 1fr 1fr; }
        }
        @media (max-width: 768px) {
            .filter-row { grid-template-columns: 1fr; }
        }
        
        .customer-link { color: #1e293b; text-decoration: none; font-weight: 700; transition: .2s; }
        .customer-link:hover { color: #2563eb; text-decoration: underline; }

        /* Sayfalama Stilleri */
        .pagination-container { display: flex; justify-content: space-between; align-items: center; padding: 20px; background: #fff; border-top: 1px solid #f1f5f9; }
        .page-links { display: flex; gap: 5px; }
        .page-btn { padding: 6px 12px; border-radius: 6px; border: 1px solid #e2e8f0; text-decoration: none; color: #475569; font-size: 0.85rem; font-weight: 600; transition: .2s; }
        .page-btn:hover { background: #f8fafc; color: #2563eb; }
        .page-btn.active { background: #2563eb; color: #fff; border-color: #2563eb; }
    </style>
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <h2>Sipariş Yönetimi</h2>
            </div>
            <div class="user-info">
                <span>Hoş geldin, <strong><?php echo $_SESSION['admin_username'] ?? 'Yönetici'; ?></strong></span>
            </div>
        </header>
        
        <div class="content-body">
            
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?>">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <!-- ÜST İSTATİSTİK KARTLARI -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon purple"><i class="fa-solid fa-cart-shopping"></i></div>
                    <div class="stat-info">
                        <h3><?php echo $stats['toplam']; ?></h3>
                        <p>Toplam Sipariş</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon orange"><i class="fa-solid fa-clock"></i></div>
                    <div class="stat-info">
                        <h3><?php echo $stats['bekleyen'] ?? 0; ?></h3>
                        <p>Bekleyen Onay</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon blue"><i class="fa-solid fa-gears"></i></div>
                    <div class="stat-info">
                        <h3><?php echo $stats['hazir'] ?? 0; ?></h3>
                        <p>Hazırlananlar</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon green"><i class="fa-solid fa-money-bill-trend-up"></i></div>
                    <div class="stat-info">
                        <h3><?php echo number_format($stats['ciro'] ?? 0, 2, ',', '.'); ?> <?php echo $defSembol; ?></h3>
                        <p>Toplam Ciro</p>
                    </div>
                </div>
            </div>

            <!-- FİLTRELEME ALANI -->
            <div class="panel-card filter-card mt-20">
                <form method="GET" action="" class="filter-form">
                    <div class="filter-row">
                        <div class="f-group">
                            <label>Sipariş Ara</label>
                            <div class="input-with-icon">
                                <i class="fa-solid fa-search"></i>
                                <input type="text" name="q" value="<?php echo htmlspecialchars($q); ?>" placeholder="Kod veya müşteri adı...">
                            </div>
                        </div>
                        <div class="f-group">
                            <label>Sipariş Durumu</label>
                            <select name="status">
                                <option value="">Tüm Durumlar</option>
                                <option value="Ödeme Bekliyor" <?php echo $status_f=='Ödeme Bekliyor'?'selected':''; ?>>Ödeme Bekliyor</option>
                                <option value="Bekliyor" <?php echo $status_f=='Bekliyor'?'selected':''; ?>>Bekliyor (Onay)</option>
                                <option value="Hazırlanıyor" <?php echo $status_f=='Hazırlanıyor'?'selected':''; ?>>Hazırlanıyor</option>
                                <option value="Kargoya Verildi" <?php echo $status_f=='Kargoya Verildi'?'selected':''; ?>>Kargoya Verildi</option>
                                <option value="Tamamlandı" <?php echo $status_f=='Tamamlandı'?'selected':''; ?>>Tamamlandı</option>
                                <option value="İptal" <?php echo $status_f=='İptal'?'selected':''; ?>>İptal Edildi</option>
                            </select>
                        </div>
                        <div class="f-group">
                            <label>Üye Grubu</label>
                            <select name="group">
                                <option value="">Tüm Gruplar</option>
                                <option value="guest" <?php echo $group_f=='guest'?'selected':''; ?>>Misafir</option>
                                <option value="member" <?php echo $group_f=='member'?'selected':''; ?>>Üye</option>
                                <option value="dealer" <?php echo $group_f=='dealer'?'selected':''; ?>>Bayi (B2B)</option>
                            </select>
                        </div>
                        <div class="f-group">
                            <label>Başlangıç</label>
                            <input type="date" name="ds" value="<?php echo $date_start; ?>">
                        </div>
                        <div class="f-group">
                            <label>Bitiş</label>
                            <input type="date" name="de" value="<?php echo $date_end; ?>">
                        </div>
                        <div class="f-actions">
                            <button type="submit" class="btn-filter">Filtrele</button>
                        </div>
                    </div>
                </form>
            </div>

            <!-- SİPARİŞ LİSTESİ -->
            <div class="panel-card mt-20">
                <div class="card-header">
                    <h3><i class="fa-solid fa-list-check"></i> Sipariş Kayıtları</h3>
                </div>
                <div class="table-responsive">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th width="120">Sipariş Kodu</th>
                                <th>Müşteri Bilgisi</th>
                                <th>Grup</th>
                                <th>Tutar</th>
                                <th>Ödeme</th>
                                <th>Tarih</th>
                                <th>Durum</th>
                                <th width="100">İşlem</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($orders as $row): ?>
                                <?php 
                                    $groupClass = 'g-guest'; $groupIcon = 'fa-user-slash'; $groupName = 'Misafir';
                                    if($row['bayi_id']) { $groupClass = 'g-dealer'; $groupIcon = 'fa-briefcase'; $groupName = 'Bayi'; }
                                    elseif($row['uye_id']) { $groupClass = 'g-member'; $groupIcon = 'fa-user-check'; $groupName = 'Üye'; }
                                ?>
                                <tr>
                                    <td><strong>#<?php echo $row['siparis_kodu']; ?></strong></td>
                                    <td>
                                        <div class="customer-info">
                                            <!-- KANKACIM: Müşteri adına tıklayınca sipariş detayına gitme linki eklendi -->
                                            <a href="siparis-detay.php?id=<?php echo $row['id']; ?>" class="customer-link"><?php echo $row['ad_soyad']; ?></a>
                                            <span><?php echo $row['il']; ?> / <?php echo $row['ilce']; ?></span>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="group-pill <?php echo $groupClass; ?>" title="<?php echo $groupName; ?>">
                                            <i class="fa-solid <?php echo $groupIcon; ?>"></i>
                                        </span>
                                    </td>
                                    <td><strong><?php echo number_format($row['toplam_tutar'], 2, ',', '.'); ?> <?php echo $defSembol; ?></strong></td>
                                    <td><small><?php echo strtoupper($row['odeme_tipi'] ?? 'Havale'); ?></small></td>
                                    <td>
                                        <div class="date-info">
                                            <?php echo date('d.m.Y', strtotime($row['siparis_tarihi'])); ?>
                                            <small><?php echo date('H:i', strtotime($row['siparis_tarihi'])); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <form method="POST" action="" class="status-form">
                                            <input type="hidden" name="order_id" value="<?php echo $row['id']; ?>">
                                            <select name="new_status" onchange="this.form.submit()" class="status-select <?php echo strtolower(str_replace(' ', '-', $row['durum'])); ?>">
                                                <option value="Ödeme Bekliyor" <?php echo $row['durum']=='Ödeme Bekliyor'?'selected':''; ?>>Ödeme Bekliyor</option>
                                                <option value="Bekliyor" <?php echo $row['durum']=='Bekliyor'?'selected':''; ?>>Bekliyor</option>
                                                <option value="Hazırlanıyor" <?php echo $row['durum']=='Hazırlanıyor'?'selected':''; ?>>Hazırlanıyor</option>
                                                <option value="Kargoya Verildi" <?php echo $row['durum']=='Kargoya Verildi'?'selected':''; ?>>Kargoya Verildi</option>
                                                <option value="Tamamlandı" <?php echo $row['durum']=='Tamamlandı'?'selected':''; ?>>Tamamlandı</option>
                                                <option value="İptal" <?php echo $row['durum']=='İptal'?'selected':''; ?>>İptal</option>
                                            </select>
                                            <input type="hidden" name="update_status" value="1">
                                        </form>
                                    </td>
                                    <td>
                                        <div class="action-buttons">
                                            <a href="siparis-detay.php?id=<?php echo $row['id']; ?>" class="btn-icon btn-view" title="Detay"><i class="fa-solid fa-eye"></i></a>
                                            <a href="?delete=<?php echo $row['id']; ?>" class="btn-icon btn-delete" onclick="return confirm('Bu siparişi silmek istediğine emin misin?')" title="Sil"><i class="fa-solid fa-trash"></i></a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            <?php if(empty($orders)): ?>
                                <tr><td colspan="8" class="text-center p-40">Aranan kriterlere uygun sipariş bulunamadı.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- KANKACIM: SAYFALAMA NAVİGASYONU -->
                <?php if($totalPages > 1): ?>
                    <div class="pagination-container">
                        <div class="total-info">Toplam <strong><?php echo $totalRecords; ?></strong> kayıttan <strong><?php echo $offset+1; ?> - <?php echo min($offset+$limit, $totalRecords); ?></strong> arası gösteriliyor.</div>
                        <div class="page-links">
                            <?php if($page > 1): ?>
                                <a href="?page=<?php echo $page-1; ?>&q=<?php echo $q; ?>&status=<?php echo $status_f; ?>&group=<?php echo $group_f; ?>" class="page-btn"><i class="fa-solid fa-angle-left"></i></a>
                            <?php endif; ?>
                            
                            <?php for($i=1; $i<=$totalPages; $i++): ?>
                                <a href="?page=<?php echo $i; ?>&q=<?php echo $q; ?>&status=<?php echo $status_f; ?>&group=<?php echo $group_f; ?>" class="page-btn <?php echo $page == $i ? 'active' : ''; ?>"><?php echo $i; ?></a>
                            <?php endfor; ?>

                            <?php if($page < $totalPages): ?>
                                <a href="?page=<?php echo $page+1; ?>&q=<?php echo $q; ?>&status=<?php echo $status_f; ?>&group=<?php echo $group_f; ?>" class="page-btn"><i class="fa-solid fa-angle-right"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

        </div>
        <footer class="panel-footer">&copy; <?php echo date("Y"); ?> Katalog Yönetim Paneli</footer>
    </main>
</div>

<script>
    const toggleBtn = document.getElementById('toggleSidebar');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            document.getElementById('sidebar').classList.add('active');
            document.getElementById('sidebarOverlay').classList.add('active');
        });
    }
    const overlay = document.getElementById('sidebarOverlay');
    if(overlay) {
        overlay.addEventListener('click', () => {
            document.getElementById('sidebar').classList.remove('active');
            overlay.classList.remove('active');
        });
    }
</script>

</body>
</html>