<?php
// Güvenlik ve Config Dosyası
require_once '../private/config.php';

// Oturum Kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$message = "";
$messageType = ""; // success veya error

// 1. FORM GÖNDERİLDİYSE GÜNCELLEME YAP
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $fiyat_giris_tipi = isset($_POST['fiyat_giris_tipi']) ? intval($_POST['fiyat_giris_tipi']) : 0;
    $fiyat_gosterim_tipi = isset($_POST['fiyat_gosterim_tipi']) ? intval($_POST['fiyat_gosterim_tipi']) : 0;

    try {
        // ID=1 olan satırı güncelliyoruz (Tek satır mantığı)
        $query = $db->prepare("UPDATE site_ayarlari SET fiyat_giris_tipi = :giris, fiyat_gosterim_tipi = :gosterim WHERE id = 1");
        $update = $query->execute([
            ':giris' => $fiyat_giris_tipi,
            ':gosterim' => $fiyat_gosterim_tipi
        ]);

        if ($update) {
            $message = "Ayarlar başarıyla güncellendi.";
            $messageType = "success";
        } else {
            $message = "Güncelleme sırasında bir sorun oluştu.";
            $messageType = "error";
        }
    } catch (PDOException $e) {
        $message = "Veritabanı Hatası: " . $e->getMessage();
        $messageType = "error";
    }
}

// 2. MEVCUT AYARLARI ÇEK
try {
    $stmt = $db->query("SELECT * FROM site_ayarlari WHERE id = 1");
    $ayar = $stmt->fetch();

    // Eğer tablo boşsa varsayılan değerleri ata (Garanti olsun)
    if (!$ayar) {
        $ayar = ['fiyat_giris_tipi' => 0, 'fiyat_gosterim_tipi' => 0];
    }
} catch (PDOException $e) {
    die("Ayarlar çekilemedi.");
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Ayarları | Yönetim Paneli</title>
    
    <!-- Fontlar -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- CSS Dosyaları -->
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <!-- Bu sayfaya özel CSS -->
    <link rel="stylesheet" href="../assets/site-ayarlari.css">
</head>
<body>

<div class="admin-layout">
    
    <!-- Overlay -->
    <div class="overlay" id="sidebarOverlay"></div>

    <!-- Sidebar -->
    <?php include 'sidebar.php'; ?>

    <!-- Ana İçerik -->
    <main class="main-content">
        
        <!-- Header -->
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger">
                    <i class="fa-solid fa-bars"></i>
                </button>
                <h2>Genel Site Ayarları</h2>
            </div>
            
            <div class="user-info">
                <span>Hoş geldin, <strong><?php echo $_SESSION['admin_username'] ?? 'Yönetici'; ?></strong></span>
            </div>
        </header>
        
        <!-- İçerik -->
        <div class="content-body">
            
            <!-- Bilgi Mesajı -->
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?>">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="" class="settings-form">
                
                <!-- Bölüm: Fiyatlandırma Ayarları -->
                <div class="settings-card">
                    <div class="card-header">
                        <h3><i class="fa-solid fa-tags"></i> Fiyatlandırma Yapılandırması</h3>
                        <p>Sitedeki ürün fiyatlarının giriş ve gösterim mantığını buradan belirleyebilirsiniz.</p>
                    </div>

                    <div class="card-body">
                        
                        <!-- Ayar 1: Fiyat Giriş Tipi -->
                        <div class="form-group">
                            <label class="group-label">Panel Fiyat Giriş Tipi</label>
                            <div class="helper-text">Yönetim panelinden ürün eklerken fiyatları nasıl gireceksiniz?</div>
                            
                            <div class="radio-group">
                                <label class="radio-option <?php echo $ayar['fiyat_giris_tipi'] == 0 ? 'selected' : ''; ?>">
                                    <input type="radio" name="fiyat_giris_tipi" value="0" <?php echo $ayar['fiyat_giris_tipi'] == 0 ? 'checked' : ''; ?>>
                                    <div class="radio-content">
                                        <i class="fa-solid fa-calculator"></i>
                                        <span>KDV Hariç Giriş</span>
                                        <small>Örn: 100 TL girersiniz, sistem üzerine KDV ekler.</small>
                                    </div>
                                </label>

                                <label class="radio-option <?php echo $ayar['fiyat_giris_tipi'] == 1 ? 'selected' : ''; ?>">
                                    <input type="radio" name="fiyat_giris_tipi" value="1" <?php echo $ayar['fiyat_giris_tipi'] == 1 ? 'checked' : ''; ?>>
                                    <div class="radio-content">
                                        <i class="fa-solid fa-file-invoice-dollar"></i>
                                        <span>KDV Dahil Giriş</span>
                                        <small>Örn: 118 TL girersiniz, sistem içinden KDV'yi ayırır.</small>
                                    </div>
                                </label>
                            </div>
                        </div>

                        <hr class="divider">

                        <!-- Ayar 2: Fiyat Gösterim Tipi -->
                        <div class="form-group">
                            <label class="group-label">Site Fiyat Gösterim Tipi</label>
                            <div class="helper-text">Müşteriler ürün fiyatlarını sitede nasıl görecek?</div>
                            
                            <div class="radio-group">
                                <label class="radio-option <?php echo $ayar['fiyat_gosterim_tipi'] == 0 ? 'selected' : ''; ?>">
                                    <input type="radio" name="fiyat_gosterim_tipi" value="0" <?php echo $ayar['fiyat_gosterim_tipi'] == 0 ? 'checked' : ''; ?>>
                                    <div class="radio-content">
                                        <i class="fa-solid fa-plus"></i>
                                        <span>+KDV Olarak Göster</span>
                                        <small>Örn: "100 TL + KDV" şeklinde yazar.</small>
                                    </div>
                                </label>

                                <label class="radio-option <?php echo $ayar['fiyat_gosterim_tipi'] == 1 ? 'selected' : ''; ?>">
                                    <input type="radio" name="fiyat_gosterim_tipi" value="1" <?php echo $ayar['fiyat_gosterim_tipi'] == 1 ? 'checked' : ''; ?>>
                                    <div class="radio-content">
                                        <i class="fa-solid fa-percent"></i>
                                        <span>KDV Dahil Göster</span>
                                        <small>Örn: Direkt "118 TL" (KDV Dahil) yazar.</small>
                                    </div>
                                </label>
                            </div>
                        </div>

                    </div>
                    
                    <div class="card-footer">
                        <button type="submit" class="save-btn">
                            <i class="fa-solid fa-floppy-disk"></i> Ayarları Kaydet
                        </button>
                    </div>
                </div>

            </form>
        </div>

        <footer class="panel-footer">
            &copy; <?php echo date("Y"); ?> Katalog Yönetim Paneli - Tüm Hakları Saklıdır.
        </footer>

    </main>
</div>

<!-- JS: Radyo butonları seçilince görsel class ekleme -->
<script>
    document.querySelectorAll('.radio-option input').forEach(radio => {
        radio.addEventListener('change', function() {
            // Aynı gruptaki diğerlerinin 'selected' classını kaldır
            let name = this.name;
            document.querySelectorAll(`input[name="${name}"]`).forEach(el => {
                el.closest('.radio-option').classList.remove('selected');
            });
            // Seçilene ekle
            this.closest('.radio-option').classList.add('selected');
        });
    });

    // Mobil Menü (Panelden alındı)
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    const toggleBtn = document.getElementById('toggleSidebar');
    const closeBtn = document.getElementById('closeSidebar');

    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            sidebar.classList.add('active');
            overlay.classList.add('active');
        });
    }
    if(closeBtn) {
        closeBtn.addEventListener('click', () => {
            sidebar.classList.remove('active');
            overlay.classList.remove('active');
        });
    }
    if(overlay) {
        overlay.addEventListener('click', () => {
            sidebar.classList.remove('active');
            overlay.classList.remove('active');
        });
    }
</script>

</body>
</html>