<?php
require_once '../private/config.php';

// Oturum Kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$message = "";
$messageType = "";

// --- KAYDETME İŞLEMİ ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        $sql = "UPDATE site_tema_ayarlari SET 
                site_url = :site_url,
                kart_buton_bg = :kb_bg,
                kart_buton_text = :kb_txt,
                kart_baslik_renk = :k_baslik,
                kart_fiyat_renk = :k_fiyat,
                kart_ikon_renk = :k_ikon_renk,
                kart_ikon = :k_ikon,
                sidebar_baslik_renk = :s_baslik_renk,
                sidebar_baslik_metin = :s_baslik_txt,
                filtre_buton_renk = :f_renk,
                filtre_buton_ikon = :f_ikon
                WHERE id = 1";
        
        $stmt = $db->prepare($sql);
        $stmt->execute([
            'site_url' => trim($_POST['site_url']),
            'kb_bg' => $_POST['kart_buton_bg'],
            'kb_txt' => $_POST['kart_buton_text'],
            'k_baslik' => $_POST['kart_baslik_renk'],
            'k_fiyat' => $_POST['kart_fiyat_renk'],
            'k_ikon_renk' => $_POST['kart_ikon_renk'],
            'k_ikon' => $_POST['kart_ikon'],
            's_baslik_renk' => $_POST['sidebar_baslik_renk'],
            's_baslik_txt' => $_POST['sidebar_baslik_metin'],
            'f_renk' => $_POST['filtre_buton_renk'],
            'f_ikon' => $_POST['filtre_buton_ikon']
        ]);

        $message = "Tema ayarları başarıyla güncellendi.";
        $messageType = "success";
    } catch (PDOException $e) {
        $message = "Hata: " . $e->getMessage();
        $messageType = "error";
    }
}

// Ayarları Çek
$ayar = $db->query("SELECT * FROM site_tema_ayarlari WHERE id = 1")->fetch();
if (!$ayar) {
    // Kayıt yoksa varsayılanlar (Hata önleyici)
    $ayar = [
        'site_url' => '', 'kart_buton_bg' => '#2563eb', 'kart_buton_text' => '#ffffff',
        'kart_baslik_renk' => '#111827', 'kart_fiyat_renk' => '#2563eb',
        'kart_ikon_renk' => '#ffffff', 'kart_ikon' => 'fa-cart-shopping',
        'sidebar_baslik_renk' => '#111827', 'sidebar_baslik_metin' => 'Kategoriler',
        'filtre_buton_renk' => '#4b5563', 'filtre_buton_ikon' => 'fa-filter'
    ];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Görünüm Ayarları | Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/site-renk-ayarlari.css">
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <h2>Site Görünüm & Renk Ayarları</h2>
            </div>
            <div class="user-info">
                <span>Hoş geldin, <strong><?php echo $_SESSION['admin_username'] ?? 'Yönetici'; ?></strong></span>
            </div>
        </header>
        
        <div class="content-body">
            
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?>">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <div class="page-grid">
                
                <!-- SOL TARAF: AYAR FORMU -->
                <div class="form-section">
                    <form method="POST" action="">
                        
                        <!-- 1. GENEL AYARLAR -->
                        <div class="panel-card mb-20">
                            <div class="card-header">
                                <h3><i class="fa-solid fa-globe"></i> Genel Ayarlar</h3>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Site URL Adresi</label>
                                    <input type="text" name="site_url" value="<?php echo $ayar['site_url']; ?>" placeholder="https://www.siteniz.com">
                                    <small>Logo ve anasayfa yönlendirmeleri için kullanılır.</small>
                                </div>
                            </div>
                        </div>

                        <!-- 2. ÜRÜN KARTI TASARIMI -->
                        <div class="panel-card mb-20">
                            <div class="card-header">
                                <h3><i class="fa-solid fa-box-open"></i> Ürün Kartı Tasarımı</h3>
                            </div>
                            <div class="card-body">
                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Ürün Başlık Rengi</label>
                                        <div class="color-input-wrapper">
                                            <input type="color" name="kart_baslik_renk" id="in_baslik" value="<?php echo $ayar['kart_baslik_renk']; ?>">
                                            <span class="color-code"><?php echo $ayar['kart_baslik_renk']; ?></span>
                                        </div>
                                    </div>
                                    <div class="form-group col">
                                        <label>Fiyat Rengi</label>
                                        <div class="color-input-wrapper">
                                            <input type="color" name="kart_fiyat_renk" id="in_fiyat" value="<?php echo $ayar['kart_fiyat_renk']; ?>">
                                            <span class="color-code"><?php echo $ayar['kart_fiyat_renk']; ?></span>
                                        </div>
                                    </div>
                                </div>

                                <hr class="divider">
                                <h4>Sepete Ekle Butonu</h4>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Buton Arka Planı</label>
                                        <div class="color-input-wrapper">
                                            <input type="color" name="kart_buton_bg" id="in_btn_bg" value="<?php echo $ayar['kart_buton_bg']; ?>">
                                            <span class="color-code"><?php echo $ayar['kart_buton_bg']; ?></span>
                                        </div>
                                    </div>
                                    <div class="form-group col">
                                        <label>Buton Yazı Rengi</label>
                                        <div class="color-input-wrapper">
                                            <input type="color" name="kart_buton_text" id="in_btn_text" value="<?php echo $ayar['kart_buton_text']; ?>">
                                            <span class="color-code"><?php echo $ayar['kart_buton_text']; ?></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Simge Rengi</label>
                                        <div class="color-input-wrapper">
                                            <input type="color" name="kart_ikon_renk" id="in_icon_color" value="<?php echo $ayar['kart_ikon_renk']; ?>">
                                            <span class="color-code"><?php echo $ayar['kart_ikon_renk']; ?></span>
                                        </div>
                                    </div>
                                    <div class="form-group col">
                                        <label>Buton Simgesi</label>
                                        <div class="icon-selector">
                                            <label class="icon-option">
                                                <input type="radio" name="kart_ikon" value="fa-cart-shopping" <?php echo $ayar['kart_ikon']=='fa-cart-shopping'?'checked':''; ?> onclick="updateIcon(this.value)">
                                                <i class="fa-solid fa-cart-shopping"></i>
                                            </label>
                                            <label class="icon-option">
                                                <input type="radio" name="kart_ikon" value="fa-cart-plus" <?php echo $ayar['kart_ikon']=='fa-cart-plus'?'checked':''; ?> onclick="updateIcon(this.value)">
                                                <i class="fa-solid fa-cart-plus"></i>
                                            </label>
                                            <label class="icon-option">
                                                <input type="radio" name="kart_ikon" value="fa-bag-shopping" <?php echo $ayar['kart_ikon']=='fa-bag-shopping'?'checked':''; ?> onclick="updateIcon(this.value)">
                                                <i class="fa-solid fa-bag-shopping"></i>
                                            </label>
                                            <label class="icon-option">
                                                <input type="radio" name="kart_ikon" value="fa-basket-shopping" <?php echo $ayar['kart_ikon']=='fa-basket-shopping'?'checked':''; ?> onclick="updateIcon(this.value)">
                                                <i class="fa-solid fa-basket-shopping"></i>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- 3. SIDEBAR & FİLTRE -->
                        <div class="panel-card mb-20">
                            <div class="card-header">
                                <h3><i class="fa-solid fa-bars"></i> Sidebar ve Filtreleme</h3>
                            </div>
                            <div class="card-body">
                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Kategoriler Başlığı</label>
                                        <input type="text" name="sidebar_baslik_metin" id="in_cat_title" value="<?php echo $ayar['sidebar_baslik_metin']; ?>">
                                    </div>
                                    <div class="form-group col">
                                        <label>Başlık Rengi</label>
                                        <div class="color-input-wrapper">
                                            <input type="color" name="sidebar_baslik_renk" id="in_cat_color" value="<?php echo $ayar['sidebar_baslik_renk']; ?>">
                                            <span class="color-code"><?php echo $ayar['sidebar_baslik_renk']; ?></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Filtrele Buton Rengi</label>
                                        <div class="color-input-wrapper">
                                            <input type="color" name="filtre_buton_renk" id="in_filter_bg" value="<?php echo $ayar['filtre_buton_renk']; ?>">
                                            <span class="color-code"><?php echo $ayar['filtre_buton_renk']; ?></span>
                                        </div>
                                    </div>
                                    <div class="form-group col">
                                        <label>Filtre Simgesi</label>
                                        <div class="icon-selector">
                                            <label class="icon-option">
                                                <input type="radio" name="filtre_buton_ikon" value="fa-filter" <?php echo $ayar['filtre_buton_ikon']=='fa-filter'?'checked':''; ?> onclick="updateFilterIcon(this.value)">
                                                <i class="fa-solid fa-filter"></i>
                                            </label>
                                            <label class="icon-option">
                                                <input type="radio" name="filtre_buton_ikon" value="fa-list" <?php echo $ayar['filtre_buton_ikon']=='fa-list'?'checked':''; ?> onclick="updateFilterIcon(this.value)">
                                                <i class="fa-solid fa-list"></i>
                                            </label>
                                            <label class="icon-option">
                                                <input type="radio" name="filtre_buton_ikon" value="fa-sliders" <?php echo $ayar['filtre_buton_ikon']=='fa-sliders'?'checked':''; ?> onclick="updateFilterIcon(this.value)">
                                                <i class="fa-solid fa-sliders"></i>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <button type="submit" class="save-btn btn-lg btn-full">
                            <i class="fa-solid fa-floppy-disk"></i> Ayarları Kaydet
                        </button>
                    </form>
                </div>

                <!-- SAĞ TARAF: CANLI ÖNİZLEME -->
                <div class="preview-section">
                    <div class="sticky-preview">
                        <h3><i class="fa-solid fa-eye"></i> Canlı Önizleme</h3>
                        <p class="preview-note">Yaptığınız renk değişiklikleri aşağıda anlık olarak simüle edilir.</p>

                        <!-- ÜRÜN KARTI PREVIEW -->
                        <div class="preview-card-box">
                            <div class="preview-label">Ürün Kartı</div>
                            <div class="mock-product-card">
                                <div class="mock-img">
                                    <i class="fa-regular fa-image"></i>
                                </div>
                                <div class="mock-content">
                                    <div class="mock-title" id="prev_title">Örnek Ürün Adı</div>
                                    <div class="mock-brand">Marka Adı</div>
                                    <div class="mock-price" id="prev_price">1.250,00 ₺</div>
                                    <button class="mock-add-btn" id="prev_btn">
                                        <i id="prev_icon" class="fa-solid <?php echo $ayar['kart_ikon']; ?>"></i> Sepete Ekle
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- SIDEBAR PREVIEW -->
                        <div class="preview-card-box mt-20">
                            <div class="preview-label">Sidebar & Filtre</div>
                            <div class="mock-sidebar">
                                <div class="mock-cat-title" id="prev_cat_title"><?php echo $ayar['sidebar_baslik_metin']; ?></div>
                                <ul class="mock-cat-list">
                                    <li>Elektronik</li>
                                    <li>Giyim</li>
                                    <li>Ev & Yaşam</li>
                                </ul>
                                <button class="mock-filter-btn" id="prev_filter_btn">
                                    <i id="prev_filter_icon" class="fa-solid <?php echo $ayar['filtre_buton_ikon']; ?>"></i> Filtrele
                                </button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
        
        <footer class="panel-footer">
            &copy; <?php echo date("Y"); ?> Yönetim Paneli
        </footer>
    </main>
</div>

<!-- JS: Canlı Önizleme Mantığı -->
<script>
    // Renk Değişimlerini İzle
    document.getElementById('in_baslik').addEventListener('input', function() {
        document.getElementById('prev_title').style.color = this.value;
        this.nextElementSibling.innerText = this.value;
    });

    document.getElementById('in_fiyat').addEventListener('input', function() {
        document.getElementById('prev_price').style.color = this.value;
        this.nextElementSibling.innerText = this.value;
    });

    document.getElementById('in_btn_bg').addEventListener('input', function() {
        document.getElementById('prev_btn').style.backgroundColor = this.value;
        this.nextElementSibling.innerText = this.value;
    });

    document.getElementById('in_btn_text').addEventListener('input', function() {
        document.getElementById('prev_btn').style.color = this.value;
        this.nextElementSibling.innerText = this.value;
    });

    document.getElementById('in_icon_color').addEventListener('input', function() {
        document.getElementById('prev_icon').style.color = this.value;
        this.nextElementSibling.innerText = this.value;
    });

    document.getElementById('in_cat_title').addEventListener('input', function() {
        document.getElementById('prev_cat_title').innerText = this.value;
    });

    document.getElementById('in_cat_color').addEventListener('input', function() {
        document.getElementById('prev_cat_title').style.color = this.value;
        this.nextElementSibling.innerText = this.value;
    });

    document.getElementById('in_filter_bg').addEventListener('input', function() {
        document.getElementById('prev_filter_btn').style.backgroundColor = this.value;
        this.nextElementSibling.innerText = this.value;
    });

    // İkon Değişimi
    function updateIcon(iconClass) {
        document.getElementById('prev_icon').className = 'fa-solid ' + iconClass;
    }
    function updateFilterIcon(iconClass) {
        document.getElementById('prev_filter_icon').className = 'fa-solid ' + iconClass;
    }

    // Sayfa Yüklendiğinde Mevcut Renkleri Uygula (PHP'den gelenler zaten value'da ama JS ile style'a basmak için)
    window.onload = function() {
        // Renk inputlarını tetikle
        document.getElementById('in_baslik').dispatchEvent(new Event('input'));
        document.getElementById('in_fiyat').dispatchEvent(new Event('input'));
        document.getElementById('in_btn_bg').dispatchEvent(new Event('input'));
        document.getElementById('in_btn_text').dispatchEvent(new Event('input'));
        document.getElementById('in_icon_color').dispatchEvent(new Event('input'));
        document.getElementById('in_cat_color').dispatchEvent(new Event('input'));
        document.getElementById('in_filter_bg').dispatchEvent(new Event('input'));
    };

    // Mobil Menü
    const toggleBtn = document.getElementById('toggleSidebar');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            document.getElementById('sidebar').classList.add('active');
            document.getElementById('sidebarOverlay').classList.add('active');
        });
    }
    const overlay = document.getElementById('sidebarOverlay');
    if(overlay) {
        overlay.addEventListener('click', () => {
            document.getElementById('sidebar').classList.remove('active');
            overlay.classList.remove('active');
        });
    }
</script>
</body>
</html>