<?php
require_once '../private/config.php';

// Oturum Kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$message = "";
$messageType = "";

// --- İŞLEM: SİLME ---
if (isset($_GET['delete']) && isset($_GET['type'])) {
    $id = intval($_GET['delete']);
    $type = $_GET['type'];
    
    if($type == 'kdv') {
        $stmt = $db->prepare("DELETE FROM urun_kdvler WHERE id = :id");
    } elseif($type == 'birim') {
        $stmt = $db->prepare("DELETE FROM urun_birimler WHERE id = :id");
    }
    
    if (isset($stmt) && $stmt->execute(['id' => $id])) {
        header("Location: stok-birim-kdv-ayar.php?msg=deleted");
        exit;
    }
}

// --- İŞLEM: KDV EKLEME / GÜNCELLEME ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['form_type']) && $_POST['form_type'] == 'kdv') {
    $kdv_id = isset($_POST['kdv_id']) ? intval($_POST['kdv_id']) : 0;
    $kdv_orani = intval($_POST['kdv_orani']);
    $web_servis_kodu = trim($_POST['web_servis_kodu']); // YENİ
    $sira = intval($_POST['sira']);
    $durum = isset($_POST['durum']) ? 1 : 0;
    
    try {
        if ($kdv_id > 0) {
            $sql = "UPDATE urun_kdvler SET kdv_orani=?, web_servis_kodu=?, sira=?, durum=? WHERE id=?";
            $stmt = $db->prepare($sql);
            $stmt->execute([$kdv_orani, $web_servis_kodu, $sira, $durum, $kdv_id]);
            $message = "KDV oranı güncellendi.";
        } else {
            $sql = "INSERT INTO urun_kdvler (kdv_orani, web_servis_kodu, sira, durum) VALUES (?, ?, ?, ?)";
            $stmt = $db->prepare($sql);
            $stmt->execute([$kdv_orani, $web_servis_kodu, $sira, $durum]);
            $message = "Yeni KDV oranı eklendi.";
        }
        $messageType = "success";
    } catch (PDOException $e) {
        $message = "Hata: " . $e->getMessage();
        $messageType = "error";
    }
}

// --- İŞLEM: BİRİM EKLEME / GÜNCELLEME ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['form_type']) && $_POST['form_type'] == 'birim') {
    $birim_id = isset($_POST['birim_id']) ? intval($_POST['birim_id']) : 0;
    $birim_adi = trim($_POST['birim_adi']);
    $web_servis_kodu = trim($_POST['web_servis_kodu']); // YENİ
    $artis_miktari = floatval($_POST['artis_miktari']);
    if($artis_miktari <= 0) $artis_miktari = 1;
    $sira = intval($_POST['sira']);
    $durum = isset($_POST['durum']) ? 1 : 0;
    
    try {
        if ($birim_id > 0) {
            $sql = "UPDATE urun_birimler SET birim_adi=?, web_servis_kodu=?, artis_miktari=?, sira=?, durum=? WHERE id=?";
            $stmt = $db->prepare($sql);
            $stmt->execute([$birim_adi, $web_servis_kodu, $artis_miktari, $sira, $durum, $birim_id]);
            $message = "Birim güncellendi.";
        } else {
            $sql = "INSERT INTO urun_birimler (birim_adi, web_servis_kodu, artis_miktari, sira, durum) VALUES (?, ?, ?, ?, ?)";
            $stmt = $db->prepare($sql);
            $stmt->execute([$birim_adi, $web_servis_kodu, $artis_miktari, $sira, $durum]);
            $message = "Yeni birim eklendi.";
        }
        $messageType = "success";
    } catch (PDOException $e) {
        $message = "Hata: " . $e->getMessage();
        $messageType = "error";
    }
}

// Verileri Çek
$kdvler = $db->query("SELECT * FROM urun_kdvler ORDER BY sira ASC")->fetchAll();
$birimler = $db->query("SELECT * FROM urun_birimler ORDER BY sira ASC")->fetchAll();

// Düzenleme Verisi
$editKdv = null;
$editBirim = null;

if (isset($_GET['edit']) && isset($_GET['type'])) {
    $id = intval($_GET['edit']);
    if ($_GET['type'] == 'kdv') {
        $stmt = $db->prepare("SELECT * FROM urun_kdvler WHERE id = ?");
        $stmt->execute([$id]);
        $editKdv = $stmt->fetch();
    } elseif ($_GET['type'] == 'birim') {
        $stmt = $db->prepare("SELECT * FROM urun_birimler WHERE id = ?");
        $stmt->execute([$id]);
        $editBirim = $stmt->fetch();
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stok ve KDV Ayarları | Panel</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/stok-birim-kdv-ayar.css">
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <h2>Stok ve KDV Tanımları</h2>
            </div>
            <div class="user-info">
                <span>Hoş geldin, <strong><?php echo $_SESSION['admin_username'] ?? 'Yönetici'; ?></strong></span>
            </div>
        </header>
        
        <div class="content-body">
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?>">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <div class="settings-grid">
                
                <!-- SOL SÜTUN: KDV AYARLARI -->
                <div class="settings-column">
                    <!-- KDV FORM -->
                    <div class="panel-card form-card">
                        <div class="card-header">
                            <h3><i class="fa-solid fa-percent"></i> <?php echo $editKdv ? 'KDV Düzenle' : 'KDV Ekle'; ?></h3>
                            <?php if($editKdv): ?>
                                <a href="stok-birim-kdv-ayar.php" class="btn-xs btn-outline">İptal</a>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <input type="hidden" name="form_type" value="kdv">
                                <?php if($editKdv): ?><input type="hidden" name="kdv_id" value="<?php echo $editKdv['id']; ?>"><?php endif; ?>
                                
                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>KDV Oranı (%)</label>
                                        <input type="number" name="kdv_orani" required placeholder="20" value="<?php echo $editKdv['kdv_orani'] ?? ''; ?>">
                                    </div>
                                    <div class="form-group col">
                                        <label>Web Servis Kodu</label>
                                        <input type="text" name="web_servis_kodu" placeholder="WS-KDV20" value="<?php echo $editKdv['web_servis_kodu'] ?? ''; ?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Sıra No</label>
                                    <input type="number" name="sira" value="<?php echo $editKdv['sira'] ?? '0'; ?>">
                                </div>
                                
                                <label class="toggle-switch">
                                    <input type="checkbox" name="durum" <?php echo (!isset($editKdv) || $editKdv['durum'] == 1) ? 'checked' : ''; ?>>
                                    <span class="slider"></span>
                                    <span class="label-text">Aktif</span>
                                </label>
                                
                                <button type="submit" class="save-btn btn-full mt-10">Kaydet</button>
                            </form>
                        </div>
                    </div>

                    <!-- KDV LİSTESİ -->
                    <div class="panel-card list-card mt-20">
                        <div class="card-header"><h3>KDV Listesi</h3></div>
                        <div class="card-body p-0">
                            <table class="data-table">
                                <thead>
                                    <tr>
                                        <th>Oran</th>
                                        <th>WS Kodu</th>
                                        <th>Durum</th>
                                        <th width="70">İşlem</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($kdvler as $k): ?>
                                    <tr>
                                        <td>%<strong><?php echo $k['kdv_orani']; ?></strong></td>
                                        <td>
                                            <?php echo $k['web_servis_kodu'] ? '<span class="badge-gray">'.$k['web_servis_kodu'].'</span>' : '-'; ?>
                                        </td>
                                        <td><?php echo $k['durum'] ? '<span class="dot active"></span>' : '<span class="dot passive"></span>'; ?></td>
                                        <td>
                                            <a href="?edit=<?php echo $k['id']; ?>&type=kdv" class="btn-icon btn-edit"><i class="fa-solid fa-pen"></i></a>
                                            <a href="?delete=<?php echo $k['id']; ?>&type=kdv" class="btn-icon btn-delete" onclick="return confirm('Silmek istediğine emin misin?')"><i class="fa-solid fa-trash"></i></a>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- SAĞ SÜTUN: BİRİM AYARLARI -->
                <div class="settings-column">
                    <!-- BİRİM FORM -->
                    <div class="panel-card form-card">
                        <div class="card-header">
                            <h3><i class="fa-solid fa-ruler-combined"></i> <?php echo $editBirim ? 'Birim Düzenle' : 'Birim Ekle'; ?></h3>
                            <?php if($editBirim): ?>
                                <a href="stok-birim-kdv-ayar.php" class="btn-xs btn-outline">İptal</a>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <input type="hidden" name="form_type" value="birim">
                                <?php if($editBirim): ?><input type="hidden" name="birim_id" value="<?php echo $editBirim['id']; ?>"><?php endif; ?>
                                
                                <div class="form-group">
                                    <label>Birim Adı (Örn: Adet, Koli)</label>
                                    <input type="text" name="birim_adi" required placeholder="Adet" value="<?php echo $editBirim['birim_adi'] ?? ''; ?>">
                                </div>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Web Servis Kodu</label>
                                        <input type="text" name="web_servis_kodu" placeholder="WS-BIRIM1" value="<?php echo $editBirim['web_servis_kodu'] ?? ''; ?>">
                                    </div>
                                    <div class="form-group col">
                                        <label>Artış (Step)</label>
                                        <input type="number" step="0.01" name="artis_miktari" required value="<?php echo $editBirim['artis_miktari'] ?? '1.00'; ?>">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label>Sıra No</label>
                                    <input type="number" name="sira" value="<?php echo $editBirim['sira'] ?? '0'; ?>">
                                </div>
                                
                                <label class="toggle-switch">
                                    <input type="checkbox" name="durum" <?php echo (!isset($editBirim) || $editBirim['durum'] == 1) ? 'checked' : ''; ?>>
                                    <span class="slider"></span>
                                    <span class="label-text">Aktif</span>
                                </label>
                                
                                <button type="submit" class="save-btn btn-full mt-10">Kaydet</button>
                            </form>
                        </div>
                    </div>

                    <!-- BİRİM LİSTESİ -->
                    <div class="panel-card list-card mt-20">
                        <div class="card-header"><h3>Birim Listesi</h3></div>
                        <div class="card-body p-0">
                            <table class="data-table">
                                <thead>
                                    <tr>
                                        <th>Birim</th>
                                        <th>WS Kodu</th>
                                        <th>Artış</th>
                                        <th>Durum</th>
                                        <th width="70">İşlem</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($birimler as $b): ?>
                                    <tr>
                                        <td><strong><?php echo $b['birim_adi']; ?></strong></td>
                                        <td>
                                            <?php echo $b['web_servis_kodu'] ? '<span class="badge-gray">'.$b['web_servis_kodu'].'</span>' : '-'; ?>
                                        </td>
                                        <td>x<?php echo $b['artis_miktari'] + 0; ?></td>
                                        <td><?php echo $b['durum'] ? '<span class="dot active"></span>' : '<span class="dot passive"></span>'; ?></td>
                                        <td>
                                            <a href="?edit=<?php echo $b['id']; ?>&type=birim" class="btn-icon btn-edit"><i class="fa-solid fa-pen"></i></a>
                                            <a href="?delete=<?php echo $b['id']; ?>&type=birim" class="btn-icon btn-delete" onclick="return confirm('Silmek istediğine emin misin?')"><i class="fa-solid fa-trash"></i></a>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        
        <footer class="panel-footer">
            &copy; <?php echo date("Y"); ?> Yönetim Paneli
        </footer>
    </main>
</div>
<script>
    // Mobil Menü
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    const toggleBtn = document.getElementById('toggleSidebar');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            sidebar.classList.add('active');
            overlay.classList.add('active');
        });
    }
    if(overlay) {
        overlay.addEventListener('click', () => {
            sidebar.classList.remove('active');
            overlay.classList.remove('active');
        });
    }
</script>
</body>
</html>