<?php
require_once '../private/config.php';

// Oturum Kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$message = "";
$messageType = "";

// --- SİLME İŞLEMİ ---
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $db->prepare("DELETE FROM urun_detay_ozellikleri WHERE id = ?");
    if ($stmt->execute([$id])) {
        header("Location: urun-detay-ayar.php?msg=deleted");
        exit;
    }
}

// --- KAYDETME / GÜNCELLEME ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
    $baslik = trim($_POST['baslik']);
    $aciklama = trim($_POST['aciklama']);
    $ikon = trim($_POST['ikon']);
    $renk = trim($_POST['renk']);
    $sira = intval($_POST['sira']);
    $durum = isset($_POST['durum']) ? 1 : 0;

    try {
        if ($id > 0) {
            $sql = "UPDATE urun_detay_ozellikleri SET baslik=?, aciklama=?, ikon=?, renk=?, sira=?, durum=? WHERE id=?";
            $stmt = $db->prepare($sql);
            $stmt->execute([$baslik, $aciklama, $ikon, $renk, $sira, $durum, $id]);
            $message = "Özellik güncellendi.";
        } else {
            $sql = "INSERT INTO urun_detay_ozellikleri (baslik, aciklama, ikon, renk, sira, durum) VALUES (?, ?, ?, ?, ?, ?)";
            $stmt = $db->prepare($sql);
            $stmt->execute([$baslik, $aciklama, $ikon, $renk, $sira, $durum]);
            $message = "Yeni özellik eklendi.";
        }
        $messageType = "success";
        
        // Temizle
        if(!$id) { 
            // header("Refresh: 1; url=urun-detay-ayar.php"); 
        }
    } catch (PDOException $e) {
        $message = "Hata: " . $e->getMessage();
        $messageType = "error";
    }
}

// --- VERİLERİ ÇEK ---
$features = $db->query("SELECT * FROM urun_detay_ozellikleri ORDER BY sira ASC")->fetchAll();

// Düzenleme Verisi
$editData = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $stmt = $db->prepare("SELECT * FROM urun_detay_ozellikleri WHERE id = ?");
    $stmt->execute([$id]);
    $editData = $stmt->fetch();
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ürün Detay Özellikleri | Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/urun-detay-ayar.css">
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <h2>Ürün Detay Özellikleri</h2>
            </div>
            <div class="user-info">
                <span>Hoş geldin, <strong><?php echo $_SESSION['admin_username'] ?? 'Yönetici'; ?></strong></span>
            </div>
        </header>
        
        <div class="content-body">
            
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?>">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <div class="page-grid">
                
                <!-- SOL: FORM -->
                <div class="form-section">
                    <div class="panel-card">
                        <div class="card-header">
                            <h3>
                                <i class="fa-solid fa-wand-magic-sparkles"></i> 
                                <?php echo $editData ? 'Özelliği Düzenle' : 'Yeni Özellik Ekle'; ?>
                            </h3>
                            <?php if($editData): ?>
                                <a href="urun-detay-ayar.php" class="btn-xs btn-outline">İptal</a>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <?php if($editData): ?>
                                    <input type="hidden" name="id" value="<?php echo $editData['id']; ?>">
                                <?php endif; ?>

                                <div class="form-group">
                                    <label>Başlık</label>
                                    <input type="text" name="baslik" required value="<?php echo $editData['baslik'] ?? ''; ?>" placeholder="Örn: Hızlı Teslimat">
                                </div>
                                
                                <div class="form-group">
                                    <label>Alt Açıklama</label>
                                    <input type="text" name="aciklama" value="<?php echo $editData['aciklama'] ?? ''; ?>" placeholder="Örn: Aynı gün kargo">
                                </div>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>İkon Kodu (FontAwesome)</label>
                                        <div class="input-with-icon">
                                            <span class="icon-preview"><i class="fa-solid <?php echo $editData['ikon'] ?? 'fa-icons'; ?>"></i></span>
                                            <input type="text" name="ikon" id="iconInput" value="<?php echo $editData['ikon'] ?? 'fa-check'; ?>" placeholder="fa-truck">
                                        </div>
                                        <small class="helper-text"><a href="https://fontawesome.com/icons" target="_blank">İkon Listesi</a></small>
                                    </div>
                                    <div class="form-group col">
                                        <label>İkon Rengi</label>
                                        <div class="color-picker-wrap">
                                            <input type="color" name="renk" value="<?php echo $editData['renk'] ?? '#f59e0b'; ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-row align-center">
                                    <div class="form-group col">
                                        <label>Sıra</label>
                                        <input type="number" name="sira" value="<?php echo $editData['sira'] ?? '0'; ?>">
                                    </div>
                                    <div class="form-group col">
                                        <label>Durum</label>
                                        <select name="durum" class="form-select">
                                            <option value="1" <?php echo (!isset($editData) || $editData['durum'] == 1) ? 'selected' : ''; ?>>Aktif</option>
                                            <option value="0" <?php echo (isset($editData) && $editData['durum'] == 0) ? 'selected' : ''; ?>>Pasif</option>
                                        </select>
                                    </div>
                                </div>

                                <button type="submit" class="save-btn btn-full">
                                    <i class="fa-solid fa-floppy-disk"></i> Kaydet
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- SAĞ: LİSTE -->
                <div class="list-section">
                    <div class="panel-card">
                        <div class="card-header">
                            <h3><i class="fa-solid fa-list"></i> Mevcut Özellikler</h3>
                        </div>
                        <div class="card-body p-0 table-responsive">
                            <table class="data-table">
                                <thead>
                                    <tr>
                                        <th width="50">İkon</th>
                                        <th>Başlık & Açıklama</th>
                                        <th>Durum</th>
                                        <th width="90">İşlem</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($features as $feat): ?>
                                        <tr>
                                            <td class="text-center">
                                                <div class="icon-circle" style="color: <?php echo $feat['renk']; ?>; border-color: <?php echo $feat['renk']; ?>;">
                                                    <i class="fa-solid <?php echo $feat['ikon']; ?>"></i>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="feat-title"><?php echo $feat['baslik']; ?></div>
                                                <div class="feat-desc"><?php echo $feat['aciklama']; ?></div>
                                            </td>
                                            <td>
                                                <?php if($feat['durum'] == 1): ?>
                                                    <span class="dot status-active"></span>
                                                <?php else: ?>
                                                    <span class="dot status-passive"></span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="action-buttons">
                                                    <a href="?edit=<?php echo $feat['id']; ?>" class="btn-icon btn-edit"><i class="fa-solid fa-pen"></i></a>
                                                    <a href="?delete=<?php echo $feat['id']; ?>" class="btn-icon btn-delete" onclick="return confirm('Silmek istediğine emin misin?')"><i class="fa-solid fa-trash"></i></a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                    <?php if(count($features) == 0): ?>
                                        <tr><td colspan="4" class="text-center p-20">Henüz özellik eklenmemiş.</td></tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        
        <footer class="panel-footer">
            &copy; <?php echo date("Y"); ?> Yönetim Paneli
        </footer>
    </main>
</div>

<script>
    // İkon Önizleme
    document.getElementById('iconInput').addEventListener('input', function() {
        const iconClass = this.value;
        const preview = this.previousElementSibling.querySelector('i');
        preview.className = 'fa-solid ' + iconClass;
    });

    // Mobil Menü
    const toggleBtn = document.getElementById('toggleSidebar');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            document.getElementById('sidebar').classList.add('active');
            document.getElementById('sidebarOverlay').classList.add('active');
        });
    }
    const overlay = document.getElementById('sidebarOverlay');
    if(overlay) {
        overlay.addEventListener('click', () => {
            document.getElementById('sidebar').classList.remove('active');
            overlay.classList.remove('active');
        });
    }
</script>
</body>
</html>