<?php
require_once '../private/config.php';

// Oturum Kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Site Ayarlarını Çek
$siteAyari = $db->query("SELECT * FROM site_ayarlari WHERE id=1")->fetch();
$fiyatGirisTipi = $siteAyari ? $siteAyari['fiyat_giris_tipi'] : 0; 

$message = "";
$messageType = "";

// Dosya Yükleme Klasörü Kontrolü
$uploadDir = '../uploads/urunler/';
if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

// --- GALERİ VE VARYANT RESMİ SİLME ---
if (isset($_GET['delete_img']) && isset($_GET['type']) && isset($_GET['uid'])) {
    $img_id = intval($_GET['delete_img']);
    $type = $_GET['type'];
    $urun_id_back = intval($_GET['uid']);
    
    if($type == 'galeri') {
        $imgQ = $db->prepare("SELECT resim_yolu FROM urun_galeri WHERE id = ?");
        $imgQ->execute([$img_id]);
        $imgDel = $imgQ->fetch();
        if ($imgDel) {
            if (file_exists($uploadDir . $imgDel['resim_yolu'])) { @unlink($uploadDir . $imgDel['resim_yolu']); }
            $db->prepare("DELETE FROM urun_galeri WHERE id = ?")->execute([$img_id]);
        }
        header("Location: urun-ekle-ayarlama.php?edit=" . $urun_id_back . "&tab=media");
    } elseif($type == 'varyant') {
        $vQ = $db->prepare("SELECT resim_yolu FROM urun_varyantlar WHERE id = ?");
        $vQ->execute([$img_id]);
        $vDel = $vQ->fetch();
        if ($vDel && $vDel['resim_yolu']) {
             if (file_exists($uploadDir . $vDel['resim_yolu'])) { @unlink($uploadDir . $vDel['resim_yolu']); }
             $db->prepare("UPDATE urun_varyantlar SET resim_yolu = NULL WHERE id = ?")->execute([$img_id]);
        }
        header("Location: urun-ekle-ayarlama.php?edit=" . $urun_id_back . "&tab=varyant");
    }
    exit;
}

// --- VARYANT SİLME ---
if (isset($_GET['delete_varyant']) && isset($_GET['uid'])) {
    $vid = intval($_GET['delete_varyant']);
    $uid = intval($_GET['uid']);
    $db->prepare("DELETE FROM urun_varyantlar WHERE id = ?")->execute([$vid]);
    header("Location: urun-ekle-ayarlama.php?edit=" . $uid . "&tab=varyant");
    exit;
}

// --- KAYDETME / GÜNCELLEME ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $is_edit = isset($_POST['urun_id']) && !empty($_POST['urun_id']);
    $urun_id = $is_edit ? intval($_POST['urun_id']) : 0;

    // Temel Bilgiler
    $urun_adi = trim($_POST['urun_adi']);
    $urun_kodu = trim($_POST['urun_kodu']);
    $barkod = trim($_POST['barkod']);
    
    // Çoklu Kategori
    $kategoriler = isset($_POST['kategoriler']) ? $_POST['kategoriler'] : [];

    // KATEGORİ ZORUNLULUĞU KONTROLÜ
    if (empty($kategoriler)) {
        $message = "Lütfen en az bir kategori seçiniz.";
        $messageType = "error";
    } else {
        // Kategori varsa işleme devam et
        $ana_kategori_id = !empty($kategoriler) ? intval($kategoriler[0]) : 0;

        $marka_id = isset($_POST['marka_id']) ? intval($_POST['marka_id']) : 0;
        $web_servis_kodu = trim($_POST['web_servis_kodu']);
        $gorunurluk = intval($_POST['gorunurluk']);
        $durum = isset($_POST['durum']) ? 1 : 0;
        $sira = intval($_POST['sira']);

        // Varyant Durumu
        $varyant_durumu = isset($_POST['varyant_durumu']) ? 1 : 0;

        // Fiyat ve Stok
        $fiyat = floatval($_POST['fiyat']);
        $indirimli_fiyat = !empty($_POST['indirimli_fiyat']) ? floatval($_POST['indirimli_fiyat']) : null;
        $para_birimi_id = intval($_POST['para_birimi_id']); // YENİ: Para Birimi
        
        $kdv_orani = intval($_POST['kdv_orani']);
        $stok_birimi_id = intval($_POST['stok_birimi_id']);
        $stok_miktari = floatval($_POST['stok_miktari']);

        // Açıklama & SEO
        $kisa_aciklama = trim($_POST['kisa_aciklama']);
        $aciklama = trim($_POST['aciklama']);
        $video_link = trim($_POST['video_link']);
        $seo_title = trim($_POST['seo_title']);
        $seo_desc = trim($_POST['seo_desc']);
        $seo_keywords = trim($_POST['seo_keywords']);

        // --- ANA RESİM ---
        $ana_resim = isset($_POST['mevcut_ana_resim']) ? $_POST['mevcut_ana_resim'] : null;
        if (isset($_FILES['ana_resim']) && $_FILES['ana_resim']['error'] == 0) {
            $ext = pathinfo($_FILES['ana_resim']['name'], PATHINFO_EXTENSION);
            $fileName = 'prod_' . time() . '_' . rand(100,999) . '.' . $ext;
            if (move_uploaded_file($_FILES['ana_resim']['tmp_name'], $uploadDir . $fileName)) {
                $ana_resim = $fileName;
            }
        }

        try {
            if ($is_edit) {
                $sql = "UPDATE urunler SET 
                        kategori_id=?, marka_id=?, urun_adi=?, urun_kodu=?, barkod=?, web_servis_kodu=?, varyant_durumu=?, 
                        fiyat=?, indirimli_fiyat=?, para_birimi_id=?, kdv_orani=?, stok_birimi_id=?, stok_miktari=?, 
                        kisa_aciklama=?, aciklama=?, video_link=?, ana_resim=?, 
                        seo_title=?, seo_desc=?, seo_keywords=?, gorunurluk=?, durum=?, sira=? 
                        WHERE id=?";
                $stmt = $db->prepare($sql);
                $stmt->execute([
                    $ana_kategori_id, $marka_id, $urun_adi, $urun_kodu, $barkod, $web_servis_kodu, $varyant_durumu,
                    $fiyat, $indirimli_fiyat, $para_birimi_id, $kdv_orani, $stok_birimi_id, $stok_miktari,
                    $kisa_aciklama, $aciklama, $video_link, $ana_resim,
                    $seo_title, $seo_desc, $seo_keywords, $gorunurluk, $durum, $sira, $urun_id
                ]);
                $message = "Ürün güncellendi.";
            } else {
                $sql = "INSERT INTO urunler (
                        kategori_id, marka_id, urun_adi, urun_kodu, barkod, web_servis_kodu, varyant_durumu,
                        fiyat, indirimli_fiyat, para_birimi_id, kdv_orani, stok_birimi_id, stok_miktari, 
                        kisa_aciklama, aciklama, video_link, ana_resim, 
                        seo_title, seo_desc, seo_keywords, gorunurluk, durum, sira
                        ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                $stmt = $db->prepare($sql);
                $stmt->execute([
                    $ana_kategori_id, $marka_id, $urun_adi, $urun_kodu, $barkod, $web_servis_kodu, $varyant_durumu,
                    $fiyat, $indirimli_fiyat, $para_birimi_id, $kdv_orani, $stok_birimi_id, $stok_miktari,
                    $kisa_aciklama, $aciklama, $video_link, $ana_resim,
                    $seo_title, $seo_desc, $seo_keywords, $gorunurluk, $durum, $sira
                ]);
                $urun_id = $db->lastInsertId();
                $message = "Ürün oluşturuldu.";
            }

            // --- KATEGORİ İLİŞKİLERİNİ GÜNCELLE ---
            $db->prepare("DELETE FROM urun_kategori_iliski WHERE urun_id = ?")->execute([$urun_id]);
            $catStmt = $db->prepare("INSERT INTO urun_kategori_iliski (urun_id, kategori_id) VALUES (?, ?)");
            foreach($kategoriler as $kid) {
                $catStmt->execute([$urun_id, $kid]);
            }

            // --- GALERİ RESİMLERİ ---
            if (isset($_FILES['galeri'])) {
                $total_files = count($_FILES['galeri']['name']);
                for ($i = 0; $i < $total_files; $i++) {
                    if ($_FILES['galeri']['error'][$i] == 0) {
                        $gExt = pathinfo($_FILES['galeri']['name'][$i], PATHINFO_EXTENSION);
                        $gName = 'gallery_' . $urun_id . '_' . time() . '_' . $i . '.' . $gExt;
                        if (move_uploaded_file($_FILES['galeri']['tmp_name'][$i], $uploadDir . $gName)) {
                            $db->prepare("INSERT INTO urun_galeri (urun_id, resim_yolu) VALUES (?, ?)")
                               ->execute([$urun_id, $gName]);
                        }
                    }
                }
            }

            // --- VARYANT İŞLEMLERİ ---
            if($varyant_durumu == 1 && isset($_POST['v_ad'])) {
                $db->prepare("UPDATE urun_varyantlar SET varsayilan = 0 WHERE urun_id = ?")->execute([$urun_id]);
                
                foreach($_POST['v_ad'] as $key => $vAd) {
                    if(empty($vAd)) continue;

                    $vId = isset($_POST['v_id'][$key]) ? intval($_POST['v_id'][$key]) : 0;
                    $vWS = $_POST['v_ws'][$key] ?? '';
                    $vFiyat = floatval($_POST['v_fiyat'][$key]);
                    $vIndirim = !empty($_POST['v_indirim'][$key]) ? floatval($_POST['v_indirim'][$key]) : null;
                    
                    $vParaBirimi = intval($_POST['v_para_birimi'][$key]); // YENİ: Varyant Para Birimi
                    $vKdv = intval($_POST['v_kdv'][$key]);
                    
                    $vStok = floatval($_POST['v_stok'][$key]);
                    $vBirim = intval($_POST['v_birim'][$key]);
                    $vDurum = isset($_POST['v_durum'][$key]) ? 1 : 0;
                    $vVarsayilan = (isset($_POST['v_varsayilan']) && $_POST['v_varsayilan'] == $key) ? 1 : 0;

                    $vResimYolu = isset($_POST['v_mevcut_resim'][$key]) ? $_POST['v_mevcut_resim'][$key] : null;
                    if(isset($_FILES['v_resim']['name'][$key]) && $_FILES['v_resim']['error'][$key] == 0) {
                        $vExt = pathinfo($_FILES['v_resim']['name'][$key], PATHINFO_EXTENSION);
                        $vFileName = 'var_' . $urun_id . '_' . time() . '_' . $key . '.' . $vExt;
                        if (move_uploaded_file($_FILES['v_resim']['tmp_name'][$key], $uploadDir . $vFileName)) {
                            $vResimYolu = $vFileName;
                        }
                    }

                    if($vId > 0) {
                        $sqlV = "UPDATE urun_varyantlar SET varyant_adi=?, web_servis_kodu=?, fiyat=?, indirimli_fiyat=?, para_birimi_id=?, kdv_orani=?, stok_miktari=?, stok_birimi_id=?, resim_yolu=?, varsayilan=?, durum=? WHERE id=?";
                        $db->prepare($sqlV)->execute([$vAd, $vWS, $vFiyat, $vIndirim, $vParaBirimi, $vKdv, $vStok, $vBirim, $vResimYolu, $vVarsayilan, $vDurum, $vId]);
                    } else {
                        $sqlV = "INSERT INTO urun_varyantlar (urun_id, varyant_adi, web_servis_kodu, fiyat, indirimli_fiyat, para_birimi_id, kdv_orani, stok_miktari, stok_birimi_id, resim_yolu, varsayilan, durum) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
                        $db->prepare($sqlV)->execute([$urun_id, $vAd, $vWS, $vFiyat, $vIndirim, $vParaBirimi, $vKdv, $vStok, $vBirim, $vResimYolu, $vVarsayilan, $vDurum]);
                    }
                }
            }
            
            $messageType = "success";
            
            if (!$is_edit) {
                 header("Refresh: 1.5; url=urun-ekle-ayarlama.php?edit=" . $urun_id);
            }

        } catch (PDOException $e) {
            $message = "Hata: " . $e->getMessage();
            $messageType = "error";
        }
    } // Else end
}

// --- VERİLERİ ÇEKME ---
$editData = null;
$galleryData = [];
$selectedCats = [];
$variantsData = [];

if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $editData = $db->query("SELECT * FROM urunler WHERE id = $id")->fetch();
    $galleryData = $db->query("SELECT * FROM urun_galeri WHERE urun_id = $id ORDER BY id ASC")->fetchAll();
    $variantsData = $db->query("SELECT * FROM urun_varyantlar WHERE urun_id = $id ORDER BY sira ASC, id ASC")->fetchAll();
    $selectedCats = $db->query("SELECT kategori_id FROM urun_kategori_iliski WHERE urun_id = $id")->fetchAll(PDO::FETCH_COLUMN);
}

// Yardımcı Tablolar
$markalar = $db->query("SELECT * FROM markalar WHERE durum=1 ORDER BY marka_adi ASC")->fetchAll();
$birimler = $db->query("SELECT * FROM urun_birimler WHERE durum=1 ORDER BY sira ASC")->fetchAll();
$kdvler = $db->query("SELECT * FROM urun_kdvler WHERE durum=1 ORDER BY sira ASC")->fetchAll();
$paraBirimleri = $db->query("SELECT * FROM para_birimleri WHERE durum=1 ORDER BY sira ASC")->fetchAll(); // YENİ

function getCategories($db, $parent = 0, $indent = '') {
    $stmt = $db->prepare("SELECT * FROM urunler_kategoriler WHERE ust_id = :par ORDER BY sira ASC");
    $stmt->execute(['par' => $parent]);
    return $stmt->fetchAll();
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $editData ? 'Ürün Düzenle' : 'Yeni Ürün Ekle'; ?> | Panel</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">

    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/urun-ekle-ayarlama.css">
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <h2><?php echo $editData ? 'Ürün Düzenleme: <span style="font-weight:400">'.$editData['urun_adi'].'</span>' : 'Yeni Ürün Kartı'; ?></h2>
            </div>
            <div class="user-info">
                <a href="urun-listesi.php" class="btn-xs btn-outline"><i class="fa-solid fa-arrow-left"></i> Listeye Dön</a>
            </div>
        </header>
        
        <div class="content-body">
            
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?>">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <div class="tab-header">
                <button type="button" class="tab-link active" onclick="openTab(event, 'tabGenel')"><i class="fa-solid fa-box"></i> Genel Bilgiler</button>
                <button type="button" class="tab-link" onclick="openTab(event, 'tabFiyat')"><i class="fa-solid fa-tags"></i> Fiyat & Stok</button>
                <button type="button" class="tab-link" onclick="openTab(event, 'tabVaryant')"><i class="fa-solid fa-layer-group"></i> Varyantlar</button>
                <button type="button" class="tab-link" onclick="openTab(event, 'tabMedia')"><i class="fa-solid fa-images"></i> Medya & Galeri</button>
                <button type="button" class="tab-link" onclick="openTab(event, 'tabSeo')"><i class="fa-brands fa-google"></i> Açıklama & SEO</button>
            </div>

            <form method="POST" action="" enctype="multipart/form-data" id="productForm">
                <?php if($editData): ?><input type="hidden" name="urun_id" value="<?php echo $editData['id']; ?>"><?php endif; ?>

                <!-- TAB 1: GENEL BİLGİLER -->
                <div id="tabGenel" class="tab-content active">
                    <div class="panel-card">
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-group col-2">
                                    <label>Ürün Adı <span class="required">*</span></label>
                                    <input type="text" name="urun_adi" required value="<?php echo $editData['urun_adi'] ?? ''; ?>" placeholder="Örn: iPhone 14 Pro Max">
                                </div>
                                <div class="form-group col-1">
                                    <label>Stok Kodu (SKU)</label>
                                    <input type="text" name="urun_kodu" value="<?php echo $editData['urun_kodu'] ?? ''; ?>" placeholder="APP-14-PRO">
                                </div>
                                <div class="form-group col-1">
                                    <label>Barkod (EAN/GTIN)</label>
                                    <input type="text" name="barkod" value="<?php echo $editData['barkod'] ?? ''; ?>" placeholder="869...">
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col">
                                    <label>Kategori Seçimi (Çoklu) <span class="required">*</span></label>
                                    <div class="select-search-wrapper">
                                        <input type="text" id="catSearch" class="search-input-sm" placeholder="Kategori Ara..." autocomplete="off">
                                        <i class="fa-solid fa-magnifying-glass search-icon"></i>
                                    </div>
                                    <div class="checkbox-list scrollable-box" id="catList">
                                        <?php
                                            function buildCatCheckboxes($db, $parent=0, $indent='', $selectedCats=[]) {
                                                $cats = getCategories($db, $parent);
                                                foreach($cats as $cat) {
                                                    $checked = in_array($cat['id'], $selectedCats) ? 'checked' : '';
                                                    echo '<label class="checkbox-item" data-text="'.strtolower($cat['kategori_adi']).'">
                                                            <input type="checkbox" name="kategoriler[]" value="'.$cat['id'].'" '.$checked.'> 
                                                            <span class="cb-label">'.$indent.' '.$cat['kategori_adi'].'</span>
                                                          </label>';
                                                    buildCatCheckboxes($db, $cat['id'], $indent . '&nbsp;&nbsp;-- ', $selectedCats);
                                                }
                                            }
                                            buildCatCheckboxes($db, 0, '', $selectedCats);
                                        ?>
                                    </div>
                                </div>

                                <div class="form-group col">
                                    <label>Marka Seçimi</label>
                                    <div class="select-search-wrapper">
                                        <input type="text" id="brandSearch" class="search-input-sm" placeholder="Marka Ara..." autocomplete="off">
                                        <i class="fa-solid fa-magnifying-glass search-icon"></i>
                                    </div>
                                    <div class="checkbox-list scrollable-box radio-mode" id="brandList">
                                        <label class="checkbox-item" data-text="">
                                            <input type="radio" name="marka_id" value="0" checked> 
                                            <span class="cb-label">-- Marka Yok --</span>
                                        </label>
                                        <?php foreach($markalar as $marka): ?>
                                            <label class="checkbox-item" data-text="<?php echo strtolower($marka['marka_adi']); ?>">
                                                <input type="radio" name="marka_id" value="<?php echo $marka['id']; ?>" 
                                                    <?php echo (isset($editData) && $editData['marka_id'] == $marka['id']) ? 'checked' : ''; ?>> 
                                                <span class="cb-label"><?php echo $marka['marka_adi']; ?></span>
                                            </label>
                                        <?php endforeach; ?>
                                    </div>
                                </div>

                                <div class="form-group col">
                                    <label>Web Servis Kodu</label>
                                    <input type="text" name="web_servis_kodu" value="<?php echo $editData['web_servis_kodu'] ?? ''; ?>">
                                    <div style="margin-top:15px;">
                                        <label>Sıra No</label>
                                        <input type="number" name="sira" value="<?php echo $editData['sira'] ?? '0'; ?>">
                                    </div>
                                </div>
                            </div>

                            <hr class="divider">

                            <div class="form-row align-center">
                                <div class="form-group col">
                                    <label>Görünürlük</label>
                                    <div class="radio-group-mini">
                                        <label class="radio-item"><input type="radio" name="gorunurluk" value="0" <?php echo (!isset($editData) || $editData['gorunurluk'] == 0) ? 'checked' : ''; ?>> Herkese</label>
                                        <label class="radio-item"><input type="radio" name="gorunurluk" value="1" <?php echo (isset($editData) && $editData['gorunurluk'] == 1) ? 'checked' : ''; ?>> Üye</label>
                                        <label class="radio-item"><input type="radio" name="gorunurluk" value="2" <?php echo (isset($editData) && $editData['gorunurluk'] == 2) ? 'checked' : ''; ?>> Bayi (B2B)</label>
                                    </div>
                                </div>

                                <div class="form-group col">
                                    <label style="margin-bottom:8px;">Ürün Durumu</label>
                                    <div class="toggle-wrapper">
                                        <label class="toggle-switch">
                                            <input type="checkbox" name="durum" <?php echo (!isset($editData) || $editData['durum'] == 1) ? 'checked' : ''; ?>>
                                            <span class="slider"></span>
                                        </label>
                                        <span class="toggle-label-text">Yayında (Aktif)</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- TAB 2: FİYAT & STOK -->
                <div id="tabFiyat" class="tab-content">
                    <div class="panel-card">
                        <div class="card-body">
                            <div class="price-alert <?php echo $fiyatGirisTipi == 0 ? 'alert-blue' : 'alert-orange'; ?>">
                                <i class="fa-solid fa-circle-info"></i>
                                <strong>BİLGİ:</strong> Fiyatları <u>KDV <?php echo $fiyatGirisTipi == 0 ? 'HARİÇ' : 'DAHİL'; ?></u> giriniz.
                            </div>

                            <div id="mainPriceArea">
                                <div class="form-row mt-20">
                                    <div class="form-group col">
                                        <label>Satış Fiyatı <span class="required">*</span></label>
                                        <div class="input-with-icon" style="display:flex;">
                                            <input type="number" step="0.01" name="fiyat" class="main-price-input" required value="<?php echo $editData['fiyat'] ?? ''; ?>" style="flex:1;">
                                            <!-- YENİ: PARA BİRİMİ SEÇİMİ -->
                                            <select name="para_birimi_id" class="form-select" style="width:100px; border-left:0; border-radius:0 6px 6px 0;">
                                                <?php foreach($paraBirimleri as $pb): ?>
                                                    <option value="<?php echo $pb['id']; ?>" <?php echo (isset($editData) && $editData['para_birimi_id'] == $pb['id']) ? 'selected' : ''; ?>>
                                                        <?php echo $pb['kod']; ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group col">
                                        <label>İndirimli Fiyat</label>
                                        <div class="input-with-icon">
                                            <input type="number" step="0.01" name="indirimli_fiyat" class="main-price-input" value="<?php echo $editData['indirimli_fiyat'] ?? ''; ?>">
                                            <span class="currency-symbol"></span>
                                        </div>
                                    </div>
                                    <div class="form-group col">
                                        <label>KDV Oranı</label>
                                        <select name="kdv_orani" class="form-select">
                                            <?php foreach($kdvler as $kdv): ?>
                                                <option value="<?php echo $kdv['kdv_orani']; ?>" <?php echo (isset($editData) && $editData['kdv_orani'] == $kdv['kdv_orani']) ? 'selected' : ''; ?>>
                                                    %<?php echo $kdv['kdv_orani']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Stok Miktarı</label>
                                        <input type="number" step="0.01" name="stok_miktari" class="main-price-input" value="<?php echo $editData['stok_miktari'] ?? '0'; ?>">
                                    </div>
                                    <div class="form-group col">
                                        <label>Stok Birimi</label>
                                        <select name="stok_birimi_id" class="form-select">
                                            <?php foreach($birimler as $br): ?>
                                                <option value="<?php echo $br['id']; ?>" <?php echo (isset($editData) && $editData['stok_birimi_id'] == $br['id']) ? 'selected' : ''; ?>>
                                                    <?php echo $br['birim_adi']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div id="variantMsg" style="display:none;" class="alert-blue mt-20">
                                <i class="fa-solid fa-layer-group"></i> <strong>Varyant Modu Aktif:</strong> Ana fiyat ve stok bilgileri pasif edilmiştir. Lütfen "Varyantlar" sekmesinden giriş yapınız.
                            </div>
                        </div>
                    </div>
                </div>

                <!-- TAB: VARYANTLAR -->
                <div id="tabVaryant" class="tab-content">
                    <div class="panel-card">
                        <div class="card-body">
                            <div class="price-alert <?php echo $fiyatGirisTipi == 0 ? 'alert-blue' : 'alert-orange'; ?> mb-20">
                                <i class="fa-solid fa-circle-info"></i>
                                <strong>BİLGİ:</strong> Varyant fiyatlarını da <u>KDV <?php echo $fiyatGirisTipi == 0 ? 'HARİÇ' : 'DAHİL'; ?></u> giriniz.
                            </div>

                            <div class="form-group mb-20">
                                <label class="checkbox-item big-check">
                                    <input type="checkbox" id="variantToggle" name="varyant_durumu" value="1" <?php echo (isset($editData) && $editData['varyant_durumu'] == 1) ? 'checked' : ''; ?>>
                                    <span class="cb-label" style="font-weight:bold; font-size:1rem;">Bu ürün seçeneklidir (Varyantlı Ürün)</span>
                                </label>
                                <div class="input-helper">Renk, beden gibi seçenekler varsa işaretleyin.</div>
                            </div>

                            <div id="variantSection" style="display:none;">
                                <div class="table-responsive">
                                    <table class="variant-table">
                                        <thead>
                                            <tr>
                                                <th>Varyant Adı (Renk-Beden)</th>
                                                <th width="80">WS Kodu</th>
                                                <th width="80">Fiyat</th>
                                                <th width="80">İnd. Fiyat</th>
                                                <th width="70">P.Birim</th> <!-- YENİ -->
                                                <th width="60">KDV</th>
                                                <th width="70">Stok</th>
                                                <th width="70">Birim</th>
                                                <th width="80">Resim</th>
                                                <th width="40">Aktif</th>
                                                <th width="40">Vars.</th>
                                                <th width="40"></th>
                                            </tr>
                                        </thead>
                                        <tbody id="variantContainer">
                                            <?php if(!empty($variantsData)): ?>
                                                <?php foreach($variantsData as $key => $v): ?>
                                                <tr class="variant-row">
                                                    <input type="hidden" name="v_id[<?php echo $key; ?>]" value="<?php echo $v['id']; ?>">
                                                    <input type="hidden" name="v_mevcut_resim[<?php echo $key; ?>]" value="<?php echo $v['resim_yolu']; ?>">
                                                    <td><input type="text" name="v_ad[<?php echo $key; ?>]" value="<?php echo $v['varyant_adi']; ?>" required></td>
                                                    <td><input type="text" name="v_ws[<?php echo $key; ?>]" value="<?php echo $v['web_servis_kodu']; ?>"></td>
                                                    <td><input type="number" step="0.01" name="v_fiyat[<?php echo $key; ?>]" value="<?php echo $v['fiyat']; ?>" required></td>
                                                    <td><input type="number" step="0.01" name="v_indirim[<?php echo $key; ?>]" value="<?php echo $v['indirimli_fiyat']; ?>"></td>
                                                    
                                                    <!-- YENİ: VARYANT PARA BİRİMİ -->
                                                    <td>
                                                        <select name="v_para_birimi[<?php echo $key; ?>]" style="min-width:60px;">
                                                            <?php foreach($paraBirimleri as $pb): ?>
                                                                <option value="<?php echo $pb['id']; ?>" <?php echo (isset($v['para_birimi_id']) && $v['para_birimi_id'] == $pb['id']) ? 'selected' : ''; ?>>
                                                                    <?php echo $pb['kod']; ?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>

                                                    <td>
                                                        <select name="v_kdv[<?php echo $key; ?>]">
                                                            <?php foreach($kdvler as $kdv): ?>
                                                                <option value="<?php echo $kdv['kdv_orani']; ?>" <?php echo (isset($v['kdv_orani']) && $v['kdv_orani'] == $kdv['kdv_orani']) ? 'selected' : ''; ?>>%<?php echo $kdv['kdv_orani']; ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td><input type="number" step="0.01" name="v_stok[<?php echo $key; ?>]" value="<?php echo $v['stok_miktari']; ?>"></td>
                                                    <td>
                                                        <select name="v_birim[<?php echo $key; ?>]">
                                                            <?php foreach($birimler as $br): ?>
                                                                <option value="<?php echo $br['id']; ?>" <?php echo $v['stok_birimi_id'] == $br['id'] ? 'selected' : ''; ?>><?php echo $br['birim_adi']; ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <div class="v-img-wrapper">
                                                            <input type="file" name="v_resim[<?php echo $key; ?>]" accept="image/*" style="width:100px; font-size:10px;">
                                                            <?php if($v['resim_yolu']): ?>
                                                                <a href="?delete_img=<?php echo $v['id']; ?>&type=varyant&uid=<?php echo $editData['id']; ?>" class="v-img-del" title="Resmi Sil"><i class="fa-solid fa-xmark"></i></a>
                                                                <img src="../uploads/urunler/<?php echo $v['resim_yolu']; ?>" class="v-thumb">
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                    <td class="text-center"><input type="checkbox" name="v_durum[<?php echo $key; ?>]" value="1" <?php echo $v['durum'] == 1 ? 'checked' : ''; ?>></td>
                                                    <td class="text-center"><input type="radio" name="v_varsayilan" value="<?php echo $key; ?>" <?php echo $v['varsayilan'] == 1 ? 'checked' : ''; ?>></td>
                                                    <td>
                                                        <a href="?delete_varyant=<?php echo $v['id']; ?>&uid=<?php echo $editData['id']; ?>" class="btn-icon btn-delete" onclick="return confirm('Silmek istediğine emin misin?')"><i class="fa-solid fa-trash"></i></a>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                    <button type="button" class="btn-xs btn-outline mt-10" onclick="addVariantRow()"><i class="fa-solid fa-plus"></i> Yeni Varyant Ekle</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- TAB 3: MEDYA -->
                <div id="tabMedia" class="tab-content">
                    <div class="panel-card">
                        <div class="card-body">
                            <div class="form-group">
                                <label>Ana Ürün Resmi</label>
                                <input type="file" name="ana_resim" accept="image/*" class="file-input">
                                <?php if(isset($editData['ana_resim']) && $editData['ana_resim']): ?>
                                    <div class="main-img-preview">
                                        <img src="../uploads/urunler/<?php echo $editData['ana_resim']; ?>" alt="Ana Resim">
                                        <input type="hidden" name="mevcut_ana_resim" value="<?php echo $editData['ana_resim']; ?>">
                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="form-group">
                                <label>Video Linki (YouTube Embed)</label>
                                <input type="text" name="video_link" value="<?php echo $editData['video_link'] ?? ''; ?>">
                            </div>

                            <hr class="divider">

                            <div class="form-group">
                                <label>Galeri Resimleri</label>
                                <input type="file" name="galeri[]" multiple accept="image/*" class="file-input">
                            </div>

                            <?php if(!empty($galleryData)): ?>
                                <div class="gallery-grid">
                                    <?php foreach($galleryData as $gImg): ?>
                                        <div class="gallery-item">
                                            <img src="../uploads/urunler/<?php echo $gImg['resim_yolu']; ?>" alt="">
                                            <a href="?delete_img=<?php echo $gImg['id']; ?>&type=galeri&uid=<?php echo $editData['id']; ?>" class="delete-btn" onclick="return confirm('Silmek istediğine emin misin?')"><i class="fa-solid fa-trash"></i></a>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- TAB 4: SEO -->
                <div id="tabSeo" class="tab-content">
                    <div class="panel-card">
                        <div class="card-body">
                            <div class="form-group">
                                <label>Kısa Açıklama</label>
                                <textarea name="kisa_aciklama" rows="2" class="form-control"><?php echo $editData['kisa_aciklama'] ?? ''; ?></textarea>
                            </div>
                            <div class="form-group">
                                <label>Detaylı Açıklama</label>
                                <textarea id="summernote" name="aciklama"><?php echo $editData['aciklama'] ?? ''; ?></textarea>
                            </div>
                            <div class="seo-box mt-20">
                                <h4><i class="fa-brands fa-google"></i> SEO Ayarları</h4>
                                <div class="form-group">
                                    <label>Başlık (Title)</label>
                                    <input type="text" name="seo_title" value="<?php echo $editData['seo_title'] ?? ''; ?>">
                                </div>
                                <div class="form-group">
                                    <label>Açıklama (Description)</label>
                                    <textarea name="seo_desc" rows="2"><?php echo $editData['seo_desc'] ?? ''; ?></textarea>
                                </div>
                                <div class="form-group">
                                    <label>Anahtar Kelimeler</label>
                                    <input type="text" name="seo_keywords" value="<?php echo $editData['seo_keywords'] ?? ''; ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-footer sticky-footer">
                    <button type="submit" class="save-btn btn-lg">
                        <i class="fa-solid fa-floppy-disk"></i> <?php echo $editData ? 'Ürünü Güncelle' : 'Ürünü Kaydet'; ?>
                    </button>
                </div>
            </form>
        </div>
        
        <footer class="panel-footer">
            &copy; <?php echo date("Y"); ?> Yönetim Paneli
        </footer>
    </main>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/lang/summernote-tr-TR.min.js"></script>

<script>
    function openTab(evt, tabName) {
        var i, tabcontent, tablinks;
        tabcontent = document.getElementsByClassName("tab-content");
        for (i = 0; i < tabcontent.length; i++) {
            tabcontent[i].style.display = "none";
            tabcontent[i].classList.remove("active");
        }
        tablinks = document.getElementsByClassName("tab-link");
        for (i = 0; i < tablinks.length; i++) {
            tablinks[i].className = tablinks[i].className.replace(" active", "");
        }
        document.getElementById(tabName).style.display = "block";
        document.getElementById(tabName).classList.add("active");
        if(evt) evt.currentTarget.className += " active";
    }

    const variantToggle = document.getElementById('variantToggle');
    const variantSection = document.getElementById('variantSection');
    const mainPriceArea = document.getElementById('mainPriceArea');
    const variantMsg = document.getElementById('variantMsg');
    const mainInputs = document.querySelectorAll('.main-price-input');

    function toggleVariantMode() {
        if(variantToggle.checked) {
            variantSection.style.display = 'block';
            mainPriceArea.style.opacity = '0.5';
            mainPriceArea.style.pointerEvents = 'none';
            variantMsg.style.display = 'block';
            mainInputs.forEach(input => input.removeAttribute('required'));
        } else {
            variantSection.style.display = 'none';
            mainPriceArea.style.opacity = '1';
            mainPriceArea.style.pointerEvents = 'auto';
            variantMsg.style.display = 'none';
            mainInputs.forEach(input => input.setAttribute('required', 'true'));
        }
    }

    if(variantToggle) {
        variantToggle.addEventListener('change', toggleVariantMode);
        toggleVariantMode();
    }

    let variantIndex = <?php echo !empty($variantsData) ? count($variantsData) + 10 : 100; ?>;
    function addVariantRow() {
        variantIndex++;
        const container = document.getElementById('variantContainer');
        const row = document.createElement('tr');
        row.className = 'variant-row';
        row.innerHTML = `
            <td><input type="text" name="v_ad[${variantIndex}]" placeholder="Örn: Kırmızı - L" required></td>
            <td><input type="text" name="v_ws[${variantIndex}]"></td>
            <td><input type="number" step="0.01" name="v_fiyat[${variantIndex}]" required></td>
            <td><input type="number" step="0.01" name="v_indirim[${variantIndex}]"></td>
            <td>
                <select name="v_para_birimi[${variantIndex}]" style="min-width:60px;">
                    <?php foreach($paraBirimleri as $pb): ?>
                        <option value="<?php echo $pb['id']; ?>"><?php echo $pb['kod']; ?></option>
                    <?php endforeach; ?>
                </select>
            </td>
            <td>
                <select name="v_kdv[${variantIndex}]">
                    <?php foreach($kdvler as $kdv): ?>
                        <option value="<?php echo $kdv['kdv_orani']; ?>">%<?php echo $kdv['kdv_orani']; ?></option>
                    <?php endforeach; ?>
                </select>
            </td>
            <td><input type="number" step="0.01" name="v_stok[${variantIndex}]"></td>
            <td>
                <select name="v_birim[${variantIndex}]">
                    <?php foreach($birimler as $br): ?>
                        <option value="<?php echo $br['id']; ?>"><?php echo $br['birim_adi']; ?></option>
                    <?php endforeach; ?>
                </select>
            </td>
            <td><input type="file" name="v_resim[${variantIndex}]" accept="image/*" style="width:100px; font-size:10px;"></td>
            <td class="text-center"><input type="checkbox" name="v_durum[${variantIndex}]" value="1" checked></td>
            <td class="text-center"><input type="radio" name="v_varsayilan" value="${variantIndex}"></td>
            <td><button type="button" class="btn-icon btn-delete" onclick="this.closest('tr').remove()"><i class="fa-solid fa-trash"></i></button></td>
        `;
        container.appendChild(row);
    }

    document.addEventListener("DOMContentLoaded", function() {
        const urlParams = new URLSearchParams(window.location.search);
        const activeTab = urlParams.get('tab');
        if(activeTab === 'media') {
            document.querySelector("button[onclick*='tabMedia']").click();
        } else if(activeTab === 'varyant') {
            document.querySelector("button[onclick*='tabVaryant']").click();
        } else {
            document.getElementById("tabGenel").style.display = "block";
        }
    });

    $('#summernote').summernote({
        placeholder: 'Ürün açıklaması...',
        tabsize: 2,
        height: 300,
        lang: 'tr-TR',
        toolbar: [
          ['style', ['style', 'bold', 'italic', 'underline', 'clear']],
          ['font', ['strikethrough', 'superscript', 'subscript']],
          ['color', ['color']],
          ['para', ['ul', 'ol', 'paragraph']],
          ['table', ['table']],
          ['insert', ['link', 'picture', 'video']],
          ['view', ['fullscreen', 'codeview']]
        ]
    });

    function setupSearch(inputId, listId) {
        const input = document.getElementById(inputId);
        const list = document.getElementById(listId);
        
        if(input && list) {
            input.addEventListener('keyup', function() {
                const filter = this.value.toLowerCase();
                const items = list.getElementsByClassName('checkbox-item');

                for (let i = 0; i < items.length; i++) {
                    const txtValue = items[i].getAttribute('data-text') || "";
                    if (txtValue.includes(filter)) {
                        items[i].style.display = "";
                    } else {
                        items[i].style.display = "none";
                    }
                }
            });
        }
    }

    setupSearch('catSearch', 'catList');
    setupSearch('brandSearch', 'brandList');

    const toggleBtn = document.getElementById('toggleSidebar');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            document.getElementById('sidebar').classList.add('active');
            document.getElementById('sidebarOverlay').classList.add('active');
        });
    }
    const overlay = document.getElementById('sidebarOverlay');
    if(overlay) {
        overlay.addEventListener('click', () => {
            document.getElementById('sidebar').classList.remove('active');
            overlay.classList.remove('active');
        });
    }
</script>
</body>
</html>