<?php
require_once '../private/config.php';

// Oturum Kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$message = "";
$messageType = "";

// --- İŞLEM: SİLME ---
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $db->prepare("DELETE FROM hediye_cekleri WHERE id = ?")->execute([$id]);
    header("Location: urun-hediyeceki-kampanya-ayar.php?msg=deleted");
    exit;
}

// --- İŞLEM: KAYDETME / GÜNCELLEME ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
    $cek_kodu = strtoupper(trim($_POST['cek_kodu']));
    $indirim_turu = $_POST['indirim_turu'];
    $indirim_degeri = floatval($_POST['indirim_degeri']);
    $hedef_grup = intval($_POST['hedef_grup']);
    $min_sepet = floatval($_POST['min_sepet_tutari']);
    $limit = intval($_POST['kullanim_limiti']);
    $baslangic = !empty($_POST['baslangic']) ? $_POST['baslangic'] : null;
    $bitis = !empty($_POST['bitis']) ? $_POST['bitis'] : null;
    $durum = intval($_POST['durum']);

    try {
        if ($id > 0) {
            $sql = "UPDATE hediye_cekleri SET cek_kodu=?, indirim_turu=?, indirim_degeri=?, hedef_grup=?, min_sepet_tutari=?, kullanim_limiti=?, baslangic_tarihi=?, bitis_tarihi=?, durum=? WHERE id=?";
            $stmt = $db->prepare($sql);
            $stmt->execute([$cek_kodu, $indirim_turu, $indirim_degeri, $hedef_grup, $min_sepet, $limit, $baslangic, $bitis, $durum, $id]);
            $message = "Hediye çeki başarıyla güncellendi.";
        } else {
            $sql = "INSERT INTO hediye_cekleri (cek_kodu, indirim_turu, indirim_degeri, hedef_grup, min_sepet_tutari, kullanim_limiti, baslangic_tarihi, bitis_tarihi, durum) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $db->prepare($sql);
            $stmt->execute([$cek_kodu, $indirim_turu, $indirim_degeri, $hedef_grup, $min_sepet, $limit, $baslangic, $bitis, $durum]);
            $message = "Yeni hediye çeki başarıyla oluşturuldu.";
        }
        $messageType = "success";
    } catch (PDOException $e) {
        $message = "Hata: Çek kodu benzersiz olmalıdır.";
        $messageType = "error";
    }
}

// Verileri Çek
$vouchers = $db->query("SELECT * FROM hediye_cekleri ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

// Düzenleme Verisi
$editData = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $stmt = $db->prepare("SELECT * FROM hediye_cekleri WHERE id = ?");
    $stmt->execute([$id]);
    $editData = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hediye Çeki & Kupon Ayarları | Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/urun-hediyeceki-kampanya-ayar.css">
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <h2>Hediye Çeki Yönetimi</h2>
            </div>
            <div class="user-info">
                <span>Hoş geldin, <strong><?php echo $_SESSION['admin_username'] ?? 'Yönetici'; ?></strong></span>
            </div>
        </header>
        
        <div class="content-body">
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?>">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <div class="page-grid">
                
                <!-- KUPON FORMU -->
                <div class="form-section">
                    <div class="panel-card">
                        <div class="card-header">
                            <h3><i class="fa-solid fa-ticket"></i> <?php echo $editData ? 'Kuponu Düzenle' : 'Yeni Kupon Oluştur'; ?></h3>
                            <?php if($editData): ?><a href="urun-hediyeceki-kampanya-ayar.php" class="btn-xs btn-outline">İptal</a><?php endif; ?>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <?php if($editData): ?><input type="hidden" name="id" value="<?php echo $editData['id']; ?>"><?php endif; ?>
                                
                                <div class="form-group">
                                    <label>Kupon / Çek Kodu <span class="required">*</span></label>
                                    <input type="text" name="cek_kodu" required value="<?php echo $editData['cek_kodu'] ?? ''; ?>" placeholder="Örn: HOSGELDIN20" style="text-transform: uppercase; font-weight: 700; letter-spacing: 1px;">
                                    <small class="helper-text">Müşterinin kasada gireceği koddur.</small>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>İndirim Türü</label>
                                        <select name="indirim_turu" class="form-select">
                                            <option value="oran" <?php echo (isset($editData) && $editData['indirim_turu'] == 'oran') ? 'selected' : ''; ?>>Yüzde (%)</option>
                                            <option value="tutar" <?php echo (isset($editData) && $editData['indirim_turu'] == 'tutar') ? 'selected' : ''; ?>>Sabit Tutar (₺)</option>
                                        </select>
                                    </div>
                                    <div class="form-group col">
                                        <label>İndirim Değeri</label>
                                        <input type="number" step="0.01" name="indirim_degeri" required value="<?php echo $editData['indirim_degeri'] ?? ''; ?>">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label>Müşteri Grubu Şartı <span class="required">*</span></label>
                                    <select name="hedef_grup" class="form-select" required>
                                        <option value="0" <?php echo (isset($editData) && $editData['hedef_grup'] == 0) ? 'selected' : ''; ?>>Herkese Açık (Misafir Dahil)</option>
                                        <option value="1" <?php echo (isset($editData) && $editData['hedef_grup'] == 1) ? 'selected' : ''; ?>>Sadece Kayıtlı Üyeler</option>
                                        <option value="2" <?php echo (isset($editData) && $editData['hedef_grup'] == 2) ? 'selected' : ''; ?>>Sadece Bayiler (B2B)</option>
                                    </select>
                                    <small class="helper-text">* Bu kural kasa sayfasında kesin olarak kontrol edilir.</small>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Min. Sepet Tutarı (₺)</label>
                                        <input type="number" step="0.01" name="min_sepet_tutari" value="<?php echo $editData['min_sepet_tutari'] ?? '0.00'; ?>">
                                    </div>
                                    <div class="form-group col">
                                        <label>Kullanım Limiti (Adet)</label>
                                        <input type="number" name="kullanim_limiti" value="<?php echo $editData['kullanim_limiti'] ?? '0'; ?>">
                                        <small class="helper-text">0 = Sınırsız kullanım</small>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Başlangıç Tarihi</label>
                                        <input type="datetime-local" name="baslangic" value="<?php echo isset($editData['baslangic_tarihi']) ? date('Y-m-d\TH:i', strtotime($editData['baslangic_tarihi'])) : ''; ?>">
                                    </div>
                                    <div class="form-group col">
                                        <label>Bitiş Tarihi</label>
                                        <input type="datetime-local" name="bitis" value="<?php echo isset($editData['bitis_tarihi']) ? date('Y-m-d\TH:i', strtotime($editData['bitis_tarihi'])) : ''; ?>">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label>Kampanya Durumu</label>
                                    <select name="durum" class="form-select">
                                        <option value="1" <?php echo (!isset($editData) || $editData['durum'] == 1) ? 'selected' : ''; ?>>Aktif</option>
                                        <option value="0" <?php echo (isset($editData) && $editData['durum'] == 0) ? 'selected' : ''; ?>>Pasif</option>
                                    </select>
                                </div>

                                <button type="submit" class="save-btn btn-full">
                                    <i class="fa-solid fa-floppy-disk"></i> Çeki Kaydet
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- LİSTE SÜTUNU -->
                <div class="list-section">
                    <div class="panel-card">
                        <div class="card-header">
                            <h3><i class="fa-solid fa-list-check"></i> Tanımlı Çekler</h3>
                        </div>
                        <div class="card-body p-0 table-responsive">
                            <table class="data-table">
                                <thead>
                                    <tr>
                                        <th>Kupon Kodu</th>
                                        <th>Grup</th>
                                        <th>İndirim</th>
                                        <th>Kullanım</th>
                                        <th>Durum</th>
                                        <th width="80">İşlem</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($vouchers as $v): ?>
                                    <tr>
                                        <td><code class="voucher-code"><?php echo $v['cek_kodu']; ?></code></td>
                                        <td>
                                            <?php 
                                                if($v['hedef_grup'] == 0) echo '<span class="grup-badge g-herkes">Herkes</span>';
                                                elseif($v['hedef_grup'] == 1) echo '<span class="grup-badge g-uye">Üye</span>';
                                                elseif($v['hedef_grup'] == 2) echo '<span class="grup-badge g-bayi">Bayi</span>';
                                            ?>
                                        </td>
                                        <td>
                                            <strong><?php echo $v['indirim_turu'] == 'oran' ? '%'.$v['indirim_degeri'] : number_format($v['indirim_degeri'], 2).' ₺'; ?></strong>
                                        </td>
                                        <td>
                                            <div class="usage-info">
                                                <span><?php echo $v['kullanilan_adet']; ?></span> / 
                                                <span><?php echo $v['kullanim_limiti'] > 0 ? $v['kullanim_limiti'] : '∞'; ?></span>
                                            </div>
                                        </td>
                                        <td>
                                            <?php if($v['durum'] == 1): ?>
                                                <span class="status-pill active">Aktif</span>
                                            <?php else: ?>
                                                <span class="status-pill passive">Pasif</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="action-buttons">
                                                <a href="?edit=<?php echo $v['id']; ?>" class="btn-icon btn-edit"><i class="fa-solid fa-pen"></i></a>
                                                <a href="?delete=<?php echo $v['id']; ?>" class="btn-icon btn-delete" onclick="return confirm('Silmek istediğine emin misin?')"><i class="fa-solid fa-trash"></i></a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                    <?php if(empty($vouchers)): ?>
                                        <tr><td colspan="6" class="text-center p-20">Henüz hediye çeki tanımlanmamış.</td></tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
</div>

<script>
    const toggleBtn = document.getElementById('toggleSidebar');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            document.getElementById('sidebar').classList.add('active');
            document.getElementById('sidebarOverlay').classList.add('active');
        });
    }
</script>
</body>
</html>