<?php
require_once '../private/config.php';

// Oturum Kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$message = "";
$messageType = "";

// Ürünler tablosu kontrolü
$hasUrunlerTable = false;
try {
    $checkTable = $db->query("SHOW TABLES LIKE 'urunler'");
    if($checkTable->rowCount() > 0) {
        $hasUrunlerTable = true;
    }
} catch(Exception $e) { $hasUrunlerTable = false; }

// --- İŞLEM 1: SİLME ---
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    
    // Önce resmi sunucudan silelim
    $stmtImg = $db->prepare("SELECT resim_yolu FROM urunler_kategoriler WHERE id = :id");
    $stmtImg->execute(['id' => $id]);
    $img = $stmtImg->fetch();
    if($img && $img['resim_yolu'] && file_exists('../uploads/urunkategoriresim/' . $img['resim_yolu'])) {
        @unlink('../uploads/urunkategoriresim/' . $img['resim_yolu']);
    }

    $stmt = $db->prepare("DELETE FROM urunler_kategoriler WHERE id = :id");
    if ($stmt->execute(['id' => $id])) {
        header("Location: urun-kategoriler-ayar.php?msg=deleted");
        exit;
    }
}

// --- İŞLEM 2: EKLEME / GÜNCELLEME ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $is_edit = isset($_POST['kategori_id']) && !empty($_POST['kategori_id']);
    
    $ust_id = isset($_POST['ust_id']) ? intval($_POST['ust_id']) : 0;
    $kategori_adi = isset($_POST['kategori_adi']) ? trim($_POST['kategori_adi']) : '';
    $web_servis_kodu = isset($_POST['web_servis_kodu']) ? trim($_POST['web_servis_kodu']) : ''; 
    
    // Açıklama artık HTML içerebilir, trim yapıyoruz ama strip_tags yapmıyoruz (Editör için)
    $aciklama = isset($_POST['aciklama']) ? trim($_POST['aciklama']) : '';
    
    $sira = isset($_POST['sira']) ? intval($_POST['sira']) : 0;
    $durum = isset($_POST['durum']) ? 1 : 0;
    $gorunurluk = isset($_POST['gorunurluk']) ? intval($_POST['gorunurluk']) : 0;
    
    // SEO Bilgileri
    $seo_title = isset($_POST['seo_title']) ? trim($_POST['seo_title']) : '';
    $seo_desc = isset($_POST['seo_desc']) ? trim($_POST['seo_desc']) : '';
    $seo_keywords = isset($_POST['seo_keywords']) ? trim($_POST['seo_keywords']) : '';

    // Resim Yönetimi
    $resim_yolu = isset($_POST['mevcut_resim']) ? $_POST['mevcut_resim'] : null;

    // 1. Durum: Resmi Silme İsteği Var mı?
    if (isset($_POST['resim_sil']) && $_POST['resim_sil'] == '1') {
        if ($resim_yolu && file_exists('../uploads/urunkategoriresim/' . $resim_yolu)) {
            @unlink('../uploads/urunkategoriresim/' . $resim_yolu);
        }
        $resim_yolu = null; // Veritabanı için null yap
    }
    
    // 2. Durum: Yeni Resim Yükleniyor mu? (Varsa eskisini ezer)
    if (isset($_FILES['resim']) && $_FILES['resim']['error'] == 0) {
        $allowed = ['image/jpeg', 'image/png', 'image/webp'];
        if (in_array($_FILES['resim']['type'], $allowed)) {
            $uploadDir = '../uploads/urunkategoriresim/';
            if (!file_exists($uploadDir)) { mkdir($uploadDir, 0777, true); }
            
            $ext = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $fileName = 'kat_' . time() . '_' . rand(100,999) . '.' . $ext;
            $targetPath = $uploadDir . $fileName;
            
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $targetPath)) {
                // Eğer eski resim varsa ve silinmediyse, yenisi gelince eskisini diskten temizle
                if ($resim_yolu && $resim_yolu !== $fileName && file_exists($uploadDir . $resim_yolu)) {
                    @unlink($uploadDir . $resim_yolu);
                }
                $resim_yolu = $fileName;
            }
        }
    }

    try {
        if ($is_edit) {
            // GÜNCELLEME
            $sql = "UPDATE urunler_kategoriler SET 
                    ust_id=:ust_id, kategori_adi=:kadi, web_servis_kodu=:wskodu, aciklama=:aciklama, resim_yolu=:resim, 
                    seo_title=:stitle, seo_desc=:sdesc, seo_keywords=:skey, 
                    sira=:sira, durum=:durum, gorunurluk=:gorunurluk 
                    WHERE id=:id";
            $stmt = $db->prepare($sql);
            $stmt->execute([
                'ust_id' => $ust_id, 'kadi' => $kategori_adi, 'wskodu' => $web_servis_kodu, 
                'aciklama' => $aciklama, 'resim' => $resim_yolu,
                'stitle' => $seo_title, 'sdesc' => $seo_desc, 'skey' => $seo_keywords,
                'sira' => $sira, 'durum' => $durum, 'gorunurluk' => $gorunurluk, 'id' => $_POST['kategori_id']
            ]);
            $message = "Kategori başarıyla güncellendi.";
        } else {
            // EKLEME
            $sql = "INSERT INTO urunler_kategoriler 
                    (ust_id, kategori_adi, web_servis_kodu, aciklama, resim_yolu, seo_title, seo_desc, seo_keywords, sira, durum, gorunurluk) 
                    VALUES 
                    (:ust_id, :kadi, :wskodu, :aciklama, :resim, :stitle, :sdesc, :skey, :sira, :durum, :gorunurluk)";
            $stmt = $db->prepare($sql);
            $stmt->execute([
                'ust_id' => $ust_id, 'kadi' => $kategori_adi, 'wskodu' => $web_servis_kodu,
                'aciklama' => $aciklama, 'resim' => $resim_yolu,
                'stitle' => $seo_title, 'sdesc' => $seo_desc, 'skey' => $seo_keywords,
                'sira' => $sira, 'durum' => $durum, 'gorunurluk' => $gorunurluk
            ]);
            $message = "Yeni kategori başarıyla oluşturuldu.";
        }
        $messageType = "success";
        
        if(!$is_edit) { header("Refresh: 2; url=urun-kategoriler-ayar.php"); }

    } catch (PDOException $e) {
        $message = "Hata: " . $e->getMessage();
        $messageType = "error";
    }
}

// --- DÜZENLEME VERİSİ ---
$editData = null;
if (isset($_GET['edit'])) {
    $stmt = $db->prepare("SELECT * FROM urunler_kategoriler WHERE id = :id");
    $stmt->execute(['id' => $_GET['edit']]);
    $editData = $stmt->fetch();
}

// --- KATEGORİ LİSTELEME FONKSİYONU ---
function getCategories($db, $parent = 0, $hasUrunlerTable = false) {
    if ($hasUrunlerTable) {
        $sql = "SELECT k.*, (SELECT COUNT(*) FROM urunler WHERE kategori_id = k.id) as urun_adet 
                FROM urunler_kategoriler k 
                WHERE k.ust_id = :par 
                ORDER BY k.sira ASC, k.kategori_adi ASC";
    } else {
        $sql = "SELECT *, 0 as urun_adet FROM urunler_kategoriler WHERE ust_id = :par ORDER BY sira ASC, kategori_adi ASC";
    }
    
    $stmt = $db->prepare($sql);
    $stmt->execute(['par' => $parent]);
    return $stmt->fetchAll();
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ürün Kategorileri | Yönetim Paneli</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Summernote CSS (Editör İçin) -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">

    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/urun-kategoriler-ayar.css">
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <h2>Kategori Yönetimi</h2>
            </div>
            <div class="user-info">
                <span>Hoş geldin, <strong><?php echo $_SESSION['admin_username'] ?? 'Yönetici'; ?></strong></span>
            </div>
        </header>
        
        <div class="content-body">
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?>">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <div class="page-grid">
                
                <!-- SOL TARAF: FORM -->
                <div class="form-section">
                    <div class="panel-card">
                        <div class="card-header">
                            <h3>
                                <i class="fa-solid <?php echo $editData ? 'fa-pen-to-square' : 'fa-plus-circle'; ?>"></i>
                                <?php echo $editData ? 'Kategoriyi Düzenle' : 'Yeni Kategori Ekle'; ?>
                            </h3>
                            <?php if($editData): ?>
                                <a href="urun-kategoriler-ayar.php" class="btn-xs btn-outline">İptal</a>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="" enctype="multipart/form-data">
                                <?php if($editData): ?>
                                    <input type="hidden" name="kategori_id" value="<?php echo $editData['id']; ?>">
                                    <input type="hidden" name="mevcut_resim" value="<?php echo $editData['resim_yolu']; ?>">
                                <?php endif; ?>

                                <div class="form-group">
                                    <label>Kategori Adı <span class="required">*</span></label>
                                    <input type="text" name="kategori_adi" required value="<?php echo $editData['kategori_adi'] ?? ''; ?>" placeholder="Örn: Elektronik">
                                </div>
                                
                                <div class="form-group">
                                    <label>Web Servis Kodu (ERP Entegrasyonu)</label>
                                    <input type="text" name="web_servis_kodu" value="<?php echo $editData['web_servis_kodu'] ?? ''; ?>" placeholder="Örn: WS-101, LOGO-05">
                                </div>

                                <div class="form-group">
                                    <label>Üst Kategori Seçimi</label>
                                    <div class="select-search-wrapper">
                                        <input type="text" id="parentSearchInput" class="search-input-sm" placeholder="Listede ara..." autocomplete="off">
                                        <i class="fa-solid fa-magnifying-glass search-icon"></i>
                                    </div>
                                    <select name="ust_id" id="parentSelect" class="form-select" size="5">
                                        <option value="0" <?php echo (!$editData || $editData['ust_id'] == 0) ? 'selected' : ''; ?>>-- Ana Kategori (En Üst) --</option>
                                        <?php
                                            function buildCategoryOptions($db, $hasUrunler, $parent=0, $indent='', $selectId = null, $currentId = null) {
                                                $cats = getCategories($db, $parent, $hasUrunler);
                                                foreach($cats as $cat) {
                                                    if ($currentId && $cat['id'] == $currentId) continue;
                                                    $selected = ($selectId == $cat['id']) ? 'selected' : '';
                                                    echo '<option value="'.$cat['id'].'" '.$selected.'>'.$indent.' '.$cat['kategori_adi'].'</option>';
                                                    buildCategoryOptions($db, $hasUrunler, $cat['id'], $indent . '&nbsp;&nbsp;&nbsp;-- ', $selectId, $currentId);
                                                }
                                            }
                                            buildCategoryOptions($db, $hasUrunlerTable, 0, '', $editData['ust_id'] ?? null, $editData['id'] ?? null);
                                        ?>
                                    </select>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col">
                                        <label>Sıra No</label>
                                        <input type="number" name="sira" value="<?php echo $editData['sira'] ?? '0'; ?>">
                                    </div>
                                    <div class="form-group col file-input-group">
                                        <label>Kategori Görseli</label>
                                        <input type="file" name="resim" accept=".jpg,.png,.webp" class="custom-file-input">
                                        <?php if(isset($editData['resim_yolu']) && $editData['resim_yolu']): ?>
                                            <div class="img-preview-mini">
                                                <img src="../uploads/urunkategoriresim/<?php echo $editData['resim_yolu']; ?>" alt="">
                                                <div style="display:flex; flex-direction:column; justify-content:center;">
                                                    <span style="font-weight:600; color:#4b5563;">Mevcut Görsel</span>
                                                    <label class="delete-img-check">
                                                        <input type="checkbox" name="resim_sil" value="1"> 
                                                        <i class="fa-solid fa-trash-can"></i> Resmi Sil
                                                    </label>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label>Detaylı Açıklama (HTML & Medya)</label>
                                    <!-- Summernote ID eklendi -->
                                    <textarea name="aciklama" id="summernote"><?php echo $editData['aciklama'] ?? ''; ?></textarea>
                                </div>

                                <!-- GÖRÜNÜRLÜK SEÇENEKLERİ -->
                                <div class="form-group">
                                    <label>Görünürlük Ayarı</label>
                                    <div class="visibility-radios">
                                        <?php $g = isset($editData['gorunurluk']) ? $editData['gorunurluk'] : 0; ?>
                                        <label class="radio-box <?php echo $g == 0 ? 'active' : ''; ?>">
                                            <input type="radio" name="gorunurluk" value="0" <?php echo $g == 0 ? 'checked' : ''; ?>>
                                            <i class="fa-solid fa-earth-americas"></i> <span>Herkese</span>
                                        </label>
                                        <label class="radio-box <?php echo $g == 1 ? 'active' : ''; ?>">
                                            <input type="radio" name="gorunurluk" value="1" <?php echo $g == 1 ? 'checked' : ''; ?>>
                                            <i class="fa-solid fa-user-check"></i> <span>Üye</span>
                                        </label>
                                        <label class="radio-box <?php echo $g == 2 ? 'active' : ''; ?>">
                                            <input type="radio" name="gorunurluk" value="2" <?php echo $g == 2 ? 'checked' : ''; ?>>
                                            <i class="fa-solid fa-briefcase"></i> <span>Bayi</span>
                                        </label>
                                    </div>
                                </div>

                                <div class="settings-toggles">
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="durum" <?php echo (!isset($editData) || $editData['durum'] == 1) ? 'checked' : ''; ?>>
                                        <span class="slider"></span>
                                        <span class="label-text">Kategori Aktif (Yayında)</span>
                                    </label>
                                </div>

                                <hr class="divider">
                                
                                <div class="seo-section">
                                    <h4><i class="fa-brands fa-google"></i> SEO Ayarları</h4>
                                    <div class="form-group">
                                        <label>Title</label>
                                        <input type="text" name="seo_title" value="<?php echo $editData['seo_title'] ?? ''; ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea name="seo_desc" rows="2"><?php echo $editData['seo_desc'] ?? ''; ?></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label>Keywords</label>
                                        <input type="text" name="seo_keywords" value="<?php echo $editData['seo_keywords'] ?? ''; ?>">
                                    </div>
                                </div>

                                <button type="submit" class="save-btn btn-full">
                                    <i class="fa-solid fa-floppy-disk"></i> <?php echo $editData ? 'Güncelle' : 'Kaydet'; ?>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- SAĞ TARAF: LİSTE -->
                <div class="list-section">
                    <div class="panel-card">
                        <div class="card-header">
                            <h3><i class="fa-solid fa-list-ul"></i> Kategori Listesi</h3>
                            <div class="list-search-wrapper">
                                <input type="text" id="categoryListSearch" placeholder="Kategori ara..." class="search-input">
                                <i class="fa-solid fa-search"></i>
                            </div>
                        </div>
                        <div class="card-body p-0 table-responsive">
                            <table class="data-table" id="categoryTable">
                                <thead>
                                    <tr>
                                        <th width="50">Görsel</th>
                                        <th>Kategori Adı</th>
                                        <th width="60" class="text-center">Ürün</th>
                                        <th>Görünürlük</th>
                                        <th>Durum</th>
                                        <th width="90">İşlem</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    function renderCategoryRow($cat, $level=0) {
                                        $padding = $level * 20;
                                        $icon = $level > 0 ? '<span style="color:#ccc; margin-right:5px;">L</span> ' : '';
                                        
                                        $imgHtml = '<div class="no-img"><i class="fa-regular fa-image"></i></div>';
                                        if($cat['resim_yolu']) {
                                            $imgHtml = '<img src="../uploads/urunkategoriresim/'.$cat['resim_yolu'].'" class="table-img">';
                                        }

                                        $visBadge = '';
                                        switch($cat['gorunurluk']) {
                                            case 0: $visBadge = '<span class="badge badge-public"><i class="fa-solid fa-earth-americas"></i></span>'; break;
                                            case 1: $visBadge = '<span class="badge badge-member"><i class="fa-solid fa-user"></i></span>'; break;
                                            case 2: $visBadge = '<span class="badge badge-dealer"><i class="fa-solid fa-briefcase"></i></span>'; break;
                                        }
                                            
                                        $statusClass = $cat['durum'] == 1 ? 'status-active' : 'status-passive';
                                        $wsBadge = $cat['web_servis_kodu'] ? '<i class="fa-solid fa-link text-blue" title="WS: '.$cat['web_servis_kodu'].'"></i> ' : '';

                                        echo '<tr class="cat-row" data-name="'.strtolower($cat['kategori_adi']).'">';
                                        echo '<td>'.$imgHtml.'</td>';
                                        echo '<td style="padding-left:'.($padding+10).'px;">
                                                <div class="cat-name-wrapper">
                                                    '.$icon.' <span class="cat-name">'.$wsBadge.$cat['kategori_adi'].'</span>
                                                </div>
                                              </td>';
                                        echo '<td class="text-center"><span class="product-count-badge" title="Ürün Adedi">'.$cat['urun_adet'].'</span></td>';
                                        echo '<td>'.$visBadge.'</td>';
                                        echo '<td><span class="dot '.$statusClass.'"></span></td>';
                                        echo '<td>
                                                <div class="action-buttons">
                                                    <a href="?edit='.$cat['id'].'" class="btn-icon btn-edit"><i class="fa-solid fa-pen"></i></a>
                                                    <a href="?delete='.$cat['id'].'" class="btn-icon btn-delete" onclick="return confirm(\'Silmek istediğine emin misin?\')"><i class="fa-solid fa-trash"></i></a>
                                                </div>
                                              </td>';
                                        echo '</tr>';
                                    }

                                    function listCategoriesRecursively($db, $hasUrunler, $parent=0, $level=0) {
                                        $cats = getCategories($db, $parent, $hasUrunler);
                                        foreach($cats as $cat) {
                                            renderCategoryRow($cat, $level);
                                            listCategoriesRecursively($db, $hasUrunler, $cat['id'], $level+1);
                                        }
                                    }
                                    
                                    listCategoriesRecursively($db, $hasUrunlerTable, 0);
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        
        <footer class="panel-footer">
            &copy; <?php echo date("Y"); ?> Katalog Yönetim Paneli
        </footer>
    </main>
</div>

<!-- jQuery ve Summernote JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
<!-- Summernote Türkçe Dil Dosyası -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/lang/summernote-tr-TR.min.js"></script>

<script>
    // Editörü Başlat
    $('#summernote').summernote({
        placeholder: 'Kategori ile ilgili detaylı açıklama, görsel veya video ekleyebilirsiniz...',
        tabsize: 2,
        height: 250,
        lang: 'tr-TR', // Türkçe yapıyoruz
        toolbar: [
          ['style', ['style']],
          ['font', ['bold', 'underline', 'clear']],
          ['color', ['color']],
          ['para', ['ul', 'ol', 'paragraph']],
          ['table', ['table']],
          ['insert', ['link', 'picture', 'video']], // Video ve Resim ekleme butonu burada
          ['view', ['fullscreen', 'codeview', 'help']]
        ]
    });

    // Radyo butonu efektleri
    document.querySelectorAll('.radio-box input').forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.radio-box').forEach(el => el.classList.remove('active'));
            if(this.checked) {
                this.closest('.radio-box').classList.add('active');
            }
        });
    });

    // Arama Fonksiyonları
    const parentSearchInput = document.getElementById('parentSearchInput');
    const parentSelect = document.getElementById('parentSelect');

    if(parentSearchInput && parentSelect) {
        parentSearchInput.addEventListener('keyup', function() {
            const filter = this.value.toLowerCase();
            const options = parentSelect.options;
            for (let i = 0; i < options.length; i++) {
                const txtValue = options[i].text.toLowerCase();
                const cleanText = txtValue.replace(/\u00a0/g, '').replace(/-/g, '').trim();
                if (cleanText.includes(filter) || i === 0) {
                    options[i].style.display = "";
                } else {
                    options[i].style.display = "none";
                }
            }
        });
    }

    const listSearchInput = document.getElementById('categoryListSearch');
    const tableRows = document.querySelectorAll('#categoryTable tbody tr');

    if(listSearchInput) {
        listSearchInput.addEventListener('keyup', function() {
            const filter = this.value.toLowerCase();
            tableRows.forEach(row => {
                const name = row.getAttribute('data-name');
                if(name.includes(filter)) {
                    row.style.display = "";
                } else {
                    row.style.display = "none";
                }
            });
        });
    }

    // Mobil Menü
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    const toggleBtn = document.getElementById('toggleSidebar');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            sidebar.classList.add('active');
            overlay.classList.add('active');
        });
    }
    if(overlay) {
        overlay.addEventListener('click', () => {
            sidebar.classList.remove('active');
            overlay.classList.remove('active');
        });
    }
</script>

<style>
/* Ekstra CSS: Silme kutucuğu için */
.delete-img-check {
    margin-top: 5px;
    font-size: 0.85rem;
    color: #ef4444;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 5px;
    padding: 3px 6px;
    border: 1px solid #fee2e2;
    border-radius: 4px;
    background: #fef2f2;
    transition: all 0.2s;
}
.delete-img-check:hover {
    background: #fee2e2;
    border-color: #fecaca;
}
/* Summernote düzeltmeleri */
.note-editor.note-frame {
    border-color: #d1d5db;
    border-radius: 6px;
}
</style>

</body>
</html>