<?php
require_once '../private/config.php';

// Oturum Kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$message = "";
$messageType = "";

// --- TEKLİ İŞLEMLER ---

// 1. SİLME
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    deleteProduct($db, $id);
    header("Location: urun-listele-ayar.php?msg=deleted");
    exit;
}

// 2. KOPYALAMA (Tekli işlem için de kullanılabilir)
if (isset($_GET['copy'])) {
    $id = intval($_GET['copy']);
    copyProduct($db, $id);
    header("Location: urun-listele-ayar.php?msg=copied");
    exit;
}

// 3. PASİFE ALMA
if (isset($_GET['passive'])) {
    $id = intval($_GET['passive']);
    $db->prepare("UPDATE urunler SET durum = 0 WHERE id = ?")->execute([$id]);
    header("Location: urun-listele-ayar.php?msg=passive");
    exit;
}

// --- TOPLU İŞLEMLER ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['bulk_action'])) {
    if (!empty($_POST['selected_ids'])) {
        $count = 0;
        $action = $_POST['bulk_action'];

        foreach ($_POST['selected_ids'] as $pid) {
            $pid = intval($pid);
            
            if ($action == 'delete') {
                deleteProduct($db, $pid);
                $count++;
                $message = "$count adet ürün silindi.";
            } elseif ($action == 'passive') {
                $db->prepare("UPDATE urunler SET durum = 0 WHERE id = ?")->execute([$pid]);
                $count++;
                $message = "$count adet ürün pasife alındı.";
            } elseif ($action == 'copy') {
                copyProduct($db, $pid);
                $count++;
                $message = "$count adet ürün kopyalandı.";
            }
        }
        $messageType = "success";
    } else {
        $message = "Lütfen ürün seçiniz.";
        $messageType = "error";
    }
}

// Ürün Silme Fonksiyonu
function deleteProduct($db, $id) {
    // Ana Resim
    $stmt = $db->prepare("SELECT ana_resim FROM urunler WHERE id = ?");
    $stmt->execute([$id]);
    $row = $stmt->fetch();
    if ($row && $row['ana_resim'] && file_exists('../uploads/urunler/' . $row['ana_resim'])) {
        @unlink('../uploads/urunler/' . $row['ana_resim']);
    }

    // Galeri Resimleri
    $gStmt = $db->query("SELECT resim_yolu FROM urun_galeri WHERE urun_id = $id");
    while ($g = $gStmt->fetch()) { if(file_exists('../uploads/urunler/'.$g['resim_yolu'])) @unlink('../uploads/urunler/'.$g['resim_yolu']); }
    
    // Varyant Resimleri
    $vStmt = $db->query("SELECT resim_yolu FROM urun_varyantlar WHERE urun_id = $id");
    while ($v = $vStmt->fetch()) { if(file_exists('../uploads/urunler/'.$v['resim_yolu'])) @unlink('../uploads/urunler/'.$v['resim_yolu']); }

    $db->exec("DELETE FROM urun_galeri WHERE urun_id = $id");
    $db->exec("DELETE FROM urun_varyantlar WHERE urun_id = $id");
    $db->exec("DELETE FROM urun_kategori_iliski WHERE urun_id = $id");
    $db->exec("DELETE FROM urunler WHERE id = $id");
}

// Ürün Kopyalama Fonksiyonu
function copyProduct($db, $id) {
    $stmt = $db->prepare("SELECT * FROM urunler WHERE id = ?");
    $stmt->execute([$id]);
    $prod = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$prod) return;

    // Resim Kopyala
    $newImgName = null;
    if ($prod['ana_resim'] && file_exists('../uploads/urunler/' . $prod['ana_resim'])) {
        $ext = pathinfo($prod['ana_resim'], PATHINFO_EXTENSION);
        $newImgName = 'prod_copy_' . time() . '_' . rand(100,999) . '.' . $ext;
        @copy('../uploads/urunler/' . $prod['ana_resim'], '../uploads/urunler/' . $newImgName);
    }

    unset($prod['id']);
    $prod['urun_adi'] .= ' (Kopya)';
    $prod['ana_resim'] = $newImgName;
    $prod['eklenme_tarihi'] = date('Y-m-d H:i:s');
    $prod['urun_kodu'] .= '-CPY';
    $prod['durum'] = 0; 

    $cols = array_keys($prod);
    $vals = array_values($prod);
    $placeholders = implode(',', array_fill(0, count($cols), '?'));
    $sql = "INSERT INTO urunler (" . implode(',', $cols) . ") VALUES ($placeholders)";
    
    $stmtIns = $db->prepare($sql);
    $stmtIns->execute($vals);
    $newId = $db->lastInsertId();

    // Kategorileri Kopyala
    $cats = $db->query("SELECT kategori_id FROM urun_kategori_iliski WHERE urun_id = $id")->fetchAll();
    foreach($cats as $cat) {
        $db->prepare("INSERT INTO urun_kategori_iliski (urun_id, kategori_id) VALUES (?, ?)")->execute([$newId, $cat['kategori_id']]);
    }

    // Varyantları Kopyala
    $vars = $db->query("SELECT * FROM urun_varyantlar WHERE urun_id = $id")->fetchAll(PDO::FETCH_ASSOC);
    foreach($vars as $v) {
        unset($v['id']);
        $v['urun_id'] = $newId;
        if ($v['resim_yolu'] && file_exists('../uploads/urunler/' . $v['resim_yolu'])) {
            $vExt = pathinfo($v['resim_yolu'], PATHINFO_EXTENSION);
            $vNewName = 'var_copy_' . time() . '_' . rand(100,999) . '.' . $vExt;
            @copy('../uploads/urunler/' . $v['resim_yolu'], '../uploads/urunler/' . $vNewName);
            $v['resim_yolu'] = $vNewName;
        }
        $vCols = array_keys($v);
        $vVals = array_values($v);
        $vPlace = implode(',', array_fill(0, count($vCols), '?'));
        $db->prepare("INSERT INTO urun_varyantlar (" . implode(',', $vCols) . ") VALUES ($vPlace)")->execute($vVals);
    }
}

// --- FİLTRELEME VE SAYFALAMA ---
$search = isset($_GET['q']) ? trim($_GET['q']) : '';
$cat_filter = isset($_GET['cat']) ? intval($_GET['cat']) : 0;
$brand_filter = isset($_GET['brand']) ? intval($_GET['brand']) : 0;
$status_filter = isset($_GET['status']) ? $_GET['status'] : 'all';

$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

$sql = "SELECT u.*, k.kategori_adi, m.marka_adi 
        FROM urunler u 
        LEFT JOIN urunler_kategoriler k ON u.kategori_id = k.id 
        LEFT JOIN markalar m ON u.marka_id = m.id 
        WHERE 1=1";
$params = [];

if ($search) {
    $sql .= " AND (u.urun_adi LIKE ? OR u.urun_kodu LIKE ? OR u.barkod LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
    $params[] = "%$search%";
}
if ($cat_filter > 0) {
    $sql .= " AND (u.kategori_id = ? OR u.id IN (SELECT urun_id FROM urun_kategori_iliski WHERE kategori_id = ?))";
    $params[] = $cat_filter;
    $params[] = $cat_filter;
}
if ($brand_filter > 0) { $sql .= " AND u.marka_id = ?"; $params[] = $brand_filter; }
if ($status_filter !== 'all') { $sql .= " AND u.durum = ?"; $params[] = intval($status_filter); }

// Toplam Sayı
$countSql = str_replace("SELECT u.*, k.kategori_adi, m.marka_adi", "SELECT COUNT(*)", $sql);
$countStmt = $db->prepare($countSql);
$countStmt->execute($params);
$total_products = $countStmt->fetchColumn();
$total_pages = ceil($total_products / $limit);

// Verileri Al
$sql .= " ORDER BY u.id DESC LIMIT $limit OFFSET $offset";
$stmt = $db->prepare($sql);
$stmt->execute($params);
$products = $stmt->fetchAll();

// Filtre Listeleri
$categories = $db->query("SELECT * FROM urunler_kategoriler ORDER BY kategori_adi ASC")->fetchAll();
$brands = $db->query("SELECT * FROM markalar ORDER BY marka_adi ASC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ürün Listesi | Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/sidebar.css">
    <link rel="stylesheet" href="../assets/panel.css">
    <link rel="stylesheet" href="../assets/urun-listele-ayar.css">
</head>
<body>

<div class="admin-layout">
    <div class="overlay" id="sidebarOverlay"></div>
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center;">
                <button id="toggleSidebar" class="hamburger"><i class="fa-solid fa-bars"></i></button>
                <h2>Ürün Listesi</h2>
            </div>
            <div class="user-info">
                <a href="urun-ekle-ayarlama.php" class="btn-new-product"><i class="fa-solid fa-plus"></i> Yeni Ürün Ekle</a>
            </div>
        </header>
        
        <div class="content-body">
            
            <?php if($message): ?>
                <div class="alert-box <?php echo $messageType; ?>">
                    <i class="fa-solid <?php echo $messageType == 'success' ? 'fa-check-circle' : 'fa-circle-exclamation'; ?>"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <!-- FİLTRELEME -->
            <div class="filter-card">
                <form method="GET" action="" class="filter-form">
                    <div class="filter-group search-group">
                        <input type="text" name="q" value="<?php echo htmlspecialchars($search); ?>" placeholder="Ürün adı, stok kodu veya barkod ara...">
                        <button type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
                    </div>
                    <div class="filter-group">
                        <select name="cat" onchange="this.form.submit()">
                            <option value="0">Tüm Kategoriler</option>
                            <?php foreach($categories as $cat): ?>
                                <option value="<?php echo $cat['id']; ?>" <?php echo $cat_filter == $cat['id'] ? 'selected' : ''; ?>><?php echo $cat['kategori_adi']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="filter-group">
                        <select name="brand" onchange="this.form.submit()">
                            <option value="0">Tüm Markalar</option>
                            <?php foreach($brands as $brand): ?>
                                <option value="<?php echo $brand['id']; ?>" <?php echo $brand_filter == $brand['id'] ? 'selected' : ''; ?>><?php echo $brand['marka_adi']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="filter-group">
                        <select name="status" onchange="this.form.submit()">
                            <option value="all">Tüm Durumlar</option>
                            <option value="1" <?php echo $status_filter == '1' ? 'selected' : ''; ?>>Yayında</option>
                            <option value="0" <?php echo $status_filter == '0' ? 'selected' : ''; ?>>Pasif</option>
                        </select>
                    </div>
                    <?php if($search || $cat_filter || $brand_filter || $status_filter != 'all'): ?>
                        <a href="urun-listele-ayar.php" class="clear-filter" title="Filtreyi Temizle"><i class="fa-solid fa-xmark"></i></a>
                    <?php endif; ?>
                </form>
            </div>

            <!-- TABLO -->
            <form method="POST" action="" id="bulkForm">
                <div class="panel-card list-card">
                    <div class="card-header-actions">
                        <div class="bulk-actions">
                            <i class="fa-solid fa-level-up-alt fa-rotate-90"></i>
                            <select name="bulk_action">
                                <option value="">Toplu İşlem Seç</option>
                                <option value="passive">Seçilenleri Pasife Al</option>
                                <option value="copy">Seçilenleri Kopyala</option>
                                <option value="delete">Seçilenleri Sil</option>
                            </select>
                            <button type="submit" onclick="return confirm('Seçili işlemi uygulamak istediğine emin misin?')" class="btn-xs btn-outline">Uygula</button>
                        </div>
                        <div class="total-info">Toplam: <strong><?php echo $total_products; ?></strong> ürün</div>
                    </div>

                    <div class="table-responsive">
                        <table class="product-table">
                            <thead>
                                <tr>
                                    <th width="30"><input type="checkbox" id="selectAll"></th>
                                    <th width="40">#ID</th>
                                    <th width="60">Görsel</th>
                                    <th>Ürün Adı</th>
                                    <th>Stok Kodu / Barkod</th>
                                    <th>Kategori / Marka</th>
                                    <th width="120">Fiyat</th>
                                    <th width="80">Stok</th>
                                    <th width="100">Kayıt Tarihi</th>
                                    <th width="80">Durum</th>
                                    <th width="90">İşlem</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(count($products) > 0): ?>
                                    <?php foreach($products as $prod): ?>
                                        <?php
                                            // Fiyat ve Stok Mantığı (Varsayılan Varyant Öncelikli)
                                            $finalPrice = $prod['fiyat'];       // Liste Fiyatı
                                            $finalDiscount = $prod['indirimli_fiyat']; // Satış Fiyatı (Varsa)
                                            $finalStock = $prod['stok_miktari'];
                                            $isVariant = false;

                                            if ($prod['varyant_durumu'] == 1) {
                                                // Varsayılan varyantı çek
                                                $vSql = "SELECT fiyat, indirimli_fiyat, stok_miktari FROM urun_varyantlar WHERE urun_id = ? ORDER BY varsayilan DESC, id ASC LIMIT 1";
                                                $vStmt = $db->prepare($vSql);
                                                $vStmt->execute([$prod['id']]);
                                                $variant = $vStmt->fetch();
                                                
                                                if ($variant) {
                                                    $finalPrice = $variant['fiyat'];
                                                    $finalDiscount = $variant['indirimli_fiyat'];
                                                    $finalStock = $variant['stok_miktari'];
                                                    $isVariant = true;
                                                }
                                            }
                                        ?>
                                        <tr>
                                            <td><input type="checkbox" name="selected_ids[]" value="<?php echo $prod['id']; ?>" class="row-checkbox"></td>
                                            <td class="text-muted">#<?php echo $prod['id']; ?></td>
                                            <td>
                                                <div class="img-wrapper">
                                                    <?php if($prod['ana_resim']): ?>
                                                        <img src="../uploads/urunler/<?php echo $prod['ana_resim']; ?>" alt="">
                                                    <?php else: ?>
                                                        <div class="no-img"><i class="fa-regular fa-image"></i></div>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="prod-name">
                                                    <a href="urun-ekle-ayarlama.php?edit=<?php echo $prod['id']; ?>"><?php echo $prod['urun_adi']; ?></a>
                                                    <?php if($isVariant): ?>
                                                        <span class="v-tag" title="Varyantlı Ürün"><i class="fa-solid fa-layer-group"></i></span>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                            <td class="text-sm">
                                                <div><?php echo $prod['urun_kodu'] ? '<i class="fa-solid fa-barcode"></i> '.$prod['urun_kodu'] : '-'; ?></div>
                                                <div class="text-xs text-muted"><?php echo $prod['barkod'] ? $prod['barkod'] : ''; ?></div>
                                            </td>
                                            <td>
                                                <div class="cat-name"><?php echo $prod['kategori_adi'] ?? '-'; ?></div>
                                                <div class="brand-name"><?php echo $prod['marka_adi'] ?? ''; ?></div>
                                            </td>
                                            <td>
                                                <!-- Fiyat Gösterimi Düzeltildi: Eski Fiyat Üstte Çizili, Yeni Fiyat Altta Kalın -->
                                                <?php if($finalDiscount > 0 && $finalDiscount < $finalPrice): ?>
                                                    <div class="price-old"><?php echo number_format($finalPrice, 2); ?> ₺</div>
                                                    <div class="price-val"><?php echo number_format($finalDiscount, 2); ?> ₺</div>
                                                <?php else: ?>
                                                    <div class="price-val"><?php echo number_format($finalPrice, 2); ?> ₺</div>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php 
                                                    $stockClass = $finalStock <= 0 ? 'stock-zero' : ($finalStock < 5 ? 'stock-low' : 'stock-ok');
                                                ?>
                                                <span class="stock-badge <?php echo $stockClass; ?>"><?php echo $finalStock + 0; ?></span>
                                            </td>
                                            <td class="text-sm text-muted">
                                                <?php echo date('d.m.Y', strtotime($prod['eklenme_tarihi'])); ?>
                                                <div class="text-xs"><?php echo date('H:i', strtotime($prod['eklenme_tarihi'])); ?></div>
                                            </td>
                                            <td>
                                                <?php if($prod['durum'] == 1): ?>
                                                    <span class="status-active">Yayında</span>
                                                <?php else: ?>
                                                    <span class="status-passive">Pasif</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="action-buttons">
                                                    <a href="urun-ekle-ayarlama.php?edit=<?php echo $prod['id']; ?>" class="btn-icon btn-edit" title="Düzenle"><i class="fa-solid fa-pen"></i></a>
                                                    <a href="?delete=<?php echo $prod['id']; ?>" class="btn-icon btn-delete" onclick="return confirm('Bu ürünü silmek istediğine emin misin?')" title="Sil"><i class="fa-solid fa-trash"></i></a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr><td colspan="11" class="text-center no-data">Kayıt bulunamadı.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- SAYFALAMA -->
                    <?php if($total_pages > 1): ?>
                        <div class="pagination">
                            <?php if($page > 1): ?>
                                <a href="?page=<?php echo $page-1; ?>&q=<?php echo $search; ?>&cat=<?php echo $cat_filter; ?>&brand=<?php echo $brand_filter; ?>&status=<?php echo $status_filter; ?>" class="page-link prev"><i class="fa-solid fa-angle-left"></i></a>
                            <?php endif; ?>
                            <?php for($i = 1; $i <= $total_pages; $i++): ?>
                                <a href="?page=<?php echo $i; ?>&q=<?php echo $search; ?>&cat=<?php echo $cat_filter; ?>&brand=<?php echo $brand_filter; ?>&status=<?php echo $status_filter; ?>" class="page-link <?php echo $page == $i ? 'active' : ''; ?>"><?php echo $i; ?></a>
                            <?php endfor; ?>
                            <?php if($page < $total_pages): ?>
                                <a href="?page=<?php echo $page+1; ?>&q=<?php echo $search; ?>&cat=<?php echo $cat_filter; ?>&brand=<?php echo $brand_filter; ?>&status=<?php echo $status_filter; ?>" class="page-link next"><i class="fa-solid fa-angle-right"></i></a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </form>
        </div>
        <footer class="panel-footer">&copy; <?php echo date("Y"); ?> Yönetim Paneli</footer>
    </main>
</div>

<script>
    const selectAll = document.getElementById('selectAll');
    const checkboxes = document.querySelectorAll('.row-checkbox');
    if(selectAll) {
        selectAll.addEventListener('change', function() {
            checkboxes.forEach(cb => cb.checked = this.checked);
        });
    }
    const toggleBtn = document.getElementById('toggleSidebar');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            document.getElementById('sidebar').classList.add('active');
            document.getElementById('sidebarOverlay').classList.add('active');
        });
    }
    const overlay = document.getElementById('sidebarOverlay');
    if(overlay) {
        overlay.addEventListener('click', () => {
            document.getElementById('sidebar').classList.remove('active');
            overlay.classList.remove('active');
        });
    }
</script>
</body>
</html>