<?php
// Config dosyasını dahil et
require_once '../private/config.php';

if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header("Location: panel.php");
    exit;
}

if (isset($_SESSION['is_verified']) && $_SESSION['is_verified'] === true) {
    header("Location: login.php");
    exit;
}

if (!isset($_SESSION['captcha_code'])) {
    $_SESSION['captcha_code'] = strtoupper(substr(md5(rand()), 0, 5));
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_code = strtoupper(trim($_POST['code']));
    
    if ($user_code === $_SESSION['captcha_code']) {
        $_SESSION['is_verified'] = true;
        unset($_SESSION['captcha_code']);
        header("Location: login.php");
        exit;
    } else {
        $error = "Hatalı kod girdiniz, tekrar deneyin.";
        $_SESSION['captcha_code'] = strtoupper(substr(md5(rand()), 0, 5));
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Güvenlik Doğrulaması</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- CSS Dosya Yolu Düzeltildi: Ana dizindeki assets klasörü -->
    <link rel="stylesheet" href="../assets/verification.css">
</head>
<body>

<div class="verify-container">
    <div class="logo-area">
        <img src="../uploads/verification/logo.png" alt="Panel Logo" onerror="this.src='https://placehold.co/150x50/orange/white?text=LOGO'">
    </div>
    
    <div class="verify-box">
        <h3>Güvenlik Kontrolü</h3>
        <p>Devam etmek için aşağıdaki kodu giriniz.</p>
        
        <?php if($error): ?>
            <div class="alert-error"><?php echo $error; ?></div>
        <?php endif; ?>

        <div class="code-display">
            <span><?php echo $_SESSION['captcha_code']; ?></span>
        </div>

        <form method="POST" action="">
            <div class="input-group">
                <i class="fa-solid fa-shield-halved"></i>
                <input type="text" name="code" placeholder="Kodu Giriniz" required autocomplete="off">
            </div>
            <button type="submit" class="verify-btn">Doğrula <i class="fa-solid fa-arrow-right"></i></button>
        </form>
    </div>
    
    <div class="footer-text">
        &copy; <?php echo date("Y"); ?> Yönetim Paneli Güvenlik Sistemi
    </div>
</div>

</body>
</html>