<?php
require_once 'private/config.php';

// Zaten giriş yapmışsa yönlendir
if (isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'dealer') {
    header("Location: index.php"); // Veya bayi paneline
    exit;
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    if (empty($email) || empty($password)) {
        $error = "Lütfen tüm alanları doldurunuz.";
    } else {
        try {
            $stmt = $db->prepare("SELECT * FROM bayiler WHERE email = :email");
            $stmt->execute(['email' => $email]);
            $bayi = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($bayi) {
                if (password_verify($password, $bayi['sifre'])) {
                    if ($bayi['durum'] == 1) {
                        // Giriş Başarılı
                        $_SESSION['user_id'] = $bayi['id'];
                        $_SESSION['user_name'] = $bayi['firma_adi'];
                        $_SESSION['user_role'] = 'dealer'; // Bayi rolü
                        
                        header("Location: index.php");
                        exit;
                    } elseif ($bayi['durum'] == 0) {
                        $error = "Hesabınız henüz onaylanmamış. Lütfen yönetici onayı bekleyiniz.";
                    } else {
                        $error = "Hesabınız pasif duruma alınmıştır.";
                    }
                } else {
                    $error = "Hatalı şifre girdiniz.";
                }
            } else {
                $error = "Bu e-posta adresiyle kayıtlı bayi bulunamadı.";
            }
        } catch (PDOException $e) {
            $error = "Sistemsel bir hata oluştu.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bayi Girişi | B2B Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/bayi-panel-giris.css">
</head>
<body>

<div class="login-wrapper">
    <div class="login-card">
        <div class="card-header">
            <div class="logo-area">
                <i class="fa-solid fa-briefcase"></i>
            </div>
            <h2>Bayi Girişi</h2>
            <p>B2B sistemine erişmek için giriş yapınız.</p>
        </div>

        <?php if($error): ?>
            <div class="alert-error">
                <i class="fa-solid fa-circle-exclamation"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="input-group">
                <label>E-Posta Adresi</label>
                <div class="input-field">
                    <i class="fa-solid fa-envelope"></i>
                    <input type="email" name="email" required placeholder="ornek@sirket.com">
                </div>
            </div>

            <div class="input-group">
                <label>Şifre</label>
                <div class="input-field">
                    <i class="fa-solid fa-lock"></i>
                    <input type="password" name="password" required placeholder="******">
                </div>
                <div class="forgot-pass">
                    <a href="#">Şifremi Unuttum?</a>
                </div>
            </div>

            <button type="submit" class="btn-login">Giriş Yap <i class="fa-solid fa-arrow-right"></i></button>
        </form>

        <div class="card-footer">
            Henüz bayimiz değil misiniz? <a href="bayi-panel-kayit.php">Bayi Başvurusu Yap</a>
        </div>
    </div>
</div>

</body>
</html>