<?php
require_once 'private/config.php';

$message = "";
$messageType = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Form Verileri
    $firma_adi = trim($_POST['firma_adi']);
    $yetkili = trim($_POST['yetkili']);
    $email = trim($_POST['email']);
    $telefon = trim($_POST['telefon']);
    $vergi_no = trim($_POST['vergi_no']);
    $vergi_dairesi = trim($_POST['vergi_dairesi']);
    $il = trim($_POST['il']);
    $ilce = trim($_POST['ilce']);
    $adres = trim($_POST['adres']);
    $pass1 = $_POST['pass1'];
    $pass2 = $_POST['pass2'];

    // Doğrulamalar
    if (empty($firma_adi) || empty($email) || empty($pass1)) {
        $message = "Lütfen zorunlu alanları doldurunuz.";
        $messageType = "error";
    } elseif ($pass1 !== $pass2) {
        $message = "Şifreler birbiriyle uyuşmuyor.";
        $messageType = "error";
    } else {
        // E-posta kontrolü
        $check = $db->prepare("SELECT id FROM bayiler WHERE email = ?");
        $check->execute([$email]);
        
        if ($check->rowCount() > 0) {
            $message = "Bu e-posta adresi zaten kayıtlı.";
            $messageType = "error";
        } else {
            // Kayıt İşlemi
            try {
                $hashPass = password_hash($pass1, PASSWORD_DEFAULT);
                $sql = "INSERT INTO bayiler (firma_adi, yetkili_ad_soyad, email, telefon, vergi_no, vergi_dairesi, il, ilce, adres, sifre, durum) 
                        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0)"; // Durum 0: Onay Bekliyor
                $stmt = $db->prepare($sql);
                $insert = $stmt->execute([$firma_adi, $yetkili, $email, $telefon, $vergi_no, $vergi_dairesi, $il, $ilce, $adres, $hashPass]);

                if ($insert) {
                    $message = "Başvurunuz başarıyla alındı! Yönetici onayından sonra giriş yapabilirsiniz.";
                    $messageType = "success";
                } else {
                    $message = "Kayıt sırasında bir hata oluştu.";
                    $messageType = "error";
                }
            } catch (PDOException $e) {
                $message = "Veritabanı hatası: " . $e->getMessage();
                $messageType = "error";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bayi Başvurusu | B2B Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/bayi-panel-kayit.css">
</head>
<body>

<div class="reg-container">
    <div class="reg-card">
        <div class="card-header">
            <h2>Bayi Başvurusu</h2>
            <p>Formu eksiksiz doldurarak bayilik başvurusunda bulunabilirsiniz.</p>
        </div>

        <?php if($message): ?>
            <div class="alert-box <?php echo $messageType; ?>">
                <?php if($messageType == 'success'): ?>
                    <i class="fa-solid fa-circle-check"></i>
                <?php else: ?>
                    <i class="fa-solid fa-circle-exclamation"></i>
                <?php endif; ?>
                <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <!-- Başarılı kayıt sonrası form gizlenebilir veya login linki çıkarılabilir -->
        <?php if($messageType !== 'success'): ?>
        <form method="POST" action="" class="reg-form">
            
            <!-- Firma Bilgileri -->
            <div class="form-section">
                <h3><i class="fa-solid fa-building"></i> Firma Bilgileri</h3>
                <div class="form-row">
                    <div class="form-group col-2">
                        <label>Firma Ünvanı *</label>
                        <input type="text" name="firma_adi" required placeholder="Şirketinizin tam adı">
                    </div>
                    <div class="form-group">
                        <label>Vergi Dairesi</label>
                        <input type="text" name="vergi_dairesi">
                    </div>
                    <div class="form-group">
                        <label>Vergi No</label>
                        <input type="text" name="vergi_no">
                    </div>
                </div>
            </div>

            <!-- İletişim Bilgileri -->
            <div class="form-section">
                <h3><i class="fa-solid fa-address-card"></i> İletişim Bilgileri</h3>
                <div class="form-row">
                    <div class="form-group">
                        <label>Yetkili Ad Soyad *</label>
                        <input type="text" name="yetkili" required>
                    </div>
                    <div class="form-group">
                        <label>Telefon</label>
                        <input type="text" name="telefon" placeholder="0555 555 55 55">
                    </div>
                    <div class="form-group">
                        <label>E-Posta *</label>
                        <input type="email" name="email" required placeholder="Giriş için kullanılacak">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>İl</label>
                        <input type="text" name="il">
                    </div>
                    <div class="form-group">
                        <label>İlçe</label>
                        <input type="text" name="ilce">
                    </div>
                </div>
                <div class="form-group">
                    <label>Adres</label>
                    <textarea name="adres" rows="2"></textarea>
                </div>
            </div>

            <!-- Güvenlik -->
            <div class="form-section">
                <h3><i class="fa-solid fa-lock"></i> Güvenlik</h3>
                <div class="form-row">
                    <div class="form-group">
                        <label>Şifre *</label>
                        <input type="password" name="pass1" required>
                    </div>
                    <div class="form-group">
                        <label>Şifre Tekrar *</label>
                        <input type="password" name="pass2" required>
                    </div>
                </div>
            </div>

            <div class="form-footer">
                <button type="submit" class="btn-register">Başvuruyu Tamamla</button>
            </div>
        </form>
        <?php else: ?>
            <div class="success-actions">
                <a href="bayi-panel-giris.php" class="btn-login-link">Giriş Sayfasına Dön</a>
            </div>
        <?php endif; ?>
        
        <div class="bottom-link">
            Zaten bayimiz misiniz? <a href="bayi-panel-giris.php">Giriş Yap</a>
        </div>
    </div>
</div>

</body>
</html>