<?php
require_once 'private/config.php';

// Güvenlik: Sadece Bayiler Girebilir
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'dealer') {
    header("Location: bayi-panel-giris.php");
    exit;
}

$bayi_id = $_SESSION['user_id'];
$active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'dashboard';
$message = "";
$messageType = "";

// --- İŞLEM 1: PROFİL GÜNCELLEME ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'update_profile') {
    $firma_adi = trim($_POST['firma_adi']);
    $yetkili = trim($_POST['yetkili']);
    $telefon = trim($_POST['telefon']);
    $adres = trim($_POST['adres']);
    $vergi_no = trim($_POST['vergi_no']);
    $vergi_dairesi = trim($_POST['vergi_dairesi']);
    
    // Şifre değişimi varsa
    $pass_sql = "";
    $params = [$firma_adi, $yetkili, $telefon, $adres, $vergi_no, $vergi_dairesi];
    
    if (!empty($_POST['new_password'])) {
        $pass_sql = ", sifre = ?";
        $params[] = password_hash($_POST['new_password'], PASSWORD_DEFAULT);
    }
    
    $params[] = $bayi_id; // WHERE şartı için

    $sql = "UPDATE bayiler SET firma_adi=?, yetkili_ad_soyad=?, telefon=?, adres=?, vergi_no=?, vergi_dairesi=? $pass_sql WHERE id=?";
    $stmt = $db->prepare($sql);
    
    if ($stmt->execute($params)) {
        $message = "Profil bilgileriniz başarıyla güncellendi.";
        $messageType = "success";
        $_SESSION['user_name'] = $firma_adi; // Session'ı da güncelle
    } else {
        $message = "Güncelleme sırasında hata oluştu.";
        $messageType = "error";
    }
}

// --- İŞLEM 2: SİPARİŞ İPTALİ (15 GÜN KURALI) ---
if (isset($_GET['cancel_order'])) {
    $order_id = intval($_GET['cancel_order']);
    
    // Siparişi ve tarihini çek
    $stmt = $db->prepare("SELECT siparis_tarihi, durum FROM siparisler WHERE id = ? AND bayi_id = ?");
    $stmt->execute([$order_id, $bayi_id]);
    $order = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($order) {
        $orderDate = new DateTime($order['siparis_tarihi']);
        $now = new DateTime();
        $interval = $now->diff($orderDate);
        $days = $interval->days;

        // Kural: 15 günü geçmemiş ve kargoya verilmemiş olmalı
        if ($days <= 15 && ($order['durum'] == 'Bekliyor' || $order['durum'] == 'Hazırlanıyor')) {
            $upd = $db->prepare("UPDATE siparisler SET durum = 'İptal' WHERE id = ?");
            $upd->execute([$order_id]);
            $message = "Siparişiniz iptal edildi.";
            $messageType = "success";
        } else {
            $message = "Bu sipariş iptal edilemez (Süre dolmuş veya kargoya verilmiş).";
            $messageType = "error";
        }
    }
    // URL temizle
    // header("Refresh: 2; url=bayi-panel.php?tab=orders");
}

// --- VERİLERİ ÇEK ---
// 1. Bayi Bilgileri
$bayi = $db->query("SELECT * FROM bayiler WHERE id = $bayi_id")->fetch(PDO::FETCH_ASSOC);

// 2. Siparişler
$orders = $db->query("SELECT * FROM siparisler WHERE bayi_id = $bayi_id ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

// 3. İstatistikler
$totalOrders = count($orders);
$activeOrders = 0;
$totalSpent = 0;
foreach($orders as $o) {
    if($o['durum'] != 'İptal') {
        $totalSpent += $o['toplam_tutar'];
        if($o['durum'] != 'Tamamlandı') $activeOrders++;
    }
}

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bayi Paneli | <?php echo $_SESSION['user_name']; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/bayi-panel.css">
</head>
<body>

<!-- Header -->
<header class="panel-header">
    <div class="container">
        <div class="brand">
            <i class="fa-solid fa-handshake"></i> Bayi Paneli
        </div>
        <div class="user-actions">
            <span>Hoşgeldin, <b><?php echo $bayi['yetkili_ad_soyad']; ?></b></span>
            <a href="index.php" class="btn-home"><i class="fa-solid fa-globe"></i> Siteye Dön</a>
            <a href="bayi-cikis.php" class="btn-logout"><i class="fa-solid fa-right-from-bracket"></i> Çıkış</a>
        </div>
    </div>
</header>

<div class="container main-layout">
    
    <!-- Sidebar Menü -->
    <aside class="sidebar">
        <div class="profile-summary">
            <div class="avatar-circle"><?php echo strtoupper(substr($bayi['firma_adi'], 0, 2)); ?></div>
            <h3><?php echo $bayi['firma_adi']; ?></h3>
            <p><?php echo $bayi['email']; ?></p>
        </div>
        <nav class="menu">
            <a href="?tab=dashboard" class="<?php echo $active_tab=='dashboard'?'active':''; ?>">
                <i class="fa-solid fa-gauge-high"></i> Özet Durum
            </a>
            <a href="?tab=orders" class="<?php echo $active_tab=='orders'?'active':''; ?>">
                <i class="fa-solid fa-box-open"></i> Siparişlerim
            </a>
            <a href="?tab=profile" class="<?php echo $active_tab=='profile'?'active':''; ?>">
                <i class="fa-solid fa-user-gear"></i> Firma Bilgileri
            </a>
            <a href="?tab=support" class="<?php echo $active_tab=='support'?'active':''; ?>">
                <i class="fa-solid fa-headset"></i> Destek Talebi
            </a>
        </nav>
    </aside>

    <!-- İçerik Alanı -->
    <main class="content">
        
        <?php if($message): ?>
            <div class="alert-box <?php echo $messageType; ?>">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <!-- TAB: DASHBOARD -->
        <?php if($active_tab == 'dashboard'): ?>
            <div class="content-header">
                <h2>Genel Bakış</h2>
            </div>
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="icon orange"><i class="fa-solid fa-basket-shopping"></i></div>
                    <div class="info">
                        <h3><?php echo $totalOrders; ?></h3>
                        <p>Toplam Sipariş</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="icon blue"><i class="fa-solid fa-clock"></i></div>
                    <div class="info">
                        <h3><?php echo $activeOrders; ?></h3>
                        <p>Aktif Siparişler</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="icon green"><i class="fa-solid fa-wallet"></i></div>
                    <div class="info">
                        <h3><?php echo number_format($totalSpent, 2, ',', '.'); ?> ₺</h3>
                        <p>Toplam Harcama</p>
                    </div>
                </div>
            </div>

            <div class="recent-orders mt-30">
                <h3>Son 5 Sipariş</h3>
                <?php if(empty($orders)): ?>
                    <p class="empty-msg">Henüz siparişiniz bulunmuyor.</p>
                <?php else: ?>
                    <table class="panel-table">
                        <thead>
                            <tr>
                                <th>Sipariş No</th>
                                <th>Tarih</th>
                                <th>Tutar</th>
                                <th>Durum</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $count = 0;
                            foreach($orders as $order): 
                                if($count >= 5) break; $count++;
                            ?>
                            <tr>
                                <td>#<?php echo $order['siparis_kodu']; ?></td>
                                <td><?php echo date('d.m.Y', strtotime($order['siparis_tarihi'])); ?></td>
                                <td><?php echo number_format($order['toplam_tutar'], 2, ',', '.'); ?> ₺</td>
                                <td><span class="status-badge <?php echo strtolower($order['durum']); ?>"><?php echo $order['durum']; ?></span></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <!-- TAB: SİPARİŞLER -->
        <?php if($active_tab == 'orders'): ?>
            <div class="content-header">
                <h2>Sipariş Geçmişi</h2>
            </div>
            <div class="panel-card">
                <div class="table-responsive">
                    <table class="panel-table">
                        <thead>
                            <tr>
                                <th>Sipariş Kodu</th>
                                <th>Tarih</th>
                                <th>Tutar</th>
                                <th>Durum</th>
                                <th>Kargo Bilgisi</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($orders as $order): 
                                // 15 Gün Kontrolü
                                $orderDate = new DateTime($order['siparis_tarihi']);
                                $now = new DateTime();
                                $interval = $now->diff($orderDate);
                                $days = $interval->days;
                                $isCancelable = ($days <= 15 && ($order['durum'] == 'Bekliyor' || $order['durum'] == 'Hazırlanıyor'));
                            ?>
                            <tr>
                                <td><strong>#<?php echo $order['siparis_kodu']; ?></strong></td>
                                <td>
                                    <?php echo date('d.m.Y', strtotime($order['siparis_tarihi'])); ?>
                                    <div class="sub-text"><?php echo date('H:i', strtotime($order['siparis_tarihi'])); ?></div>
                                </td>
                                <td><strong><?php echo number_format($order['toplam_tutar'], 2, ',', '.'); ?> ₺</strong></td>
                                <td><span class="status-badge <?php echo strtolower($order['durum']); ?>"><?php echo $order['durum']; ?></span></td>
                                <td>
                                    <?php if($order['kargo_firma']): ?>
                                        <div class="cargo-info">
                                            <i class="fa-solid fa-truck-fast"></i> <?php echo $order['kargo_firma']; ?><br>
                                            <small>Takip: <?php echo $order['kargo_takip_no']; ?></small>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($isCancelable): ?>
                                        <a href="?tab=orders&cancel_order=<?php echo $order['id']; ?>" class="btn-cancel" onclick="return confirm('Bu siparişi iptal etmek istediğinize emin misiniz? Bu işlem geri alınamaz.')">
                                            <i class="fa-solid fa-xmark"></i> İptal Et
                                        </a>
                                    <?php elseif($order['durum'] == 'İptal'): ?>
                                        <span class="text-danger">İptal Edildi</span>
                                    <?php else: ?>
                                        <button class="btn-detail" disabled title="Süre doldu veya kargoya verildi"><i class="fa-solid fa-eye"></i> Detay</button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php if(empty($orders)): ?>
                                <tr><td colspan="6" class="text-center p-20">Kayıtlı siparişiniz bulunmamaktadır.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="info-footer">
                    <i class="fa-solid fa-circle-info"></i> Siparişlerinizi oluşturulduktan sonraki <strong>15 gün</strong> içerisinde, kargoya verilmeden önce iptal edebilirsiniz.
                </div>
            </div>
        <?php endif; ?>

        <!-- TAB: PROFİL -->
        <?php if($active_tab == 'profile'): ?>
            <div class="content-header">
                <h2>Firma Bilgileri</h2>
            </div>
            <div class="panel-card">
                <form method="POST" action="">
                    <input type="hidden" name="action" value="update_profile">
                    
                    <div class="form-section-title">Hesap Bilgileri (Değiştirilemez)</div>
                    <div class="form-row">
                        <div class="form-group col">
                            <label>E-Posta Adresi</label>
                            <input type="email" value="<?php echo $bayi['email']; ?>" disabled class="input-disabled">
                            <small>Güvenlik nedeniyle e-posta adresi değiştirilemez. Destek ile iletişime geçin.</small>
                        </div>
                    </div>

                    <div class="form-section-title mt-30">Firma Detayları</div>
                    <div class="form-row">
                        <div class="form-group col">
                            <label>Firma Ünvanı</label>
                            <input type="text" name="firma_adi" value="<?php echo $bayi['firma_adi']; ?>" required>
                        </div>
                        <div class="form-group col">
                            <label>Yetkili Ad Soyad</label>
                            <input type="text" name="yetkili" value="<?php echo $bayi['yetkili_ad_soyad']; ?>" required>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col">
                            <label>Vergi Dairesi</label>
                            <input type="text" name="vergi_dairesi" value="<?php echo $bayi['vergi_dairesi']; ?>">
                        </div>
                        <div class="form-group col">
                            <label>Vergi No</label>
                            <input type="text" name="vergi_no" value="<?php echo $bayi['vergi_no']; ?>">
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col">
                            <label>Telefon</label>
                            <input type="text" name="telefon" value="<?php echo $bayi['telefon']; ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Adres</label>
                        <textarea name="adres" rows="3"><?php echo $bayi['adres']; ?></textarea>
                    </div>

                    <div class="form-section-title mt-30">Güvenlik (Boş bırakırsanız değişmez)</div>
                    <div class="form-row">
                        <div class="form-group col">
                            <label>Yeni Şifre</label>
                            <input type="password" name="new_password" placeholder="******">
                        </div>
                    </div>

                    <button type="submit" class="btn-save"><i class="fa-solid fa-floppy-disk"></i> Güncelle</button>
                </form>
            </div>
        <?php endif; ?>

    </main>
</div>

</body>
</html>