<?php
require_once 'private/config.php';

// Oturum kontrolü
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'guest';

// Eğer kullanıcı zaten giriş yapmışsa (Üye veya Bayi), seçime gerek yok, direkt kasaya yolla
if ($user_role === 'member' || $user_role === 'dealer') {
    header("Location: kasa.php");
    exit;
}

// Tema ayarları (Buton renkleri vs için)
$tema = $db->query("SELECT * FROM site_tema_ayarlari WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if(!$tema) { $tema = ['kart_buton_bg'=>'#2563eb']; }
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Siparişi Tamamla | E-Ticaret</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/kasa-gecis-aktar.css?v=<?php echo time(); ?>">
    <style>
        :root { --theme-color: <?php echo $tema['kart_buton_bg']; ?>; }
    </style>
</head>
<body>

<header class="site-header-simple">
    <div class="container">
        <div class="logo">LOGO</div>
        <a href="sepet.php" class="back-link"><i class="fa-solid fa-arrow-left"></i> Sepete Dön</a>
    </div>
</header>

<div class="container transition-container">
    <div class="transition-header">
        <h1>Nasıl Devam Etmek İstersiniz?</h1>
        <p>Siparişinizi tamamlamak için size en uygun seçeneği belirleyin.</p>
    </div>

    <div class="options-grid">
        
        <!-- SEÇENEK 1: MİSAFİR -->
        <div class="option-card guest-card">
            <div class="icon-wrap"><i class="fa-solid fa-person-walking-luggage"></i></div>
            <h2>Üye Olmadan Devam Et</h2>
            <p>Hızlıca sipariş vermek istiyorum. Fatura ve kargo bilgilerimi bir sonraki adımda gireceğim.</p>
            <a href="kasa.php?type=guest" class="btn-action btn-guest">Misafir Olarak Devam Et</a>
        </div>

        <!-- SEÇENEK 2: ÜYE GİRİŞİ -->
        <div class="option-card member-card">
            <div class="icon-wrap"><i class="fa-solid fa-user-check"></i></div>
            <h2>Kayıtlı Üyeyim</h2>
            <p>Daha önceden kayıt olmuştum. Kayıtlı adreslerim ve bilgilerimle hızlıca sipariş vereceğim.</p>
            <a href="uye-giris.php?redirect=kasa.php" class="btn-action btn-member">Üye Girişi Yap</a>
        </div>

        <!-- SEÇENEK 3: YENİ KAYIT -->
        <div class="option-card register-card">
            <div class="icon-wrap"><i class="fa-solid fa-user-plus"></i></div>
            <h2>Yeni Üyelik Oluştur</h2>
            <p>Hem bu siparişimi kolayca takip etmek hem de sonraki alışverişlerimde hız kazanmak istiyorum.</p>
            <a href="uye-kayit.php?redirect=kasa.php" class="btn-action btn-register">Hemen Kayıt Ol</a>
        </div>

    </div>

    <!-- BAYİ GİRİŞİ İÇİN KÜÇÜK LİNK -->
    <div class="dealer-login-area">
        Kurumsal bir müşteri (B2B Bayi) misiniz? <a href="bayi-panel-giris.php?redirect=kasa.php">Bayi Girişi Yapın</a>
    </div>
</div>

</body>
</html>