<?php
require_once 'private/config.php';

// Oturum Bilgileri
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'guest';
$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;
$session_id = session_id();

// --- 1. AYARLAR VE TEMA ---
$tema = $db->query("SELECT * FROM site_tema_ayarlari WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if(!$tema) { $tema = ['kart_buton_bg'=>'#f97316','kart_buton_text'=>'#fff']; }

$siteAyarlari = $db->query("SELECT * FROM site_ayarlari WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$girisTipi = $siteAyarlari ? $siteAyarlari['fiyat_giris_tipi'] : 0; 

// --- 2. VARSAYILAN PARA BİRİMİNİ ÇEK ---
$defCurrency = $db->query("SELECT * FROM para_birimleri WHERE varsayilan=1 AND durum=1")->fetch(PDO::FETCH_ASSOC);
if(!$defCurrency) {
    $defCurrency = ['kur' => 1.0000, 'sembol' => '₺', 'kod' => 'TL'];
}
$defKur = floatval($defCurrency['kur']);
$defSembol = $defCurrency['sembol'];

// --- 3. KULLANICI BİLGİLERİNİ ÇEK (PHP 8.1+ UYUMLU) ---
$userData = [
    'ad_soyad' => $_POST['ad_soyad'] ?? '', 
    'email' => $_POST['email'] ?? '', 
    'telefon' => $_POST['telefon'] ?? '', 
    'adres' => $_POST['adres'] ?? '', 
    'il' => $_POST['il'] ?? '', 
    'ilce' => $_POST['ilce'] ?? ''
];

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['complete_order'])) {
    if ($user_role === 'member' && $user_id) {
        $u = $db->query("SELECT * FROM uyeler WHERE id = $user_id")->fetch(PDO::FETCH_ASSOC);
        if($u) { 
            $userData = [
                'ad_soyad' => $u['ad_soyad'] ?? '', 'email' => $u['email'] ?? '', 'telefon' => $u['telefon'] ?? '', 
                'adres' => $u['adres'] ?? '', 'il' => $u['il'] ?? '', 'ilce' => $u['ilce'] ?? ''
            ]; 
        }
    } elseif ($user_role === 'dealer' && $user_id) {
        $b = $db->query("SELECT * FROM bayiler WHERE id = $user_id")->fetch(PDO::FETCH_ASSOC);
        if($b) { 
            $userData = [
                'ad_soyad' => $b['yetkili_ad_soyad'] ?? '', 'email' => $b['email'] ?? '', 'telefon' => $b['telefon'] ?? '', 
                'adres' => $b['adres'] ?? '', 'il' => $b['il'] ?? '', 'ilce' => $b['ilce'] ?? ''
            ]; 
        }
    }
}

// --- 4. SEPET VE KAMPANYA HESAPLAMA ---
$now = date('Y-m-d H:i:s');
$campaigns = $db->query("SELECT * FROM indirimler WHERE durum = 1 AND (baslangic_tarihi IS NULL OR baslangic_tarihi <= '$now') AND (bitis_tarihi IS NULL OR bitis_tarihi >= '$now') ORDER BY hedef_tipi DESC")->fetchAll(PDO::FETCH_ASSOC);

function calculateRuntimeDiscount($productId, $categoryId, $basePrice, $campaigns) {
    $bestPrice = $basePrice;
    foreach ($campaigns as $camp) {
        $isMatch = false;
        if ($camp['hedef_tipi'] == 'urun') {
            $ids = explode(',', $camp['hedef_id']);
            if (in_array($productId, $ids)) $isMatch = true;
        } elseif ($camp['hedef_tipi'] == 'kategori') {
            $ids = explode(',', $camp['hedef_id']);
            if (in_array($categoryId, $ids)) $isMatch = true;
        } elseif ($camp['hedef_tipi'] == 'genel') { $isMatch = true; }

        if ($isMatch) {
            $calcPrice = $basePrice;
            if ($camp['indirim_turu'] == 'oran') { $calcPrice = $basePrice - ($basePrice * $camp['indirim_degeri'] / 100); } 
            else { $calcPrice = $basePrice - $camp['indirim_degeri']; }
            if ($calcPrice < $bestPrice) { $bestPrice = $calcPrice; }
            if ($camp['hedef_tipi'] != 'genel') break;
        }
    }
    return $bestPrice;
}

$cartItems = [];
$subTotalNoKdv = 0; $totalKdvAmount = 0; $cartTotalWithKdv = 0; $totalProductSavings = 0; $rawUrunlerToplami = 0;

$whereSql = ($user_role === 'member') ? "s.uye_id = ?" : (($user_role === 'dealer') ? "s.bayi_id = ?" : "s.session_id = ? AND s.uye_id IS NULL AND s.bayi_id IS NULL");
$targetId = ($user_role === 'guest') ? $session_id : $user_id;

$sql = "SELECT s.miktar, u.id as urun_id, u.urun_adi, u.fiyat as u_fiyat, u.indirimli_fiyat as u_indirim, u.kdv_orani as u_kdv, u.kategori_id as u_kat, pb.kur as para_kur 
        FROM sepet s 
        INNER JOIN urunler u ON s.urun_id = u.id 
        LEFT JOIN para_birimleri pb ON u.para_birimi_id = pb.id 
        WHERE $whereSql";
$stmt = $db->prepare($sql);
$stmt->execute([$targetId]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($items as $item) {
    $rawPrice = $item['u_fiyat'];
    $manualDiscount = $item['u_indirim'];
    $rawKdv = $item['u_kdv'] ?: 0;
    
    $campPrice = calculateRuntimeDiscount($item['urun_id'], $item['u_kat'], $rawPrice, $campaigns);
    $activeBasePrice = ($manualDiscount > 0 && $manualDiscount < $rawPrice) ? min($manualDiscount, $campPrice) : $campPrice;

    $originalBase = ($girisTipi == 1) ? ($rawPrice / (1 + ($rawKdv / 100))) : $rawPrice;
    $finalBase = ($girisTipi == 1) ? ($activeBasePrice / (1 + ($rawKdv / 100))) : $activeBasePrice;

    $itemRate = floatval($item['para_kur'] ?: 1);
    $originalBasePriceDef = ($originalBase * $itemRate) / $defKur;
    $finalBasePriceDef = ($finalBase * $itemRate) / $defKur;

    $qty = floatval($item['miktar']);
    $kdvVal = ($finalBasePriceDef * $rawKdv) / 100;
    $originalKdvVal = ($originalBasePriceDef * $rawKdv) / 100;
    
    $unitPriceWithKdv = $finalBasePriceDef + $kdvVal;
    $originalUnitPriceWithKdv = $originalBasePriceDef + $originalKdvVal;

    $lineTotal = $unitPriceWithKdv * $qty;
    $originalLineTotal = $originalUnitPriceWithKdv * $qty;

    $subTotalNoKdv += ($finalBasePriceDef * $qty);
    $totalKdvAmount += ($kdvVal * $qty);
    $cartTotalWithKdv += $lineTotal;
    $totalProductSavings += ($originalLineTotal - $lineTotal);
    $rawUrunlerToplami += $originalLineTotal;

    $cartItems[] = [
        'id'    => $item['urun_id'], 
        'name'  => $item['urun_adi'], 
        'qty'   => $qty, 
        'price' => $unitPriceWithKdv,
        'total' => $lineTotal
    ];
}

// --- 5. HEDİYE ÇEKİ KONTROLÜ (B2B ŞARTLI) ---
$odemeAyari = $db->query("SELECT * FROM odeme_ayarlari WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
$couponDiscount = 0; $appliedCoupon = null; $couponMsg = "";
$coupon_code_input = $_POST['coupon_code'] ?? '';
if (isset($_POST['remove_coupon'])) { $coupon_code_input = ''; }

if (!empty($coupon_code_input)) {
    $code = strtoupper(trim($coupon_code_input));
    $stmtC = $db->prepare("SELECT * FROM hediye_cekleri WHERE cek_kodu = ? AND durum = 1 AND (baslangic_tarihi IS NULL OR baslangic_tarihi <= ?) AND (bitis_tarihi IS NULL OR bitis_tarihi >= ?)");
    $stmtC->execute([$code, $now, $now]);
    $coupon = $stmtC->fetch(PDO::FETCH_ASSOC);
    
    if ($coupon) {
        $currentUserType = ($user_role === 'member') ? 1 : (($user_role === 'dealer') ? 2 : 0);
        if ($coupon['hedef_grup'] == 0 || $coupon['hedef_grup'] == $currentUserType) {
            if ($cartTotalWithKdv >= $coupon['min_sepet_tutari']) {
                $appliedCoupon = $coupon;
                $couponDiscount = ($coupon['indirim_turu'] == 'oran') ? ($cartTotalWithKdv * $coupon['indirim_degeri'] / 100) : $coupon['indirim_degeri'];
            } else { $couponMsg = "Min. sepet ".number_format($coupon['min_sepet_tutari'],2)." ".$defSembol." olmalı."; }
        } else { $couponMsg = "Bu kupon grubunuza özeldir."; }
    } else { $couponMsg = "Geçersiz veya süresi dolmuş kupon kodu."; }
}

// --- 6. KARGO HESAPLAMA ---
$kargolar = $db->query("SELECT * FROM kargo_firmalari WHERE durum = 1 ORDER BY sira ASC")->fetchAll(PDO::FETCH_ASSOC);
$selectedKargoId = isset($_POST['kargo_id']) ? intval($_POST['kargo_id']) : (intval($kargolar[0]['id'] ?? 0));
$kargoPrice = 0;

foreach ($kargolar as &$k) {
    $ucret = 0;
    if ($k['ucretsiz_kargo_limiti'] > 0 && $cartTotalWithKdv >= $k['ucretsiz_kargo_limiti']) { $ucret = 0; } 
    else {
        $stmtB = $db->prepare("SELECT kargo_ucreti FROM kargo_baremleri WHERE kargo_id = ? AND alt_limit <= ? ORDER BY alt_limit DESC LIMIT 1");
        $stmtB->execute([$k['id'], $cartTotalWithKdv]);
        $baremVal = $stmtB->fetchColumn();
        $ucret = ($baremVal !== false) ? floatval($baremVal) : 50.00;
    }
    $k['hesaplanan_ucret'] = $ucret;
    if ($k['id'] == $selectedKargoId) $kargoPrice = $ucret;
}
unset($k);

// --- 7. ÖDEME YÖNTEMİ VE TOPLAM ---
$availablePayments = [];
if($odemeAyari['kk_durum']) $availablePayments[] = 'kk';
if($odemeAyari['havale_durum']) $availablePayments[] = 'havale';
if($odemeAyari['kapida_odeme_durum']) $availablePayments[] = 'kapida';
$selectedPayType = $_POST['odeme_tipi'] ?? ($availablePayments[0] ?? 'kk');
$payExtraFee = ($selectedPayType == 'kapida') ? floatval($odemeAyari['kapida_odeme_bedeli']) : 0;
$finalGrandTotal = ($cartTotalWithKdv - $couponDiscount) + $kargoPrice + $payExtraFee;

// --- 8. SİPARİŞİ TAMAMLA ---
if(isset($_POST['complete_order'])) {
    if(empty($cartItems)) { die("Sepetiniz boş."); }
    $siparis_kodu = 'S-' . strtoupper(substr(uniqid(), 7));
    $sip_durum = ($selectedPayType == 'kk') ? 'Ödeme Bekliyor' : 'Bekliyor';

    // KANKACIM: Toplam indirimi ve kupon kodunu burada mühürlüyoruz
    $toplam_indirim_miktari = $totalProductSavings + $couponDiscount;
    $kupon_kodu_kaydi = $appliedCoupon ? $appliedCoupon['cek_kodu'] : null;

    try {
        $db->beginTransaction();
        $sqlIns = "INSERT INTO siparisler (
            siparis_kodu, uye_id, bayi_id, kargo_id, ad_soyad, email, telefon, il, ilce, adres, 
            toplam_tutar, net_tutar, kdv_tutar, urunler_toplami, 
            kargo_ucreti, indirim_tutari, kupon_kodu, kapida_odeme_farki, odeme_tipi, durum, siparis_tarihi
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";
        
        $db->prepare($sqlIns)->execute([
            $siparis_kodu, ($user_role == 'member' ? $user_id : null), ($user_role == 'dealer' ? $user_id : null), $selectedKargoId,
            $userData['ad_soyad'], $userData['email'], $userData['telefon'], $userData['il'], $userData['ilce'], $userData['adres'],
            $finalGrandTotal, $subTotalNoKdv, $totalKdvAmount, $rawUrunlerToplami,
            $kargoPrice, $toplam_indirim_miktari, $kupon_kodu_kaydi, $payExtraFee, $selectedPayType, $sip_durum
        ]);
        
        $sip_db_id = $db->lastInsertId();
        $stmtProd = $db->prepare("INSERT INTO siparis_urunler (siparis_id, urun_id, urun_adi, miktar, birim_fiyat) VALUES (?, ?, ?, ?, ?)");
        foreach ($cartItems as $ci) { $stmtProd->execute([$sip_db_id, $ci['id'], $ci['name'], $ci['qty'], $ci['price']]); }
        
        // Kupon kullanım adedini artır
        if($appliedCoupon) {
            $db->prepare("UPDATE hediye_cekleri SET kullanilan_adet = kullanilan_adet + 1 WHERE id = ?")->execute([$appliedCoupon['id']]);
        }

        $db->commit();

        $_SESSION['last_order_id'] = $sip_db_id;
        if ($selectedPayType == 'kk') { header("Location: online-odeme.php"); } 
        else {
            $col_where = ($user_role == 'member') ? "uye_id = ?" : (($user_role == 'dealer') ? "bayi_id = ?" : "session_id = ? AND uye_id IS NULL AND bayi_id IS NULL");
            $db->prepare("DELETE FROM sepet WHERE $col_where")->execute([$targetId]);
            header("Location: odeme-sonuc.php?status=success");
        }
        exit;
    } catch (Exception $e) { 
        if ($db->inTransaction()) $db->rollBack(); 
        die("Hata: " . $e->getMessage()); 
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Güvenli Ödeme | Kasa</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/kasa.css?v=<?php echo time(); ?>">
    <style> 
        :root { --theme-color: <?php echo $tema['kart_buton_bg']; ?>; } 
        .selection-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        @media (max-width: 850px) { .selection-grid { grid-template-columns: 1fr; } }
        .selection-card { border: 2px solid #e5e7eb; border-radius: 10px; padding: 15px; cursor: pointer; background: #fff; display: flex; align-items: center; gap: 12px; transition: .2s; }
        .selection-card.active { border-color: var(--theme-color); background: #fffaf5; }
        .selection-card input { width: 18px; height: 18px; }
        .selection-info { flex-grow: 1; pointer-events: none; }
        .selection-info strong { display: block; font-size: 0.95rem; color: #111827; }
        .selection-info span { font-size: 0.75rem; color: #6b7280; }
        .price-tag { font-weight: 700; color: var(--theme-color); margin-left: auto; }
        .havale-box { margin-top: 10px; padding: 12px; background: #f8fafc; border: 1px dashed #cbd5e1; border-radius: 8px; font-size: 0.8rem; color: #475569; }
        .coupon-status-box { background: #ecfdf5; border: 1px solid #10b981; border-radius: 6px; padding: 8px 12px; display: flex; justify-content: space-between; align-items: center; margin-top: 10px; }
        .coupon-info-text { color: #065f46; font-size: 0.85rem; font-weight: 600; }
        .btn-remove-coupon { background: #ef4444; color: white; border: none; padding: 4px 8px; border-radius: 4px; font-size: 0.75rem; cursor: pointer; transition: .2s; }
    </style>
</head>
<body>

<header class="checkout-header">
    <div class="container">
        <div class="logo">LOGO</div>
        <div class="secure-badge"><i class="fa-solid fa-shield-halved"></i> GÜVENLİ ÖDEME SİSTEMİ</div>
    </div>
</header>

<div class="container checkout-container">
    <form action="kasa.php" method="POST" id="checkoutForm">
        <div class="checkout-layout">
            
            <div class="checkout-main">
                <div class="step-card">
                    <div class="step-title"><span>1</span> <h3>Adres ve İletişim Bilgileri</h3></div>
                    <div class="step-body">
                        <div class="form-row">
                            <div class="form-group col"><label>Ad Soyad</label><input type="text" name="ad_soyad" required value="<?php echo htmlspecialchars($userData['ad_soyad'] ?? ''); ?>"></div>
                            <div class="form-group col"><label>E-Posta</label><input type="email" name="email" required value="<?php echo htmlspecialchars($userData['email'] ?? ''); ?>"></div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col"><label>Telefon</label><input type="tel" name="telefon" required value="<?php echo htmlspecialchars($userData['telefon'] ?? ''); ?>"></div>
                            <div class="form-group col"><label>İl</label><input type="text" name="il" required placeholder="Örn: İstanbul" value="<?php echo htmlspecialchars($userData['il'] ?? ''); ?>"></div>
                            <div class="form-group col"><label>İlçe</label><input type="text" name="ilce" required placeholder="Örn: Kadıköy" value="<?php echo htmlspecialchars($userData['ilce'] ?? ''); ?>"></div>
                        </div>
                        <div class="form-group"><label>Açık Adres</label><textarea name="adres" rows="2" required><?php echo htmlspecialchars($userData['adres'] ?? ''); ?></textarea></div>
                    </div>
                </div>

                <div class="selection-grid mt-20">
                    <div class="step-card">
                        <div class="step-title"><span>2</span> <h3>Kargo Tercihi</h3></div>
                        <div class="step-body">
                            <div class="selection-group">
                                <?php foreach($kargolar as $k): ?>
                                    <label for="k_<?php echo $k['id']; ?>" class="selection-card <?php echo $selectedKargoId == $k['id'] ? 'active' : ''; ?>">
                                        <input type="radio" name="kargo_id" id="k_<?php echo $k['id']; ?>" value="<?php echo $k['id']; ?>" <?php echo $selectedKargoId == $k['id'] ? 'checked' : ''; ?> onchange="this.form.submit()">
                                        <div class="selection-info">
                                            <strong><?php echo htmlspecialchars($k['firma_adi']); ?></strong>
                                            <span><?php echo $k['ucretsiz_kargo_limiti'] > 0 ? number_format($k['ucretsiz_kargo_limiti'], 0).' '.$defSembol.' Üzeri Ücretsiz' : 'Hızlı Gönderim'; ?></span>
                                        </div>
                                        <div class="price-tag"><?php echo $k['hesaplanan_ucret'] > 0 ? number_format($k['hesaplanan_ucret'], 2).' '.$defSembol : '<span style="color:#10b981">Ücretsiz</span>'; ?></div>
                                    </label>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>

                    <div class="step-card">
                        <div class="step-title"><span>3</span> <h3>Ödeme Yöntemi</h3></div>
                        <div class="step-body">
                            <div class="selection-group">
                                <?php if($odemeAyari['kk_durum']): ?>
                                    <label for="p_kk" class="selection-card <?php echo $selectedPayType == 'kk' ? 'active' : ''; ?>">
                                        <input type="radio" name="odeme_tipi" id="p_kk" value="kk" <?php echo $selectedPayType == 'kk' ? 'checked' : ''; ?> onchange="this.form.submit()">
                                        <div class="selection-info"><strong>Kredi Kartı</strong><span>Sanal POS ile Güvenli Ödeme</span></div>
                                    </label>
                                <?php endif; ?>
                                <?php if($odemeAyari['havale_durum']): ?>
                                    <label for="p_havale" class="selection-card <?php echo $selectedPayType == 'havale' ? 'active' : ''; ?>">
                                        <input type="radio" name="odeme_tipi" id="p_havale" value="havale" <?php echo $selectedPayType == 'havale' ? 'checked' : ''; ?> onchange="this.form.submit()">
                                        <div class="selection-info"><strong>Havale / EFT</strong><span>Banka hesaplarımıza transfer</span></div>
                                    </label>
                                <?php endif; ?>
                                <?php if($odemeAyari['kapida_odeme_durum']): ?>
                                    <label for="p_kapida" class="selection-card <?php echo $selectedPayType == 'kapida' ? 'active' : ''; ?>">
                                        <input type="radio" name="odeme_tipi" id="p_kapida" value="kapida" <?php echo $selectedPayType == 'kapida' ? 'checked' : ''; ?> onchange="this.form.submit()">
                                        <div class="selection-info"><strong>Kapıda Ödeme</strong><span>Kapıda nakit/kart ile öde</span></div>
                                        <div class="price-tag">+<?php echo number_format($odemeAyari['kapida_odeme_bedeli'], 2); ?> <?php echo $defSembol; ?></div>
                                    </label>
                                <?php endif; ?>
                            </div>
                            <?php if($selectedPayType == 'havale'): ?>
                                <div class="havale-box"><strong>Banka Bilgileri:</strong><br><?php echo nl2br(htmlspecialchars($odemeAyari['havale_aciklama'] ?? '')); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <aside class="checkout-sidebar">
                <div class="summary-card sticky-summary">
                    <h3>Sipariş Özeti</h3>
                    <div class="summary-items">
                        <?php foreach($cartItems as $ci): ?>
                            <div class="s-item"><span><?php echo htmlspecialchars($ci['name']); ?> (x<?php echo $ci['qty']+0; ?>)</span><span><?php echo number_format($ci['total'], 2, ',', '.'); ?> <?php echo $defSembol; ?></span></div>
                        <?php endforeach; ?>
                    </div>
                    
                    <div class="coupon-area mt-15" style="display:<?php echo $appliedCoupon ? 'none' : 'flex'; ?>; gap:6px;">
                        <input type="text" name="coupon_code" placeholder="Kupon Kodu" value="<?php echo htmlspecialchars($coupon_code_input); ?>">
                        <button type="submit">Uygula</button>
                    </div>
                    <?php if($appliedCoupon): ?>
                        <div class="coupon-status-box">
                            <div class="coupon-info-text"><i class="fa-solid fa-ticket"></i> <?php echo $appliedCoupon['cek_kodu']; ?> Uygulandı</div>
                            <button type="submit" name="remove_coupon" class="btn-remove-coupon">Kaldır</button>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty($couponMsg)): ?><div style="color:#ef4444; font-size:0.75rem; margin-top:5px;"><?php echo $couponMsg; ?></div><?php endif; ?>

                    <div class="summary-totals">
                        <div class="s-row"><span>Sepet Toplamı</span> <span><?php echo number_format($rawUrunlerToplami, 2, ',', '.'); ?> <?php echo $defSembol; ?></span></div>
                        <?php if($totalProductSavings > 0 || $couponDiscount > 0): ?>
                            <div class="s-row text-green"><span>İndirimler</span> <span>-<?php echo number_format($totalProductSavings + $couponDiscount, 2, ',', '.'); ?> <?php echo $defSembol; ?></span></div>
                        <?php endif; ?>
                        <div class="s-row"><span>KDV Toplamı</span> <span><?php echo number_format($totalKdvAmount, 2, ',', '.'); ?> <?php echo $defSembol; ?></span></div>
                        <div class="s-row"><span>Kargo Ücreti</span> <span><?php echo $kargoPrice > 0 ? number_format($kargoPrice, 2, ',', '.').' '.$defSembol : 'Ücretsiz'; ?></span></div>
                        <?php if($payExtraFee > 0): ?><div class="s-row"><span>Hizmet Bedeli</span> <span><?php echo number_format($payExtraFee, 2, ',', '.'); ?> <?php echo $defSembol; ?></span></div><?php endif; ?>
                        
                        <div class="s-row grand-total"><span>TOPLAM</span> <span><?php echo number_format($finalGrandTotal, 2, ',', '.'); ?> <?php echo $defSembol; ?></span></div>
                    </div>
                    <button type="submit" name="complete_order" class="btn-complete">SİPARİŞİ ONAYLA <i class="fa-solid fa-circle-right"></i></button>
                </div>
            </aside>
        </div>
    </form>
</div>
</body>
</html>