<?php
require_once 'private/config.php';

// Kankacım session zaten config içinde başlamadıysa burada garantiye alalım
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 1. DURUM VE VERİ KONTROLÜ
$status = $_GET['status'] ?? 'fail';
$siparis_id = $_SESSION['last_order_id'] ?? null;
$session_id = session_id();

// Tema ayarlarını çek (Buton renkleri için)
$tema = $db->query("SELECT * FROM site_tema_ayarlari WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if(!$tema) { $tema = ['kart_buton_bg'=>'#f97316']; }

$siparis = null;
if ($siparis_id) {
    $stmt = $db->prepare("SELECT * FROM siparisler WHERE id = ?");
    $stmt->execute([$siparis_id]);
    $siparis = $stmt->fetch(PDO::FETCH_ASSOC);
}

// 2. BAŞARI DURUMUNDA SEPETİ TEMİZLE (KANKACIM BURADAKİ \_ HATASI DÜZELTİLDİ)
if ($status === 'success') {
    // Kullanıcı rolüne göre sepeti temizliyoruz
    if (isset($_SESSION['user_role'])) {
        if ($_SESSION['user_role'] === 'member' && isset($_SESSION['user_id'])) {
            $db->prepare("DELETE FROM sepet WHERE uye_id = ?")->execute([$_SESSION['user_id']]);
        } elseif ($_SESSION['user_role'] === 'dealer' && isset($_SESSION['user_id'])) {
            $db->prepare("DELETE FROM sepet WHERE bayi_id = ?")->execute([$_SESSION['user_id']]);
        }
    } else {
        // Misafir ise session_id üzerinden temizle
        $db->prepare("DELETE FROM sepet WHERE session_id = ? AND uye_id IS NULL AND bayi_id IS NULL")->execute([$session_id]);
    }
    
    // Siparişi başarıyla tamamladık, session'daki ID'yi temizlemeden önce bir değişkene alıp aşağıda kullanıyoruz
    // unset($_SESSION['last_order_id']); 
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>İşlem Sonucu | E-Ticaret</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --theme-color: <?php echo $tema['kart_buton_bg']; ?>; }
        body { font-family: 'Roboto', sans-serif; background-color: #f3f4f6; margin: 0; display: flex; align-items: center; justify-content: center; min-height: 100vh; }
        .container { width: 100%; max-width: 600px; padding: 20px; }
        .result-card { background: #fff; border-radius: 16px; box-shadow: 0 10px 25px rgba(0,0,0,0.05); padding: 40px; text-align: center; border-top: 6px solid #e5e7eb; }
        
        .result-card.success { border-top-color: #10b981; }
        .icon-box.success { color: #10b981; background: #ecfdf5; }
        
        .result-card.fail { border-top-color: #ef4444; }
        .icon-box.fail { color: #ef4444; background: #fef2f2; }

        .icon-box { width: 80px; height: 80px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 2.5rem; margin: 0 auto 25px; }
        
        h1 { font-size: 1.8rem; color: #111827; margin-bottom: 10px; }
        p { color: #6b7280; line-height: 1.6; margin-bottom: 30px; }
        
        .order-info { background: #f9fafb; border-radius: 12px; padding: 20px; text-align: left; margin-bottom: 30px; border: 1px solid #eee; }
        .info-row { display: flex; justify-content: space-between; margin-bottom: 10px; font-size: 0.95rem; }
        .info-row:last-child { margin-bottom: 0; padding-top: 10px; border-top: 1px dashed #ddd; font-weight: 700; }

        .actions { display: flex; gap: 15px; }
        .btn { flex: 1; padding: 14px; border-radius: 8px; font-weight: 700; text-decoration: none; transition: .2s; cursor: pointer; border: none; display: inline-flex; align-items: center; justify-content: center; gap: 8px; }
        .btn-primary { background: var(--theme-color); color: #fff; }
        .btn-secondary { background: #f3f4f6; color: #4b5563; }
        .btn:hover { opacity: 0.9; transform: translateY(-2px); }

        @media (max-width: 500px) { .actions { flex-direction: column; } }
    </style>
</head>
<body>

<div class="container">
    <div class="result-card <?php echo $status === 'success' ? 'success' : 'fail'; ?>">
        
        <?php if($status === 'success'): ?>
            <div class="icon-box success"><i class="fa-solid fa-check"></i></div>
            <h1>Siparişiniz Alındı!</h1>
            <p>İşleminiz başarıyla tamamlandı. Siparişiniz sisteme kaydedildi ve hazırlık süreci başladı.</p>
            
            <?php if($siparis): ?>
                <div class="order-info">
                    <div class="info-row"><span>Sipariş No:</span> <strong>#<?php echo $siparis['siparis_kodu']; ?></strong></div>
                    <div class="info-row"><span>Ödeme Tipi:</span> <span><?php echo strtoupper($siparis['odeme_tipi'] ?? 'Havale'); ?></span></div>
                    <div class="info-row"><span>Toplam Tutar:</span> <strong><?php echo number_format($siparis['toplam_tutar'], 2, ',', '.'); ?> ₺</strong></div>
                </div>
            <?php endif; ?>

            <div class="actions">
                <a href="index.php" class="btn btn-secondary"><i class="fa-solid fa-house"></i> Anasayfa</a>
                <?php 
                    $panelLink = (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'dealer') ? 'bayi-panel.php?tab=orders' : 'uye-panel.php?tab=orders';
                    if(!isset($_SESSION['user_role']) || $_SESSION['user_role'] === 'guest') $panelLink = 'index.php';
                ?>
                <a href="<?php echo $panelLink; ?>" class="btn btn-primary"><i class="fa-solid fa-box-open"></i> Siparişlerim</a>
            </div>

        <?php else: ?>
            <div class="icon-box fail"><i class="fa-solid fa-xmark"></i></div>
            <h1>İşlem Başarısız</h1>
            <p>Maalesef siparişiniz tamamlanırken bir sorun oluştu. Lütfen ödeme bilgilerinizi kontrol edip tekrar deneyiniz veya müşteri temsilcinizle iletişime geçiniz.</p>
            
            <div class="actions">
                <a href="kasa.php" class="btn btn-primary"><i class="fa-solid fa-rotate-left"></i> Tekrar Dene</a>
                <a href="index.php" class="btn btn-secondary">Anasayfaya Dön</a>
            </div>
        <?php endif; ?>

    </div>
</div>

</body>
</html>