<?php
require_once 'private/config.php';

if (!isset($_SESSION['last_order_id'])) {
    header("Location: sepet.php");
    exit;
}

$siparis_id = $_SESSION['last_order_id'];
$stmt = $db->prepare("SELECT * FROM siparisler WHERE id = ?");
$stmt->execute([$siparis_id]);
$siparis = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$siparis) { die("Sipariş bulunamadı."); }

$urunler = $db->query("SELECT * FROM siparis_urunler WHERE siparis_id = $siparis_id")->fetchAll(PDO::FETCH_ASSOC);
$odeme = $db->query("SELECT * FROM odeme_ayarlari WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
$tema = $db->query("SELECT * FROM site_tema_ayarlari WHERE id = 1")->fetch(PDO::FETCH_ASSOC);

$show_iframe = false;
$token = "";
$error_msg = "";

if ($odeme['kk_durum'] == 1 && $odeme['kk_saglayici'] == 'paytr') {
    
    // --- PAYTR TOKEN ALMA MOTORU ---
    $merchant_id    = $odeme['paytr_merchant_id'];
    $merchant_key   = $odeme['paytr_merchant_key'];
    $merchant_salt  = $odeme['paytr_merchant_salt'];

    $email          = $siparis['email'];
    $payment_amount = round($siparis['toplam_tutar'] * 100); // Kuruş cinsinden (Örn: 10.50 TL -> 1050)
    $merchant_oid   = $siparis['siparis_kodu']; 
    $user_name      = $siparis['ad_soyad'];
    $user_address   = $siparis['adres'];
    $user_phone     = $siparis['telefon'];
    
    // Kankacım bu URL'leri PayTR paneliyle uyumlu yapmalısın
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
    $domain = $_SERVER['HTTP_HOST'];
    $merchant_ok_url = "$protocol://$domain/odeme-sonuc.php?status=success";
    $merchant_fail_url = "$protocol://$domain/odeme-sonuc.php?status=fail";

    // Sepet Verisi
    $user_basket_arr = [];
    foreach($urunler as $u) { $user_basket_arr[] = [$u['urun_adi'], number_format($u['birim_fiyat'], 2, '.', ''), (int)$u['miktar']]; }
    // Kargo ve ek ücretleri de ekleyelim
    if($siparis['kargo_ucreti'] > 0) $user_basket_arr[] = ['Kargo Ücreti', number_format($siparis['kargo_ucreti'], 2, '.', ''), 1];
    if($siparis['kapida_odeme_farki'] > 0) $user_basket_arr[] = ['Hizmet Bedeli', number_format($siparis['kapida_odeme_farki'], 2, '.', ''), 1];
    
    $user_basket = base64_encode(json_encode($user_basket_arr));

    $user_ip = $_SERVER['REMOTE_ADDR'];
    $timeout_limit = "30";
    $debug_on = 1; 
    $test_mode = ($odeme['paytr_merchant_id'] == 'TEST_ID') ? 1 : 0; // Eğer test verileri varsa test modunu aç
    $no_installment = 0; 
    $max_installment = 0; 
    $currency = "TL";

    $hash_str = $merchant_id .$user_ip .$merchant_oid .$email .$payment_amount .$user_basket .$no_installment .$max_installment .$currency .$test_mode;
    $paytr_token = base64_encode(hash_hmac('sha256', $hash_str . $merchant_salt, $merchant_key, true));

    $post_vals = array(
        'merchant_id' => $merchant_id, 'user_ip' => $user_ip, 'merchant_oid' => $merchant_oid,
        'email' => $email, 'payment_amount' => $payment_amount, 'paytr_token' => $paytr_token,
        'user_basket' => $user_basket, 'debug_on' => $debug_on, 'no_installment' => $no_installment,
        'max_installment' => $max_installment, 'user_name' => $user_name, 'user_address' => $user_address,
        'user_phone' => $user_phone, 'merchant_ok_url' => $merchant_ok_url, 'merchant_fail_url' => $merchant_fail_url,
        'timeout_limit' => $timeout_limit, 'currency' => $currency, 'test_mode' => $test_mode
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://www.paytr.com/odeme/api/get-token");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_vals);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    $result = @json_decode(curl_exec($ch), true);
    curl_close($ch);

    if (isset($result['status']) && $result['status'] == 'success') {
        $token = $result['token'];
        $show_iframe = true;
    } else {
        $error_msg = $result['failed_reason'] ?? "PayTR bağlantı hatası oluştu.";
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Güvenli Ödeme Ekranı</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { font-family: 'Roboto', sans-serif; background: #f3f4f6; margin: 0; padding: 20px; display: flex; justify-content: center; align-items: flex-start; min-height: 100vh; }
        .payment-card { background: #fff; width: 100%; max-width: 900px; border-radius: 12px; box-shadow: 0 10px 25px rgba(0,0,0,0.1); padding: 30px; }
        .order-brief { background: #f9fafb; padding: 15px; border-radius: 8px; margin-bottom: 25px; border: 1px solid #eee; display: flex; justify-content: space-between; align-items: center; }
        .total { color: <?php echo $tema['kart_buton_bg']; ?>; font-size: 1.5rem; font-weight: 800; }
        iframe { border: none; width: 100%; min-height: 650px; }
        .error-box { background: #fef2f2; color: #b91c1c; padding: 20px; border-radius: 8px; border: 1px solid #fee2e2; }
    </style>
</head>
<body>

<div class="payment-card">
    <div style="text-align:center; margin-bottom:20px;">
        <h2 style="margin:0;">Güvenli Ödeme</h2>
        <p style="color:#6b7280; font-size:0.9rem;"><i class="fa-solid fa-lock"></i> 256-Bit SSL ile korunmaktadır.</p>
    </div>

    <div class="order-brief">
        <span>Sipariş No: <strong>#<?php echo $siparis['siparis_kodu']; ?></strong></span>
        <span class="total"><?php echo number_format($siparis['toplam_tutar'], 2, ',', '.'); ?> ₺</span>
    </div>

    <?php if($show_iframe): ?>
        <script src="https://www.paytr.com/js/iframeResizer.min.js"></script>
        <iframe src="https://www.paytr.com/odeme/guvenli/<?php echo $token; ?>" id="paytriframe" frameborder="0" scrolling="no"></iframe>
        <script>iFrameResize({},'#paytriframe');</script>
    <?php else: ?>
        <div class="error-box">
            <h3><i class="fa-solid fa-circle-exclamation"></i> Ödeme Başlatılamadı</h3>
            <p><?php echo $error_msg; ?></p>
            <a href="kasa.php" style="color:#b91c1c; font-weight:bold;">Kasaya Dön ve Tekrar Dene</a>
        </div>
    <?php endif; ?>
</div>

</body>
</html>