<?php
/**
 * PAYTR BİLDİRİM URL (NOTIFY URL)
 * Kankacım bu dosya müşteriye görünmez. 
 * PayTR ödeme başarılı olduğunda sunucudan sunucuya buraya bağlanır.
 */
require_once 'private/config.php';

// 1. PayTR'den gelen verileri alalım
$post = $_POST;

// 2. Kendi anahtarlarımızı çekelim
$odeme = $db->query("SELECT * FROM odeme_ayarlari WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
$merchant_key  = $odeme['paytr_merchant_key'];
$merchant_salt = $odeme['paytr_merchant_salt'];

// 3. Güvenlik Kontrolü (Hash Doğrulama)
$hash = base64_encode(hash_hmac('sha256', $post['merchant_oid'] . $merchant_salt . $post['status'] . $post['total_amount'], $merchant_key, true));

if ($hash != $post['hash']) {
    die('PAYTR notification failed: bad hash');
}

// 4. İşlem Durumuna Göre Siparişi Güncelle
if ($post['status'] == 'success') {
    
    // ÖDEME BAŞARILI
    $merchant_oid = $post['merchant_oid']; // Bizim sipariş kodumuz (S-637BAB vb.)
    
    // Siparişi bul ve durumunu güncelle
    $stmt = $db->prepare("UPDATE siparisler SET durum = 'Bekliyor', paytr_token = ? WHERE siparis_kodu = ?");
    $stmt->execute([$post['hash'], $merchant_oid]);
    
    // Sepeti temizle (Eğer ödeme-sonuc sayfasında temizlenmediyse burada garantiye alıyoruz)
    // Kankacım burada siparişi veren üyeyi bulup sepetini silebilirsin.
    
} else {
    // ÖDEME BAŞARISIZ
    $merchant_oid = $post['merchant_oid'];
    $failed_reason_msg = $post['failed_reason_msg'];
    
    $stmt = $db->prepare("UPDATE siparisler SET durum = 'İptal', odeme_hata_notu = ? WHERE siparis_kodu = ?");
    $stmt->execute([$failed_reason_msg, $merchant_oid]);
}

// 5. PayTR'ye "Mesajı aldım, her şey yolunda" de (ÇOK ÖNEMLİ)
echo "OK";