<?php
// Hata raporlamayı açalım (Geliştirme aşamasında)
// Canlıya alırken bunları kapatacağız.
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Veritabanı Bilgileri
define('DB_HOST', 'localhost');
define('DB_NAME', 'katalogbilgikutuk');
define('DB_USER', 'root'); // Sunucunda genelde kullanıcı adı farklıdır
define('DB_PASS', '');     // Şifreni buraya gireceksin

try {
    // PDO Nesnesi Oluşturma
    $db = new PDO("mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8mb4", DB_USER, DB_PASS);
    
    // Hata Modunu Ayarlama (Exception fırlatsın)
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Karakter Seti Ayarı (Türkçe karakterler için kritik)
    $db->exec("SET NAMES 'utf8mb4'");
    $db->exec("SET CHARACTER SET utf8mb4");
    $db->exec("SET COLLATION_CONNECTION = 'utf8mb4_general_ci'");
    
    // Varsayılan Fetch Modu (Verileri dizi yerine obje olarak çekmek daha temizdir)
    $db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    
    // Güvenlik: Emüle edilmiş prepare statement'ları kapat (SQL Injection önlemi)
    $db->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);

} catch (PDOException $e) {
    // Bağlantı hatası olursa kullanıcıya teknik detay gösterme, genel mesaj ver
    // Loglama yapılabilir: error_log($e->getMessage());
    die("Veritabanı bağlantı hatası: Sistemsel bir sorun oluştu.");
}

// Zaman Dilimi Ayarı (Türkiye)
date_default_timezone_set('Europe/Istanbul');

// Oturum Başlatma (Eğer başlatılmamışsa)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>