<?php
require_once 'private/config.php';

// Oturum Bilgileri
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'guest';
$uye_id = ($user_role === 'member') ? $_SESSION['user_id'] : null;
$bayi_id = ($user_role === 'dealer') ? $_SESSION['user_id'] : null;
$session_id = session_id();

// --- 1. AYARLAR VE TEMA ---
$tema = $db->query("SELECT * FROM site_tema_ayarlari WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if(!$tema) { $tema = ['site_url'=>'','kart_buton_bg'=>'#f97316','kart_buton_text'=>'#fff','kart_fiyat_renk'=>'#f97316','filtre_buton_renk'=>'#f97316','sidebar_baslik_renk'=>'#111827']; }

$siteAyarlari = $db->query("SELECT * FROM site_ayarlari WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$girisTipi = $siteAyarlari ? $siteAyarlari['fiyat_giris_tipi'] : 0; 
$gosterimTipi = $siteAyarlari ? $siteAyarlari['fiyat_gosterim_tipi'] : 0; 

// --- 2. VARSAYILAN PARA BİRİMİNİ ÇEK (KANKACIM BURASI YENİ) ---
$defaultCurrency = $db->query("SELECT * FROM para_birimleri WHERE varsayilan=1 AND durum=1")->fetch(PDO::FETCH_ASSOC);
if(!$defaultCurrency) {
    $defaultCurrency = ['kur' => 1.0000, 'sembol' => '₺', 'kod' => 'TL'];
}
$defKur = floatval($defaultCurrency['kur']);
$defSembol = $defaultCurrency['sembol'];

// --- 3. AKTİF KAMPANYALARI ÇEK (RUNTIME HESAPLAMA) ---
$now = date('Y-m-d H:i:s');
$campaigns = $db->query("SELECT * FROM indirimler WHERE durum = 1 AND (baslangic_tarihi IS NULL OR baslangic_tarihi <= '$now') AND (bitis_tarihi IS NULL OR bitis_tarihi >= '$now') ORDER BY hedef_tipi DESC")->fetchAll(PDO::FETCH_ASSOC);

// --- 4. YARDIMCI FONKSİYONLAR ---
function calculateRuntimeDiscount($productId, $categoryId, $basePrice, $campaigns) {
    $bestPrice = $basePrice;
    foreach ($campaigns as $camp) {
        $isMatch = false;
        if ($camp['hedef_tipi'] == 'urun') {
            $ids = explode(',', $camp['hedef_id']);
            if (in_array($productId, $ids)) $isMatch = true;
        } elseif ($camp['hedef_tipi'] == 'kategori') {
            $ids = explode(',', $camp['hedef_id']);
            if (in_array($categoryId, $ids)) $isMatch = true;
        } elseif ($camp['hedef_tipi'] == 'genel') {
            $isMatch = true;
        }

        if ($isMatch) {
            $calcPrice = $basePrice;
            if ($camp['indirim_turu'] == 'oran') {
                $calcPrice = $basePrice - ($basePrice * $camp['indirim_degeri'] / 100);
            } else {
                $calcPrice = $basePrice - $camp['indirim_degeri'];
            }
            if ($calcPrice < $bestPrice) { $bestPrice = $calcPrice; }
            if ($camp['hedef_tipi'] != 'genel') break;
        }
    }
    return $bestPrice;
}

// --- 5. SEPET İŞLEMLERİ (SİLME VE GÜNCELLEME) ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['action'])) {
        if ($_POST['action'] == 'remove' && isset($_POST['sepet_id'])) {
            $sepet_id = intval($_POST['sepet_id']);
            $db->prepare("DELETE FROM sepet WHERE id = ?")->execute([$sepet_id]);
            header("Location: sepet.php");
            exit;
        } elseif ($_POST['action'] == 'update_qty' && isset($_POST['sepet_id']) && isset($_POST['qty'])) {
            $sepet_id = intval($_POST['sepet_id']);
            $yeni_miktar = floatval($_POST['qty']);
            if ($yeni_miktar > 0) {
                $db->prepare("UPDATE sepet SET miktar = ? WHERE id = ?")->execute([$yeni_miktar, $sepet_id]);
            }
            header("Location: sepet.php");
            exit;
        }
    }
}

// --- 6. SEPET VERİLERİNİ ÇEKME ---
$cartItems = [];
$subTotalNoKdv = 0; 
$totalKdvAmount = 0; 
$grandTotal = 0;
$totalSavings = 0; 

$whereSql = "";
$params = [];
if ($uye_id) { $whereSql = "s.uye_id = ?"; $params[] = $uye_id; } 
elseif ($bayi_id) { $whereSql = "s.bayi_id = ?"; $params[] = $bayi_id; } 
else { $whereSql = "s.session_id = ? AND s.uye_id IS NULL AND s.bayi_id IS NULL"; $params[] = $session_id; }

$sql = "SELECT s.id as sepet_id, s.miktar, s.varyant_id, 
        u.id as urun_id, u.urun_adi, u.ana_resim, u.fiyat as u_fiyat, u.indirimli_fiyat as u_indirim, u.kdv_orani as u_kdv, u.kategori_id as u_kat,
        v.varyant_adi, v.resim_yolu as v_resim, v.fiyat as v_fiyat, v.indirimli_fiyat as v_indirim, v.kdv_orani as v_kdv,
        pb.kur as para_kur,
        b.birim_adi, b.artis_miktari
        FROM sepet s
        INNER JOIN urunler u ON s.urun_id = u.id
        LEFT JOIN urun_varyantlar v ON s.varyant_id = v.id
        LEFT JOIN para_birimleri pb ON (IFNULL(v.para_birimi_id, u.para_birimi_id) = pb.id)
        LEFT JOIN urun_birimler b ON (IFNULL(v.stok_birimi_id, u.stok_birimi_id) = b.id)
        WHERE $whereSql";

$stmt = $db->prepare($sql);
$stmt->execute($params);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($items as $item) {
    $isVariant = !empty($item['varyant_id']);
    
    // Ham fiyatlar (Kendi para biriminde)
    $rawPrice = $isVariant ? $item['v_fiyat'] : $item['u_fiyat'];
    $manualDiscount = $isVariant ? $item['v_indirim'] : $item['u_indirim'];
    $rawKdv = $isVariant ? ($item['v_kdv'] ?? $item['u_kdv']) : $item['u_kdv'];
    if(!$rawKdv) $rawKdv = 0;

    // Kampanya Motoru (Kendi para biriminde hesapla)
    $campaignPrice = calculateRuntimeDiscount($item['urun_id'], $item['u_kat'], $rawPrice, $campaigns);
    $activeDiscountedPrice = ($manualDiscount > 0 && $manualDiscount < $rawPrice) ? min($manualDiscount, $campaignPrice) : $campaignPrice;

    // Saf Fiyatları Bul (KDV Ayıklama)
    $originalBasePrice = $rawPrice;
    $finalBasePrice = $activeDiscountedPrice;
    if ($girisTipi == 1) { 
        $originalBasePrice /= (1 + ($rawKdv / 100));
        $finalBasePrice /= (1 + ($rawKdv / 100));
    }

    // --- KUR DÖNÜŞÜMÜ (TL/ANA PARA BİRİMİNE ÇEVİR) ---
    $itemRate = floatval($item['para_kur'] ?: 1);
    $originalBasePriceDef = ($originalBasePrice * $itemRate) / $defKur;
    $finalBasePriceDef = ($finalBasePrice * $itemRate) / $defKur;

    // İndirim Detayları
    $hasDiscount = round($finalBasePriceDef, 2) < round($originalBasePriceDef, 2);
    $savingsPerUnit = $originalBasePriceDef - $finalBasePriceDef;
    $discountPercent = $hasDiscount ? round(($savingsPerUnit / $originalBasePriceDef) * 100) : 0;

    // KDV ve Satır Toplamı (Dönüştürülmüş fiyat üzerinden)
    $qty = floatval($item['miktar']);
    $kdvAmountPerUnit = ($finalBasePriceDef * $rawKdv) / 100;
    $priceWithKdv = $finalBasePriceDef + $kdvAmountPerUnit;
    $rowTotal = $priceWithKdv * $qty;

    // Genel Toplamlar
    $subTotalNoKdv += ($finalBasePriceDef * $qty);
    $totalKdvAmount += ($kdvAmountPerUnit * $qty);
    $grandTotal += $rowTotal;
    $totalSavings += ($savingsPerUnit * $qty);

    $img = $isVariant && $item['v_resim'] ? $item['v_resim'] : $item['ana_resim'];
    $imgSrc = $img ? "uploads/urunler/".$img : "https://placehold.co/100x100?text=No+Image";
    
    $cartItems[] = [
        'sepet_id' => $item['sepet_id'],
        'urun_id' => $item['urun_id'],
        'name' => $item['urun_adi'],
        'variant' => $item['varyant_adi'],
        'image' => $imgSrc,
        'original_base_price' => $originalBasePriceDef,
        'base_price' => $finalBasePriceDef,
        'has_discount' => $hasDiscount,
        'discount_percent' => $discountPercent,
        'savings_unit' => $savingsPerUnit,
        'kdv_rate' => $rawKdv,
        'kdv_amount' => $kdvAmountPerUnit,
        'price_with_kdv' => $priceWithKdv,
        'row_total' => $rowTotal,
        'qty' => $qty,
        'step' => floatval($item['artis_miktari'] ?? 1) > 0 ? floatval($item['artis_miktari']) : 1,
        'unit' => $item['birim_adi'] ?: 'Adet'
    ];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Alışveriş Sepetim | E-Ticaret</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/sepet.css?v=<?php echo time(); ?>">
    <style>
        :root {
            --theme-color: <?php echo $tema['kart_buton_bg']; ?>;
            --theme-text: <?php echo $tema['kart_buton_text']; ?>;
            --price-color: <?php echo $tema['kart_fiyat_renk']; ?>;
        }
        .discount-badge-table { background: #fef2f2; color: #dc2626; padding: 2px 6px; border-radius: 4px; font-size: 0.75rem; font-weight: 700; border: 1px solid #fee2e2; display: inline-block; margin-top: 4px; }
        .savings-text { display: block; font-size: 0.75rem; color: #059669; margin-top: 2px; font-weight: 500; }
        .old-price-table { text-decoration: line-through; color: #9ca3af; font-size: 0.8rem; display: block; }
        .summary-savings { color: #059669 !important; font-weight: 600; }
    </style>
</head>
<body>

<header class="site-header">
    <div class="container">
        <div class="logo">LOGO</div>
        <div class="user-menu">
            <a href="urun-liste.php"><i class="fa-solid fa-arrow-left"></i> Alışverişe Devam Et</a>
        </div>
    </div>
</header>

<div class="container cart-container">
    <div class="cart-header">
        <h1><i class="fa-solid fa-cart-shopping"></i> Alışveriş Sepetim</h1>
        <p>Sepetinizde <strong><?php echo count($cartItems); ?></strong> çeşit ürün bulunuyor.</p>
    </div>

    <?php if(empty($cartItems)): ?>
        <div class="empty-cart">
            <i class="fa-solid fa-basket-shopping"></i>
            <h2>Sepetiniz şu an boş.</h2>
            <p>Alışverişe başlamak için harika ürünlerimizi inceleyebilirsiniz.</p>
            <a href="urun-liste.php" class="btn-continue">Ürünleri İncele</a>
        </div>
    <?php else: ?>
        <div class="cart-layout">
            <div class="cart-items-section">
                <div class="table-responsive">
                    <table class="cart-table">
                        <thead>
                            <tr>
                                <th>Ürün Bilgisi</th>
                                <th class="text-right">B.Fiyat (KDV Hariç)</th>
                                <th class="text-center">KDV Oranı</th>
                                <th class="text-right">KDV Tutarı</th>
                                <th class="text-right">KDV'li Fiyat</th>
                                <th class="text-center">Miktar</th>
                                <th class="text-right">Toplam</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($cartItems as $item): ?>
                            <tr>
                                <td>
                                    <div class="cart-product-info">
                                        <a href="urun-detay.php?id=<?php echo $item['urun_id']; ?>">
                                            <img src="<?php echo $item['image']; ?>" alt="<?php echo htmlspecialchars($item['name']); ?>" onerror="this.src='https://placehold.co/100x100?text=Resim+Yok'">
                                        </a>
                                        <div>
                                            <a href="urun-detay.php?id=<?php echo $item['urun_id']; ?>" class="prod-name"><?php echo $item['name']; ?></a>
                                            <?php if($item['variant']): ?>
                                                <div class="prod-variant">Seçenek: <?php echo $item['variant']; ?></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                
                                <td class="text-right">
                                    <?php if($item['has_discount']): ?>
                                        <span class="old-price-table"><?php echo number_format($item['original_base_price'], 2, ',', '.'); ?> <?php echo $defSembol; ?></span>
                                        <span class="font-semibold" style="color: #111827;"><?php echo number_format($item['base_price'], 2, ',', '.'); ?> <?php echo $defSembol; ?></span>
                                        <br>
                                        <span class="discount-badge-table">-%<?php echo $item['discount_percent']; ?> İndirim</span>
                                        <span class="savings-text">Birim Kar: <?php echo number_format($item['savings_unit'], 2, ',', '.'); ?> <?php echo $defSembol; ?></span>
                                    <?php else: ?>
                                        <span class="text-muted"><?php echo number_format($item['base_price'], 2, ',', '.'); ?> <?php echo $defSembol; ?></span>
                                    <?php endif; ?>
                                </td>

                                <td class="text-center">%<?php echo $item['kdv_rate']; ?></td>
                                <td class="text-right text-muted"><?php echo number_format($item['kdv_amount'], 2, ',', '.'); ?> <?php echo $defSembol; ?></td>
                                <td class="text-right font-semibold"><?php echo number_format($item['price_with_kdv'], 2, ',', '.'); ?> <?php echo $defSembol; ?></td>
                                
                                <td class="text-center">
                                    <form method="POST" action="" class="qty-form">
                                        <input type="hidden" name="action" value="update_qty">
                                        <input type="hidden" name="sepet_id" value="<?php echo $item['sepet_id']; ?>">
                                        <div class="qty-box">
                                            <button type="button" onclick="updateCartQty(this, -<?php echo $item['step']; ?>)">-</button>
                                            <input type="text" name="qty" value="<?php echo $item['qty'] + 0; ?>" readonly data-step="<?php echo $item['step']; ?>">
                                            <button type="button" onclick="updateCartQty(this, <?php echo $item['step']; ?>)">+</button>
                                        </div>
                                    </form>
                                    <div class="unit-text"><?php echo $item['unit']; ?></div>
                                </td>
                                
                                <td class="text-right row-total"><?php echo number_format($item['row_total'], 2, ',', '.'); ?> <?php echo $defSembol; ?></td>
                                
                                <td class="text-center">
                                    <form method="POST" action="">
                                        <input type="hidden" name="action" value="remove">
                                        <input type="hidden" name="sepet_id" value="<?php echo $item['sepet_id']; ?>">
                                        <button type="submit" class="btn-remove" title="Sepetten Çıkar" onclick="return confirm('Ürünü sepetten çıkarmak istediğinize emin misiniz?')">
                                            <i class="fa-solid fa-trash-can"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="cart-summary-section">
                <div class="summary-card">
                    <h3>Sipariş Özeti</h3>
                    
                    <div class="summary-row">
                        <span>Ara Toplam (KDV Hariç)</span>
                        <span><?php echo number_format($subTotalNoKdv, 2, ',', '.'); ?> <?php echo $defSembol; ?></span>
                    </div>

                    <?php if($totalSavings > 0): ?>
                        <div class="summary-row summary-savings">
                            <span>Kampanya İndirimi</span>
                            <span>-<?php echo number_format($totalSavings, 2, ',', '.'); ?> <?php echo $defSembol; ?></span>
                        </div>
                    <?php endif; ?>
                    
                    <div class="summary-row">
                        <span>KDV Tutarı Toplamı</span>
                        <span><?php echo number_format($totalKdvAmount, 2, ',', '.'); ?> <?php echo $defSembol; ?></span>
                    </div>
                    
                    <div class="summary-row grand-total">
                        <span>Genel Toplam</span>
                        <span><?php echo number_format($grandTotal, 2, ',', '.'); ?> <?php echo $defSembol; ?></span>
                    </div>
                    
                    <a href="kasa-gecis-aktar.php" class="btn-checkout">
                        Sepeti Onayla <i class="fa-solid fa-chevron-right"></i>
                    </a>
                    
                    <div class="secure-checkout">
                        <i class="fa-solid fa-shield-halved"></i> 256-Bit SSL Güvenli Alışveriş
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<script>
    function updateCartQty(btn, change) {
        let input = btn.parentElement.querySelector('input');
        let step = parseFloat(input.getAttribute('data-step'));
        let val = parseFloat(input.value);
        let newVal = val + change;
        newVal = Math.round(newVal * 1000) / 1000;
        
        if(newVal >= step) {
            input.value = newVal;
            btn.closest('form').submit();
        }
    }
</script>

</body>
</html>