<?php
require_once 'private/config.php';

// Oturum Bilgileri
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'guest';
$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;
$session_id = session_id();

// Formdan gelen verileri yakala (Kasa sayfasından post edildi)
if (!isset($_POST['complete_order'])) {
    header("Location: sepet.php");
    exit;
}

// 1. ADRES BİLGİLERİNİ AL
$ad_soyad = trim($_POST['ad_soyad'] ?? '');
$email    = trim($_POST['email'] ?? '');
$telefon  = trim($_POST['telefon'] ?? '');
$il       = trim($_POST['il'] ?? '');
$ilce     = trim($_POST['ilce'] ?? '');
$adres    = trim($_POST['adres'] ?? '');
$odeme_tipi = $_POST['odeme_tipi'] ?? 'havale';
$kargo_id   = intval($_POST['kargo_id'] ?? 0);
$coupon_code = trim($_POST['coupon_code'] ?? '');

// 2. SEPETİ VE FİYATLARI SUNUCU TARAFLI TEKRAR HESAPLA (GÜVENLİK İÇİN)
// Kankacım burada tarayıcıdan gelen fiyatı değil, DB'deki güncel fiyatı esas alıyoruz.
$siteAyarlari = $db->query("SELECT * FROM site_ayarlari WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$girisTipi = $siteAyarlari ? $siteAyarlari['fiyat_giris_tipi'] : 0; 

$defaultCurrency = $db->query("SELECT * FROM para_birimleri WHERE varsayilan=1 AND durum=1")->fetch(PDO::FETCH_ASSOC);
$defKur = floatval($defaultCurrency['kur'] ?? 1);

// Sepet sorgusu
$whereSql = ($user_role === 'member') ? "s.uye_id = ?" : (($user_role === 'dealer') ? "s.bayi_id = ?" : "s.session_id = ? AND s.uye_id IS NULL AND s.bayi_id IS NULL");
$targetId = ($user_role === 'guest') ? $session_id : $user_id;
$sql = "SELECT s.miktar, u.id as urun_id, u.urun_adi, u.fiyat as u_fiyat, u.indirimli_fiyat as u_indirim, u.kdv_orani as u_kdv, pb.kur as para_kur FROM sepet s INNER JOIN urunler u ON s.urun_id = u.id LEFT JOIN para_birimleri pb ON u.para_birimi_id = pb.id WHERE $whereSql";
$stmt = $db->prepare($sql);
$stmt->execute([$targetId]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($items)) { die("Sepetiniz boş."); }

$cartTotalWithKdv = 0;
$orderDetails = [];

foreach ($items as $item) {
    // Burada kampanya motoru fonksiyonunu tekrar çağırabilirsin (calculateRuntimeDiscount)
    // Şimdilik temel fiyat üzerinden gidelim:
    $price = ($item['u_indirim'] > 0) ? $item['u_indirim'] : $item['u_fiyat'];
    $kdv = $item['u_kdv'] ?: 0;
    
    // Saf fiyat ve KDV Dahil hesapla
    $basePrice = ($girisTipi == 1) ? ($price / (1 + ($kdv/100))) : $price;
    $priceWithKdv = $basePrice * (1 + ($kdv/100));
    
    // Kur Dönüşümü
    $itemRate = floatval($item['para_kur'] ?: 1);
    $priceConverted = ($priceWithKdv * $itemRate) / $defKur;
    
    $qty = floatval($item['miktar']);
    $lineTotal = $priceConverted * $qty;
    $cartTotalWithKdv += $lineTotal;

    $orderDetails[] = [
        'id' => $item['urun_id'],
        'ad' => $item['urun_adi'],
        'adet' => $qty,
        'fiyat' => $priceConverted
    ];
}

// 3. İNDİRİM VE KARGO EKLE
$couponDiscount = 0;
if (!empty($coupon_code)) {
    // Kupon geçerliliğini DB'den tekrar kontrol et kankacım!
    $stmtC = $db->prepare("SELECT * FROM hediye_cekleri WHERE cek_kodu = ? AND durum = 1");
    $stmtC->execute([$coupon_code]);
    $cp = $stmtC->fetch();
    if ($cp && $cartTotalWithKdv >= $cp['min_sepet_tutari']) {
        $couponDiscount = ($cp['indirim_turu'] == 'oran') ? ($cartTotalWithKdv * $cp['indirim_degeri'] / 100) : $cp['indirim_degeri'];
    }
}

$kargoPrice = 0;
$kRow = $db->query("SELECT * FROM kargo_firmalari WHERE id = $kargo_id")->fetch();
if ($kRow) {
    if ($kRow['ucretsiz_kargo_limiti'] > 0 && $cartTotalWithKdv >= $kRow['ucretsiz_kargo_limiti']) { $kargoPrice = 0; }
    else {
        $stmtB = $db->prepare("SELECT kargo_ucreti FROM kargo_baremleri WHERE kargo_id = ? AND alt_limit <= ? ORDER BY alt_limit DESC LIMIT 1");
        $stmtB->execute([$kargo_id, $cartTotalWithKdv]);
        $kargoPrice = floatval($stmtB->fetchColumn() ?: 50);
    }
}

$odemeAyari = $db->query("SELECT * FROM odeme_ayarlari WHERE id = 1")->fetch();
$payExtraFee = ($odeme_tipi == 'kapida') ? floatval($odemeAyari['kapida_odeme_bedeli']) : 0;

$finalTotal = ($cartTotalWithKdv - $couponDiscount) + $kargoPrice + $payExtraFee;

// 4. SİPARİŞİ DB'YE KAYDET (ÖDEME ÖNCESİ DURUM: 'ÖDEME BEKLİYOR')
$siparis_kodu = 'S-' . strtoupper(substr(uniqid(), 7));
$siparis_durumu = ($odeme_tipi == 'kk') ? 'Ödeme Bekliyor' : 'Bekliyor';

try {
    $db->beginTransaction();
    
    $sqlIns = "INSERT INTO siparisler (siparis_kodu, uye_id, bayi_id, ad_soyad, email, telefon, il, ilce, adres, toplam_tutar, kargo_ucreti, indirim_tutari, kapida_odeme_farki, odeme_tipi, durum, siparis_tarihi) 
               VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";
    $stmtIns = $db->prepare($sqlIns);
    $stmtIns->execute([
        $siparis_kodu, 
        ($user_role == 'member' ? $user_id : null), 
        ($user_role == 'dealer' ? $user_id : null),
        $ad_soyad, $email, $telefon, $il, $ilce, $adres, 
        $finalTotal, $kargoPrice, $couponDiscount, $payExtraFee, $odeme_tipi, $siparis_durumu
    ]);
    
    $last_siparis_id = $db->lastInsertId();
    
    // Ürünleri kaydet
    $sqlProd = "INSERT INTO siparis_urunler (siparis_id, urun_id, urun_adi, miktar, birim_fiyat) VALUES (?, ?, ?, ?, ?)";
    $stmtProd = $db->prepare($sqlProd);
    foreach ($orderDetails as $op) {
        $stmtProd->execute([$last_siparis_id, $op['id'], $op['ad'], $op['adet'], $op['fiyat']]);
    }

    $db->commit();
} catch (Exception $e) {
    $db->rollBack();
    die("Hata: Sipariş kaydedilemedi. " . $e->getMessage());
}

// 5. YÖNLENDİRME MANTIĞI
if ($odeme_tipi == 'kk') {
    // --- KANKACIM BURASI ONLINE ÖDEME BAŞLANGICI ---
    // Burada PayTR veya Iyzico'ya göre veri paketini (JSON) hazırlayıp onlardan Iframe URL alacağız.
    // Şimdilik simüle ediyoruz:
    $_SESSION['last_order_id'] = $last_siparis_id;
    header("Location: online-odeme.php"); 
    exit;
} else {
    // Havale veya Kapıda Ödeme ise sepeti temizle ve teşekkür sayfasına git
    $db->prepare("DELETE FROM sepet WHERE " . $whereSql)->execute([$targetId]);
    header("Location: tesekkurler.php?siparis=" . $siparis_kodu);
    exit;
}
?>