<?php
require_once 'private/config.php';

// Kullanıcı Rolü
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'guest';

// ID Kontrolü
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: urun-liste.php");
    exit;
}
$id = intval($_GET['id']);

// --- AYARLAR VE TEMA ---
$tema = $db->query("SELECT * FROM site_tema_ayarlari WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if(!$tema) { $tema = ['site_url'=>'','kart_buton_bg'=>'#f97316','kart_buton_text'=>'#fff','kart_fiyat_renk'=>'#f97316','filtre_buton_renk'=>'#f97316','sidebar_baslik_renk'=>'#111827']; }

$siteAyarlari = $db->query("SELECT * FROM site_ayarlari WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$girisTipi = $siteAyarlari ? $siteAyarlari['fiyat_giris_tipi'] : 0;
$gosterimTipi = $siteAyarlari ? $siteAyarlari['fiyat_gosterim_tipi'] : 0; // 0: +KDV, 1: KDV Dahil

// --- AKTİF KAMPANYALARI ÇEK (RUNTIME HESAPLAMA İÇİN) ---
$now = date('Y-m-d H:i:s');
$campaigns = $db->query("SELECT * FROM indirimler WHERE durum = 1 AND (baslangic_tarihi IS NULL OR baslangic_tarihi <= '$now') AND (bitis_tarihi IS NULL OR bitis_tarihi >= '$now') ORDER BY hedef_tipi DESC")->fetchAll(PDO::FETCH_ASSOC);

// --- DİNAMİK ÖZELLİKLER (GÜVEN ROZETLERİ) ---
$trustFeatures = $db->query("SELECT * FROM urun_detay_ozellikleri WHERE durum=1 ORDER BY sira ASC")->fetchAll(PDO::FETCH_ASSOC);

// --- PARA BİRİMLERİNİ ÇEK ---
$currencies = [];
$cStmt = $db->query("SELECT * FROM para_birimleri");
while($row = $cStmt->fetch(PDO::FETCH_ASSOC)) {
    $currencies[$row['id']] = $row;
}
$defCurrency = null;
foreach($currencies as $c) { if($c['varsayilan'] == 1) $defCurrency = $c; }
$defKur = $defCurrency ? $defCurrency['kur'] : 1.0000;
$defSembol = $defCurrency ? $defCurrency['sembol'] : '₺';

// --- BİRİM LİSTESİ ---
$unitList = [];
$uStmt = $db->query("SELECT id, birim_adi, artis_miktari FROM urun_birimler");
while($row = $uStmt->fetch(PDO::FETCH_ASSOC)) { 
    $unitList[$row['id']] = $row; 
}

// --- ÜRÜN BİLGİLERİ ---
$sql = "SELECT u.*, m.marka_adi, k.kategori_adi 
        FROM urunler u 
        LEFT JOIN markalar m ON u.marka_id = m.id 
        LEFT JOIN urunler_kategoriler k ON u.kategori_id = k.id 
        WHERE u.id = :id AND u.durum = 1";
$stmt = $db->prepare($sql);
$stmt->execute(['id' => $id]);
$product = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$product) {
    die("<div style='text-align:center; padding:50px; font-family:sans-serif;'>Ürün bulunamadı veya yayından kaldırılmış.<br><a href='urun-liste.php'>Listeye Dön</a></div>");
}

// --- GALERİ RESİMLERİ ---
$gallery = $db->query("SELECT * FROM urun_galeri WHERE urun_id = $id ORDER BY sira ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);

// --- VARYANTLAR ---
$variants = $db->query("SELECT * FROM urun_varyantlar WHERE urun_id = $id AND durum = 1 ORDER BY varsayilan DESC, sira ASC")->fetchAll(PDO::FETCH_ASSOC);

// --- FİYAT GİZLEME KONTROLÜ ---
$showPrice = true;
$lockMsg = "";
$loginBtnText = "Giriş Yap";

if($product['gorunurluk'] == 1 && $user_role == 'guest') { 
    $showPrice = false; 
    $lockMsg = "Bu ürün üyelere özeldir. Fiyatı görmek için üye olunuz."; 
    $loginBtnText = "Üye Girişi Yap";
} elseif($product['gorunurluk'] == 2 && $user_role != 'dealer') { 
    $showPrice = false; 
    $lockMsg = "Bu ürün sadece bayilere özeldir."; 
    $loginBtnText = "Bayi Girişi Yap";
}

// --- YARDIMCI FONKSİYONLAR (RUNTIME İNDİRİM MOTORU) ---
function calculateRuntimeDiscount($productId, $categoryId, $basePrice, $campaigns) {
    $bestPrice = $basePrice;
    foreach ($campaigns as $camp) {
        $isMatch = false;
        if ($camp['hedef_tipi'] == 'urun') {
            $ids = explode(',', $camp['hedef_id']);
            if (in_array($productId, $ids)) $isMatch = true;
        } elseif ($camp['hedef_tipi'] == 'kategori') {
            $ids = explode(',', $camp['hedef_id']);
            if (in_array($categoryId, $ids)) $isMatch = true;
        } elseif ($camp['hedef_tipi'] == 'genel') {
            $isMatch = true;
        }

        if ($isMatch) {
            $calcPrice = $basePrice;
            if ($camp['indirim_turu'] == 'oran') {
                $calcPrice = $basePrice - ($basePrice * $camp['indirim_degeri'] / 100);
            } else {
                $calcPrice = $basePrice - $camp['indirim_degeri'];
            }
            if ($calcPrice < $bestPrice) { $bestPrice = $calcPrice; }
            if ($camp['hedef_tipi'] != 'genel') break;
        }
    }
    return $bestPrice;
}

// --- HESAPLAMA FONKSİYONU (KDV & KUR) ---
function calculatePrice($price, $kdv, $girisTipi, $gosterimTipi, $itemRate, $targetRate) {
    if(!$price) return 0;
    
    // 1. KDV'siz Saf Fiyatı Bul
    $basePrice = 0;
    if ($girisTipi == 0) { 
        $basePrice = $price;
    } else { 
        $basePrice = $price / (1 + ($kdv / 100));
    }
    
    // 2. Gösterim Tipine Göre Son Fiyatı Hesapla
    $finalPrice = 0;
    if ($gosterimTipi == 0) { 
        $finalPrice = $basePrice;
    } else { 
        $finalPrice = $basePrice * (1 + ($kdv / 100));
    }
    
    // 3. Para Birimi Çeviri
    return ($finalPrice * $itemRate) / $targetRate;
}

// --- ANA ÜRÜN FİYAT HESAPLAMA ---
$rawPrice = $product['fiyat'];
$manualDiscount = $product['indirimli_fiyat'];
$campaignPrice = calculateRuntimeDiscount($product['id'], $product['kategori_id'], $rawPrice, $campaigns);
$activeDiscountedPrice = ($manualDiscount > 0 && $manualDiscount < $rawPrice) ? min($manualDiscount, $campaignPrice) : $campaignPrice;

$prodRate = isset($currencies[$product['para_birimi_id']]) ? $currencies[$product['para_birimi_id']]['kur'] : 1;
$pPrice = calculatePrice($rawPrice, $product['kdv_orani'], $girisTipi, $gosterimTipi, $prodRate, $defKur);
$pDiscount = calculatePrice($activeDiscountedPrice, $product['kdv_orani'], $girisTipi, $gosterimTipi, $prodRate, $defKur);

// --- YOUTUBE LİNK DÖNÜŞTÜRÜCÜ ---
function getYoutubeEmbedUrl($url) {
    $shortUrlRegex = '/youtu.be\/([a-zA-Z0-9_-]+)\??/i';
    $longUrlRegex = '/youtube.com\/((?:embed)|(?:watch))((?:\?v\=)|(?:\/))([a-zA-Z0-9_-]+)/i';
    if (preg_match($longUrlRegex, $url, $matches)) { $youtube_id = $matches[count($matches) - 1]; }
    if (preg_match($shortUrlRegex, $url, $matches)) { $youtube_id = $matches[1]; }
    return isset($youtube_id) ? 'https://www.youtube.com/embed/' . $youtube_id : $url;
}

// --- VARYANTLARI HAZIRLA ---
$jsVariants = [];
foreach($variants as $v) {
    $vRate = isset($currencies[$v['para_birimi_id']]) ? $currencies[$v['para_birimi_id']]['kur'] : 1;
    $vKdv = $v['kdv_orani'] ?: $product['kdv_orani'];
    if(!$vKdv) $vKdv = 18; 
    
    $vRawPrice = $v['fiyat'];
    $vManualDiscount = $v['indirimli_fiyat'];
    // Varyantlar için de kampanya kontrolü (Kategori veya Genel kampanyadan etkilenebilir)
    $vCampaignPrice = calculateRuntimeDiscount($product['id'], $product['kategori_id'], $vRawPrice, $campaigns);
    $vActiveDiscountedPrice = ($vManualDiscount > 0 && $vManualDiscount < $vRawPrice) ? min($vManualDiscount, $vCampaignPrice) : $vCampaignPrice;

    $vP = calculatePrice($vRawPrice, $vKdv, $girisTipi, $gosterimTipi, $vRate, $defKur);
    $vD = calculatePrice($vActiveDiscountedPrice, $vKdv, $girisTipi, $gosterimTipi, $vRate, $defKur);
    
    $vUnitId = $v['stok_birimi_id'] ?: $product['stok_birimi_id'];
    $vUnitData = isset($unitList[$vUnitId]) ? $unitList[$vUnitId] : ['birim_adi' => 'Adet', 'artis_miktari' => 1];
    $vStep = floatval($vUnitData['artis_miktari']) > 0 ? floatval($vUnitData['artis_miktari']) : 1;

    $jsVariants[$v['id']] = [
        'price' => number_format($vP, 2, ',', '.'),
        'discount' => ($vD > 0 && round($vD, 2) < round($vP, 2)) ? number_format($vD, 2, ',', '.') : null,
        'stock' => $v['stok_miktari'],
        'unit' => $vUnitData['birim_adi'],
        'step' => $vStep,
        'raw_price' => $vP, 
        'raw_discount' => $vD
    ];
}

$isVariantProduct = ($product['varyant_durumu'] == 1 && count($variants) > 0);
$defaultVariantId = 0;
if($isVariantProduct) {
    $defaultVariantId = $variants[0]['id'];
}

$mainUnitId = $product['stok_birimi_id'];
$mainUnitData = isset($unitList[$mainUnitId]) ? $unitList[$mainUnitId] : ['birim_adi' => 'Adet', 'artis_miktari' => 1];
$mainStep = floatval($mainUnitData['artis_miktari']) > 0 ? floatval($mainUnitData['artis_miktari']) : 1;

// PHP tarafında +KDV etiketi hazırlığı
$kdvLabel = ($gosterimTipi == 0) ? '+KDV' : '';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $product['urun_adi']; ?> | Detay</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <link rel="stylesheet" href="assets/urun-detay.css?v=<?php echo time(); ?>">
    
    <style>
        :root {
            --theme-color: <?php echo $tema['kart_buton_bg']; ?>;
            --theme-text: <?php echo $tema['kart_buton_text']; ?>;
            --price-color: <?php echo $tema['kart_fiyat_renk']; ?>;
        }
        .lightbox { display: none; position: fixed; z-index: 1000; padding-top: 50px; left: 0; top: 0; width: 100%; height: 100%; overflow: auto; background-color: rgba(0, 0, 0, 0.95); }
        .lightbox-content { margin: auto; display: block; width: auto; height: auto; max-width: 90%; max-height: 85vh; object-fit: contain; animation: zoom 0.4s; }
        .close { position: absolute; top: 20px; right: 35px; color: #fff; font-size: 50px; font-weight: bold; transition: 0.3s; cursor: pointer; }
        .close:hover { color: #ccc; }
        @keyframes zoom { from {transform:scale(0.8); opacity:0;} to {transform:scale(1); opacity:1;} }
        
        .kdv-tag { font-size: 0.8rem; font-weight: 400; color: #9ca3af; margin-left: 5px; }
    </style>
</head>
<body>

<header class="site-header">
    <div class="container">
        <div class="logo">LOGO</div>
        <div class="user-menu">
            <a href="urun-liste.php"><i class="fa-solid fa-arrow-left"></i> Listeye Dön</a>
        </div>
    </div>
</header>

<div class="breadcrumb-area">
    <div class="container">
        <ul>
            <li><a href="index.php">Anasayfa</a></li>
            <li><i class="fa-solid fa-chevron-right"></i></li>
            <li><a href="urun-liste.php?c=<?php echo $product['kategori_id']; ?>"><?php echo $product['kategori_adi'] ?: 'Kategorisiz'; ?></a></li>
            <li><i class="fa-solid fa-chevron-right"></i></li>
            <li><span><?php echo $product['urun_adi']; ?></span></li>
        </ul>
    </div>
</div>

<div class="container main-detail-container">
    
    <!-- SOL: GALERİ -->
    <div class="detail-left">
        <div class="main-image-box" id="imgBox">
            <img id="mainImage" src="uploads/urunler/<?php echo $product['ana_resim']; ?>" 
                 alt="<?php echo $product['urun_adi']; ?>" 
                 onerror="this.src='https://placehold.co/600x600?text=Resim+Yok'">
            <div class="zoom-icon" onclick="openLightbox()" title="Tam Ekran"><i class="fa-solid fa-expand"></i></div>
            <?php if($product['durum'] == 0): ?><div class="status-overlay">PASİF</div><?php endif; ?>
        </div>

        <div class="thumb-list">
            <div class="thumb-item active" onclick="changeImage('uploads/urunler/<?php echo $product['ana_resim']; ?>', this)">
                <img src="uploads/urunler/<?php echo $product['ana_resim']; ?>" onerror="this.src='https://placehold.co/100x100'">
            </div>
            <?php foreach($gallery as $img): ?>
                <div class="thumb-item" onclick="changeImage('uploads/urunler/<?php echo $img['resim_yolu']; ?>', this)">
                    <img src="uploads/urunler/<?php echo $img['resim_yolu']; ?>">
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- SAĞ: BİLGİLER -->
    <div class="detail-right">
        
        <div class="product-brand"><?php echo $product['marka_adi']; ?></div>
        <h1 class="product-title"><?php echo $product['urun_adi']; ?></h1>
        
        <div class="product-meta">
            <div class="meta-item"><strong>Stok Kodu:</strong> <?php echo $product['urun_kodu'] ?: '-'; ?></div>
            <div class="meta-item"><strong>Barkod:</strong> <?php echo $product['barkod'] ?: '-'; ?></div>
            <?php if($product['stok_miktari'] > 0 || $isVariantProduct): ?>
                <span class="stock-status in-stock"><i class="fa-solid fa-circle-check"></i> Stokta Var</span>
            <?php else: ?>
                <span class="stock-status out-stock"><i class="fa-solid fa-circle-xmark"></i> Stok Tükendi</span>
            <?php endif; ?>
        </div>

        <!-- FİYAT ALANI (DİNAMİK) -->
        <div class="price-wrapper" id="priceContainer">
            <div class="price-loader">Fiyatlar hesaplanıyor...</div>
        </div>

        <div class="short-desc"><?php echo nl2br($product['kisa_aciklama']); ?></div>

        <!-- VARYANT SEÇİMİ -->
        <?php if($isVariantProduct): ?>
            <div class="variant-section">
                <h4>Seçenekler: <span id="selectedVariantName">Varsayılan</span></h4>
                <div class="variant-list">
                    <?php foreach($variants as $v): ?>
                        <div class="variant-option <?php echo $v['id'] == $defaultVariantId ? 'selected' : ''; ?> <?php echo $v['stok_miktari'] <= 0 ? 'out-of-stock' : ''; ?>" 
                             onclick="selectVariant(<?php echo $v['id']; ?>, '<?php echo addslashes($v['varyant_adi']); ?>', this)">
                            <?php if($v['resim_yolu']): ?>
                                <img src="uploads/urunler/<?php echo $v['resim_yolu']; ?>" class="v-thumb">
                            <?php endif; ?>
                            <span class="v-name"><?php echo $v['varyant_adi']; ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>
                <input type="hidden" id="selectedVariantId" value="<?php echo $defaultVariantId; ?>">
            </div>
        <?php endif; ?>

        <!-- AKSİYON ALANI -->
        <div class="action-bar-wrapper" id="actionBar">
             <!-- JS ile yönetilecek -->
        </div>

        <div class="feature-grid">
            <?php foreach($trustFeatures as $feat): ?>
                <div class="feature-item">
                    <i class="fa-solid <?php echo $feat['ikon']; ?>" style="color:<?php echo $feat['renk']; ?>"></i>
                    <div><strong><?php echo $feat['baslik']; ?></strong><span><?php echo $feat['aciklama']; ?></span></div>
                </div>
            <?php endforeach; ?>
        </div>

    </div>
</div>

<div class="container tabs-container">
    <div class="tabs-head">
        <button class="tab-btn active" onclick="openTab(event, 'desc')">Ürün Açıklaması</button>
        <?php if($product['video_link']): ?>
            <button class="tab-btn" onclick="openTab(event, 'video')">Ürün Videosu</button>
        <?php endif; ?>
    </div>
    <div class="tabs-body">
        <div id="desc" class="tab-content active">
            <div class="editor-content"><?php echo $product['aciklama'] ? $product['aciklama'] : 'Bu ürün için detaylı açıklama girilmemiş.'; ?></div>
        </div>
        <?php if($product['video_link']): ?>
            <div id="video" class="tab-content">
                <div class="video-wrapper">
                    <iframe src="<?php echo getYoutubeEmbedUrl($product['video_link']); ?>" frameborder="0" allowfullscreen></iframe>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<div id="myLightbox" class="lightbox">
  <span class="close" onclick="closeLightbox()">&times;</span>
  <img class="lightbox-content" id="img01">
</div>

<footer class="site-footer">
    <div class="container">
        &copy; <?php echo date("Y"); ?> Tüm Hakları Saklıdır.
    </div>
</footer>

<!-- JS VERİLERİ VE MANTIK -->
<script>
    const isVariantProduct = <?php echo $isVariantProduct ? 'true' : 'false'; ?>;
    const variants = <?php echo json_encode($jsVariants); ?>;
    const showPrice = <?php echo $showPrice ? 'true' : 'false'; ?>;
    const lockMsg = "<?php echo $lockMsg; ?>";
    const loginBtnText = "<?php echo $loginBtnText; ?>";
    const kdvLabel = "<?php echo $kdvLabel; ?>"; 
    
    const baseProduct = {
        price: '<?php echo number_format($pPrice, 2, ',', '.'); ?>',
        discount: '<?php echo ($pDiscount > 0 && round($pDiscount, 2) < round($pPrice, 2)) ? number_format($pDiscount, 2, ',', '.') : null; ?>',
        stock: <?php echo $product['stok_miktari']; ?>,
        unit: '<?php echo $mainUnitData['birim_adi']; ?>',
        step: <?php echo $mainStep; ?>,
        raw_price: <?php echo $pPrice; ?>,
        raw_discount: <?php echo $pDiscount; ?>
    };

    const priceContainer = document.getElementById('priceContainer');
    const actionBar = document.getElementById('actionBar');
    const selectedVariantIdInput = document.getElementById('selectedVariantId');
    const selectedVariantNameSpan = document.getElementById('selectedVariantName');

    document.addEventListener("DOMContentLoaded", function() {
        if(isVariantProduct) {
            const defId = selectedVariantIdInput.value;
            if(variants[defId]) updateProductDisplay(variants[defId]);
            else { const first = document.querySelector('.variant-option.selected'); if(first) first.click(); }
        } else {
            updateProductDisplay(baseProduct);
        }
    });

    function updateProductDisplay(data) {
        let priceHtml = '';
        if (showPrice) {
            if(data.discount) {
                let p1 = parseFloat(data.raw_price);
                let p2 = parseFloat(data.raw_discount);
                let percent = Math.round(((p1 - p2) / p1) * 100);

                priceHtml += `
                <div class="price-row">
                    <div class="discount-box"><span class="percent">%${percent}</span><span class="label">İNDİRİM</span></div>
                    <div class="price-values">
                        <div class="current">${data.discount} ${'<?php echo $defSembol; ?>'} <span class="kdv-tag">${kdvLabel}</span></div>
                        <div class="old">${data.price} ${'<?php echo $defSembol; ?>'} <span class="kdv-tag">${kdvLabel}</span></div>
                    </div>
                </div>`;
            } else {
                priceHtml += `
                <div class="price-row">
                    <div class="price-values">
                        <div class="current">${data.price} ${'<?php echo $defSembol; ?>'} <span class="kdv-tag">${kdvLabel}</span></div>
                    </div>
                </div>`;
            }
        } else {
            priceHtml = `<div class="login-alert-box"><i class="fa-solid fa-lock"></i><div>${lockMsg}</div></div>`;
        }
        if(priceContainer) priceContainer.innerHTML = priceHtml;

        let actionHtml = '';
        if (showPrice) {
            actionHtml += `<div class="qty-control-label">Adet:</div><div class="action-bar"><div class="qty-box"><button type="button" onclick="updateQty(-1)">-</button><input type="text" id="qtyInput" value="${data.step}" data-step="${data.step}" readonly><button type="button" onclick="updateQty(1)">+</button></div>`;
            if(data.stock <= 0) {
                actionHtml += `<button class="add-to-cart-btn disabled" disabled>TÜKENDİ</button><div id="stockAlert" class="stock-alert">Stokta yok.</div>`;
            } else {
                actionHtml += `<button class="add-to-cart-btn" onclick="addToCart()"><i class="fa-solid fa-cart-shopping"></i> Sepete Ekle</button><button class="buy-now-btn" onclick="buyNow()">Hemen Al</button><button class="fav-btn-box" onclick="toggleFav(this)"><i class="fa-regular fa-heart"></i></button><div id="stockAlert" class="stock-alert"></div>`;
            }
            actionHtml += `</div>`;
        } else {
            actionHtml = `<div class="action-bar"><a href="login.php" class="login-required-btn"><i class="fa-solid fa-user-lock" style="margin-right:10px;"></i> ${loginBtnText}</a></div>`;
        }
        if(actionBar) actionBar.innerHTML = actionHtml;
    }

    function selectVariant(id, name, element) {
        document.querySelectorAll('.variant-option').forEach(el => el.classList.remove('selected'));
        element.classList.add('selected');
        if(selectedVariantIdInput) selectedVariantIdInput.value = id;
        if(selectedVariantNameSpan) selectedVariantNameSpan.innerText = name;
        if(variants[id]) updateProductDisplay(variants[id]);
    }

    function changeImage(src, thumb) {
        document.getElementById('mainImage').src = src;
        document.querySelectorAll('.thumb-item').forEach(el => el.classList.remove('active'));
        thumb.classList.add('active');
    }

    function updateQty(direction) {
        let input = document.getElementById('qtyInput');
        if(!input) return;
        let step = parseFloat(input.getAttribute('data-step'));
        let currentVal = parseFloat(input.value);
        let newVal = currentVal + (direction * step);
        newVal = Math.round(newVal * 1000) / 1000;
        if(newVal < step) newVal = step;
        input.value = newVal;
    }

    function openTab(evt, tabName) {
        var i, tabcontent, tabbtns;
        tabcontent = document.getElementsByClassName("tab-content");
        for (i = 0; i < tabcontent.length; i++) { tabcontent[i].style.display = "none"; tabcontent[i].classList.remove("active"); }
        tabbtns = document.getElementsByClassName("tab-btn");
        for (i = 0; i < tabbtns.length; i++) { tabbtns[i].className = tabbtns[i].className.replace(" active", ""); }
        document.getElementById(tabName).style.display = "block";
        document.getElementById(tabName).classList.add("active");
        evt.currentTarget.className += " active";
    }

    function toggleFav(btn) {
        let icon = btn.querySelector('i');
        if(icon.classList.contains('fa-regular')) { icon.classList.remove('fa-regular'); icon.classList.add('fa-solid'); btn.classList.add('active'); }
        else { icon.classList.remove('fa-solid'); icon.classList.add('fa-regular'); btn.classList.remove('active'); }
    }
    
    function addToCart() { alert("Sepete Eklendi!"); }
    function buyNow() { alert("Ödeme sayfasına yönlendiriliyor..."); }

    function openLightbox() {
        var modal = document.getElementById("myLightbox");
        var img = document.getElementById("mainImage");
        var modalImg = document.getElementById("img01");
        modal.style.display = "block";
        modalImg.src = img.src;
    }
    function closeLightbox() { document.getElementById("myLightbox").style.display = "none"; }

    const imgBox = document.getElementById('imgBox');
    const img = document.getElementById('mainImage');
    imgBox.addEventListener('mousemove', function(e) {
        const x = e.clientX - imgBox.offsetLeft;
        const y = e.clientY - imgBox.offsetTop;
        const xPercent = x / imgBox.offsetWidth * 100;
        const yPercent = y / imgBox.offsetHeight * 100;
        img.style.transformOrigin = `${xPercent}% ${yPercent}%`;
        img.style.transform = "scale(1.6)"; 
    });
    imgBox.addEventListener('mouseleave', function() {
        img.style.transformOrigin = "center center";
        img.style.transform = "scale(1)";
    });
</script>

</body>
</html>