<?php
require_once 'private/config.php';

// --- KULLANICI ROLÜ ---
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'guest';
$session_id = session_id();

// --- SEPETE EKLEME İŞLEMİ ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_to_cart'])) {
    $eklenen_urun_id = intval($_POST['urun_id']);
    $eklenen_miktar = floatval($_POST['miktar']);
    
    $uye_id = ($user_role === 'member') ? $_SESSION['user_id'] : null;
    $bayi_id = ($user_role === 'dealer') ? $_SESSION['user_id'] : null;

    if ($eklenen_urun_id > 0 && $eklenen_miktar > 0) {
        
        $whereSql = "";
        $params = [];
        if ($uye_id) {
            $whereSql = "uye_id = ?";
            $params[] = $uye_id;
        } elseif ($bayi_id) {
            $whereSql = "bayi_id = ?";
            $params[] = $bayi_id;
        } else {
            $whereSql = "session_id = ? AND uye_id IS NULL AND bayi_id IS NULL";
            $params[] = $session_id;
        }
        
        $checkSql = "SELECT id, miktar FROM sepet WHERE urun_id = ? AND varyant_id IS NULL AND " . $whereSql;
        $checkParams = array_merge([$eklenen_urun_id], $params);
        
        $stmtCheck = $db->prepare($checkSql);
        $stmtCheck->execute($checkParams);
        $varMi = $stmtCheck->fetch(PDO::FETCH_ASSOC);
        
        if ($varMi) {
            $yeniMiktar = $varMi['miktar'] + $eklenen_miktar;
            $db->prepare("UPDATE sepet SET miktar = ? WHERE id = ?")->execute([$yeniMiktar, $varMi['id']]);
        } else {
            $insSql = "INSERT INTO sepet (session_id, uye_id, bayi_id, urun_id, miktar) VALUES (?, ?, ?, ?, ?)";
            $db->prepare($insSql)->execute([$session_id, $uye_id, $bayi_id, $eklenen_urun_id, $eklenen_miktar]);
        }
        
        // --- YÖNLENDİRME (BAŞARI PARAMETRESİ İLE) ---
        $params_arr = $_GET;
        $params_arr['add'] = 'success'; // JS'nin yakalaması için parametre ekliyoruz
        $redirect_url = $_SERVER['PHP_SELF'] . '?' . http_build_query($params_arr);
        
        header("Location: " . $redirect_url);
        exit;
    }
}

// --- 1. AYARLAR VE TEMA ---
$tema = $db->query("SELECT * FROM site_tema_ayarlari WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if(!$tema) { $tema = ['site_url'=>'','kart_buton_bg'=>'#f97316','kart_buton_text'=>'#fff','kart_fiyat_renk'=>'#f97316','filtre_buton_renk'=>'#f97316','sidebar_baslik_renk'=>'#111827','kart_ikon'=>'fa-cart-shopping']; }

// --- 2. SİTE FİYAT AYARLARI ---
$siteAyarlari = $db->query("SELECT * FROM site_ayarlari WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$girisTipi = $siteAyarlari ? $siteAyarlari['fiyat_giris_tipi'] : 0; 
$gosterimTipi = $siteAyarlari ? $siteAyarlari['fiyat_gosterim_tipi'] : 0; 

// --- 3. VARSAYILAN PARA BİRİMİNİ ÇEK (KRİTİK DÜZENLEME) ---
$defaultCurrency = $db->query("SELECT * FROM para_birimleri WHERE varsayilan=1 AND durum=1")->fetch(PDO::FETCH_ASSOC);
if(!$defaultCurrency) {
    $defaultCurrency = ['kur' => 1.0000, 'sembol' => '₺', 'kod' => 'TL'];
}
$defKur = floatval($defaultCurrency['kur']);
$defSembol = $defaultCurrency['sembol'];

// --- 4. AKTİF KAMPANYALARI ÇEK (RUNTIME HESAPLAMA İÇİN) ---
$now = date('Y-m-d H:i:s');
$campaigns = $db->query("SELECT * FROM indirimler WHERE durum = 1 AND (baslangic_tarihi IS NULL OR baslangic_tarihi <= '$now') AND (bitis_tarihi IS NULL OR bitis_tarihi >= '$now') ORDER BY hedef_tipi DESC")->fetchAll(PDO::FETCH_ASSOC);

// --- 5. FİLTRE PARAMETRELERİ ---
$cat_id = isset($_GET['c']) ? intval($_GET['c']) : 0;
$brand_ids = isset($_GET['brands']) ? $_GET['brands'] : [];
$min_price = isset($_GET['min_p']) ? floatval($_GET['min_p']) : 0;
$max_price = isset($_GET['max_p']) ? floatval($_GET['max_p']) : 0;
$vis_filter = isset($_GET['vis']) ? $_GET['vis'] : [];
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'newest';

// --- 6. BİRİM LİSTESİ ---
$unitList = [];
$uStmt = $db->query("SELECT id, birim_adi, artis_miktari FROM urun_birimler");
while($row = $uStmt->fetch()) {
    $unitList[$row['id']] = $row; 
}

// --- 7. ÜRÜN SORGUSU (KUR BİLGİSİ İÇİN JOIN EKLENDİ) ---
$sql = "SELECT u.*, 
        m.marka_adi, 
        pb.kur as item_kur, pb.sembol as item_sembol,
        (SELECT resim_yolu FROM urun_varyantlar WHERE urun_id = u.id ORDER BY varsayilan DESC, id ASC LIMIT 1) as v_resim,
        (SELECT fiyat FROM urun_varyantlar WHERE urun_id = u.id ORDER BY varsayilan DESC, id ASC LIMIT 1) as v_fiyat,
        (SELECT indirimli_fiyat FROM urun_varyantlar WHERE urun_id = u.id ORDER BY varsayilan DESC, id ASC LIMIT 1) as v_indirim,
        (SELECT stok_miktari FROM urun_varyantlar WHERE urun_id = u.id ORDER BY varsayilan DESC, id ASC LIMIT 1) as v_stok,
        (SELECT stok_birimi_id FROM urun_varyantlar WHERE urun_id = u.id ORDER BY varsayilan DESC, id ASC LIMIT 1) as v_birim_id,
        (SELECT kdv_orani FROM urun_varyantlar WHERE urun_id = u.id ORDER BY varsayilan DESC, id ASC LIMIT 1) as v_kdv
        FROM urunler u
        LEFT JOIN markalar m ON u.marka_id = m.id
        LEFT JOIN para_birimleri pb ON u.para_birimi_id = pb.id
        LEFT JOIN urun_kategori_iliski uki ON u.id = uki.urun_id
        WHERE u.durum = 1";

$params = [];

if ($cat_id > 0) {
    $sql .= " AND (u.kategori_id = :cid OR uki.kategori_id = :cid)";
    $params['cid'] = $cat_id;
}

if (!empty($brand_ids)) {
    $clean_brands = array_map('intval', $brand_ids);
    $b_ids = implode(',', $clean_brands);
    $sql .= " AND u.marka_id IN ($b_ids)";
}

if (!empty($vis_filter)) {
    $vis_conditions = [];
    if (in_array('0', $vis_filter)) $vis_conditions[] = "u.gorunurluk = 0";
    if (in_array('1', $vis_filter)) $vis_conditions[] = "u.gorunurluk = 1";
    if (in_array('2', $vis_filter)) $vis_conditions[] = "u.gorunurluk = 2";
    if (!empty($vis_conditions)) {
        $sql .= " AND (" . implode(' OR ', $vis_conditions) . ")";
    }
}

$sql .= " GROUP BY u.id";

switch ($sort) {
    case 'price_asc': $sql .= " ORDER BY u.fiyat ASC"; break;
    case 'price_desc': $sql .= " ORDER BY u.fiyat DESC"; break;
    case 'name_asc': $sql .= " ORDER BY u.urun_adi ASC"; break;
    default: $sql .= " ORDER BY u.id DESC";
}

$stmt = $db->prepare($sql);
$stmt->execute($params);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);

// --- 8. YARDIMCI FONKSİYONLAR ---
function calculateRuntimeDiscount($productId, $categoryId, $basePrice, $campaigns) {
    $bestPrice = $basePrice;
    foreach ($campaigns as $camp) {
        $isMatch = false;
        if ($camp['hedef_tipi'] == 'urun') {
            $ids = explode(',', $camp['hedef_id']);
            if (in_array($productId, $ids)) $isMatch = true;
        } elseif ($camp['hedef_tipi'] == 'kategori') {
            $ids = explode(',', $camp['hedef_id']);
            if (in_array($categoryId, $ids)) $isMatch = true;
        } elseif ($camp['hedef_tipi'] == 'genel') {
            $isMatch = true;
        }

        if ($isMatch) {
            $calcPrice = $basePrice;
            if ($camp['indirim_turu'] == 'oran') {
                $calcPrice = $basePrice - ($basePrice * $camp['indirim_degeri'] / 100);
            } else {
                $calcPrice = $basePrice - $camp['indirim_degeri'];
            }
            if ($calcPrice < $bestPrice) { $bestPrice = $calcPrice; }
            if ($camp['hedef_tipi'] != 'genel') break;
        }
    }
    return $bestPrice;
}

// Fiyat ve Para Birimi Dönüşüm Fonksiyonu
function getFinalConvertedPrices($price, $discount, $kdv, $giris, $gosterim, $itemRate, $defRate) {
    // 1. Saf Fiyatları Bul (KDV Hariç)
    $baseP = ($giris == 1) ? ($price / (1 + ($kdv/100))) : $price;
    $baseD = ($discount > 0) ? (($giris == 1) ? ($discount / (1 + ($kdv/100))) : $discount) : 0;
    
    // 2. Gösterim Tipine Göre KDV Ekle/Çıkar
    $finalP = ($gosterim == 1) ? ($baseP * (1 + ($kdv/100))) : $baseP;
    $finalD = ($baseD > 0) ? (($gosterim == 1) ? ($baseD * (1 + ($kdv/100))) : $baseD) : 0;
    
    // 3. Kur Dönüşümü: (Birim Fiyat * Kendi Kuru) / Varsayılan Kur
    return [
        'price' => ($finalP * $itemRate) / $defRate,
        'discount' => ($finalD * $itemRate) / $defRate
    ];
}

// Kategoriler
$categoriesList = $db->query("SELECT * FROM urunler_kategoriler WHERE durum=1 ORDER BY sira ASC")->fetchAll();
$brands = $db->query("SELECT * FROM markalar WHERE durum=1 ORDER BY sira ASC")->fetchAll();
function buildCategoryTree($categories, $parentId = 0) {
    $branch = array();
    foreach ($categories as $cat) {
        if ($cat['ust_id'] == $parentId) {
            $children = buildCategoryTree($categories, $cat['id']);
            if ($children) { $cat['children'] = $children; }
            $branch[] = $cat;
        }
    }
    return $branch;
}
$categoryTree = buildCategoryTree($categoriesList);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ürünler | E-Ticaret</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <link rel="stylesheet" href="assets/urun-liste.css?v=<?php echo time(); ?>">
    
    <style>
        :root {
            /* Tema Ayarları */
            --theme-color: <?php echo $tema['kart_buton_bg']; ?>; 
            --theme-text: <?php echo $tema['kart_buton_text']; ?>;
            --price-color: <?php echo $tema['kart_fiyat_renk']; ?>;
            --filter-header: <?php echo $tema['filtre_buton_renk']; ?>;
        }

        /* --- SEPET TOAST (POPUP) STİLLERİ --- */
        .cart-toast {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background: #fff;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
            border-radius: 12px;
            padding: 20px;
            z-index: 9999;
            display: flex;
            flex-direction: column;
            gap: 15px;
            width: 320px;
            border-left: 5px solid #10b981;
            transform: translateX(120%);
            transition: transform 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        .cart-toast.show { transform: translateX(0); }

        .toast-content { display: flex; align-items: center; gap: 12px; }
        .toast-content i { font-size: 1.8rem; color: #10b981; }
        .toast-msg { font-weight: 600; color: #1f2937; font-size: 0.95rem; }

        .toast-actions { display: flex; gap: 10px; }
        .btn-toast-go {
            flex: 1; background: var(--theme-color); color: var(--theme-text);
            padding: 10px; border-radius: 6px; text-align: center; font-size: 0.85rem; font-weight: 700;
            text-decoration: none; transition: opacity 0.2s;
        }
        .btn-toast-continue {
            flex: 1; background: #f3f4f6; color: #4b5563;
            padding: 10px; border-radius: 6px; text-align: center; font-size: 0.85rem; font-weight: 600;
            cursor: pointer; border: none; transition: background 0.2s;
        }
        .btn-toast-go:hover { opacity: 0.9; }
        .btn-toast-continue:hover { background: #e5e7eb; }

        @media (max-width: 600px) {
            .cart-toast { bottom: 10px; right: 10px; left: 10px; width: auto; }
        }
    </style>
</head>
<body>

<header class="site-header">
    <div class="container">
        <div class="logo">LOGO</div>
        <div class="user-menu">
            <a href="sepet.php" style="margin-right:20px; font-weight:600; color:var(--theme-color);"><i class="fa-solid fa-cart-shopping"></i> Sepetim</a>
            <?php if($user_role == 'guest'): ?>
                <a href="login.php">Giriş Yap</a>
            <?php else: ?>
                <span>Hoşgeldin, <?php echo $user_role == 'dealer' ? 'Bayi' : 'Üye'; ?></span>
                <a href="<?php echo $user_role == 'dealer' ? 'bayi-cikis.php' : 'uye-cikis.php'; ?>" style="margin-left:15px; font-size:0.85rem; color:#ef4444;"><i class="fa-solid fa-power-off"></i> Çıkış</a>
            <?php endif; ?>
        </div>
    </div>
</header>

<div class="breadcrumb-area">
    <div class="container">
        <ul>
            <li><a href="index.php"><i class="fa-solid fa-house"></i> Anasayfa</a></li>
            <li><i class="fa-solid fa-chevron-right"></i></li>
            <li><a href="urun-liste.php">Ürünler</a></li>
            <?php if($cat_id > 0): 
                $catInfo = $db->query("SELECT kategori_adi FROM urunler_kategoriler WHERE id=$cat_id")->fetch();
            ?>
                <li><i class="fa-solid fa-chevron-right"></i></li>
                <li><span><?php echo $catInfo['kategori_adi']; ?></span></li>
            <?php endif; ?>
        </ul>
    </div>
</div>

<div class="main-container container">
    
    <aside class="sidebar">
        <form action="" method="GET" id="filterForm">
            <?php if($cat_id) echo '<input type="hidden" name="c" value="'.$cat_id.'">'; ?>
            
            <div class="sidebar-header">
                <h3>FİLTRELEME</h3>
                <a href="urun-liste.php" class="reset-link"><i class="fa-solid fa-rotate-right"></i> Sıfırla</a>
            </div>

            <div class="filter-box">
                <h4 class="box-title">Kategoriler</h4>
                <div class="cat-wrapper">
                    <ul class="cat-list">
                        <li class="cat-item <?php echo $cat_id == 0 ? 'current' : ''; ?>">
                            <a href="urun-liste.php" class="cat-link">Tüm Kategoriler</a>
                        </li>
                        <?php 
                        function isChildActive($node, $activeId) {
                            if ($node['id'] == $activeId) return true;
                            if (isset($node['children'])) {
                                foreach($node['children'] as $child) {
                                    if (isChildActive($child, $activeId)) return true;
                                }
                            }
                            return false;
                        }

                        function renderCatTree($tree, $activeId) {
                            foreach($tree as $node) {
                                $isActive = ($activeId == $node['id']) ? 'active' : '';
                                $hasChild = isset($node['children']) && !empty($node['children']);
                                $isOpen = isChildActive($node, $activeId) ? 'show' : ''; 
                                $rotate = $isOpen ? 'rotate' : '';

                                echo '<li class="cat-item">';
                                echo '<div class="cat-header">';
                                echo '<a href="?c='.$node['id'].'" class="cat-link '.$isActive.'">'.$node['kategori_adi'].'</a>';
                                
                                if ($hasChild) {
                                    echo '<span class="cat-toggle '.$rotate.'" onclick="toggleSub(this)"><i class="fa-solid fa-chevron-down"></i></span>';
                                }
                                echo '</div>';

                                if($hasChild) {
                                    echo '<ul class="cat-sub '.$isOpen.'">';
                                    renderCatTree($node['children'], $activeId);
                                    echo '</ul>';
                                }
                                echo '</li>';
                            }
                        }
                        renderCatTree($categoryTree, $cat_id);
                        ?>
                    </ul>
                </div>
            </div>

            <div class="filter-box">
                <h4 class="box-title">Fiyat Aralığı</h4>
                <div class="price-range">
                    <div class="price-inputs">
                        <div class="p-input">
                            <input type="number" name="min_p" value="<?php echo $min_price ?: ''; ?>" placeholder="Min">
                            <span class="currency">₺</span>
                        </div>
                        <div class="sep">-</div>
                        <div class="p-input">
                            <input type="number" name="max_p" value="<?php echo $max_price ?: ''; ?>" placeholder="Max">
                            <span class="currency">₺</span>
                        </div>
                        <button type="submit" class="filter-apply-btn"><i class="fa-solid fa-angle-right"></i></button>
                    </div>
                </div>
            </div>

            <div class="filter-box">
                <h4 class="box-title">Markalar</h4>
                <div class="checkbox-list scroll-y">
                    <?php foreach($brands as $b): ?>
                        <label class="custom-check">
                            <input type="checkbox" name="brands[]" value="<?php echo $b['id']; ?>" 
                                <?php echo in_array($b['id'], $brand_ids) ? 'checked' : ''; ?>
                                onchange="this.form.submit()">
                            <span class="checkmark"></span>
                            <?php echo $b['marka_adi']; ?>
                        </label>
                    <?php endforeach; ?>
                </div>
            </div>
        </form>
    </aside>

    <div class="product-content">
        
        <div class="list-toolbar">
            <div class="result-count">Toplam <strong><?php echo count($products); ?></strong> ürün</div>
            <div class="sort-box">
                <select name="sort" form="filterForm" onchange="this.form.submit()">
                    <option value="newest" <?php echo $sort == 'newest' ? 'selected' : ''; ?>>En Yeniler</option>
                    <option value="price_asc" <?php echo $sort == 'price_asc' ? 'selected' : ''; ?>>Fiyat (Artan)</option>
                    <option value="price_desc" <?php echo $sort == 'price_desc' ? 'selected' : ''; ?>>Fiyat (Azalan)</option>
                    <option value="name_asc" <?php echo $sort == 'name_asc' ? 'selected' : ''; ?>>İsim (A-Z)</option>
                </select>
            </div>
        </div>

        <div class="product-grid">
            <?php if(empty($products)): ?>
                <div class="no-products">
                    <i class="fa-solid fa-box-open"></i>
                    <p>Ürün bulunamadı.</p>
                </div>
            <?php else: ?>
                <?php foreach($products as $prod): ?>
                    <?php
                        $isVariant = $prod['varyant_durumu'] == 1;
                        $rawPrice = $isVariant ? ($prod['v_fiyat'] ?? 0) : $prod['fiyat'];
                        
                        $manualDiscount = $isVariant ? ($prod['v_indirim'] ?? 0) : $prod['indirimli_fiyat'];
                        $campaignPrice = calculateRuntimeDiscount($prod['id'], $prod['kategori_id'], $rawPrice, $campaigns);
                        $activeDiscountedPrice = ($manualDiscount > 0) ? min($manualDiscount, $campaignPrice) : $campaignPrice;
                        
                        $kdvOrani = $isVariant ? ($prod['v_kdv'] ?? $prod['kdv_orani']) : $prod['kdv_orani'];
                        if(!$kdvOrani) $kdvOrani = 0; 

                        // --- PARA BİRİMİ DÖNÜŞÜMÜ (KANKACIM BURASI GÜNCELLENDİ) ---
                        $itemRate = floatval($prod['item_kur'] ?: 1); // Ürünün kur değeri
                        $finalData = getFinalConvertedPrices($rawPrice, $activeDiscountedPrice, $kdvOrani, $girisTipi, $gosterimTipi, $itemRate, $defKur);
                        
                        $priceInDefault = $finalData['price'];
                        $discountInDefault = $finalData['discount'];

                        $hasDiscount = ($discountInDefault > 0 && round($discountInDefault, 2) < round($priceInDefault, 2));
                        $discountPercent = $hasDiscount ? round((($priceInDefault - $discountInDefault) / $priceInDefault) * 100) : 0;

                        $rawStock = $isVariant ? ($prod['v_stok'] ?? 0) : $prod['stok_miktari'];
                        $rawImg = ($isVariant && $prod['v_resim']) ? $prod['v_resim'] : $prod['ana_resim'];
                        
                        $unitId = $isVariant ? ($prod['v_birim_id'] ?: $prod['stok_birimi_id']) : $prod['stok_birimi_id'];
                        $unitData = isset($unitList[$unitId]) ? $unitList[$unitId] : ['birim_adi' => 'Adet', 'artis_miktari' => 1];
                        $unitName = $unitData['birim_adi'];
                        $step = floatval($unitData['artis_miktari']); 
                        if($step <= 0) $step = 1;

                        $kdvLabel = ($gosterimTipi == 0) ? '<span class="kdv-tag">+KDV</span>' : '';
                        $inStock = $rawStock > 0;

                        $showPrice = true;
                        $lockMsg = "";
                        $btnText = "GİRİŞ YAP";
                        $btnLink = "login.php";

                        if ($prod['gorunurluk'] == 1 && $user_role !== 'member') {
                            $showPrice = false;
                            $lockMsg = "Sadece Üyelere Özel Fiyat";
                            $btnText = "ÜYE GİRİŞİ YAP";
                        } elseif ($prod['gorunurluk'] == 2 && $user_role !== 'dealer') {
                            $showPrice = false;
                            $lockMsg = "Sadece Bayilere Özel Fiyat";
                            $btnText = "BAYİ GİRİŞİ YAP";
                            $btnLink = "bayi-panel-giris.php"; 
                        }
                    ?>

                    <div class="product-card <?php echo !$inStock ? 'out-of-stock' : ''; ?>">
                        <div class="card-badges">
                            <?php if($hasDiscount && $showPrice): ?>
                                <div class="badge discount">
                                    <span class="percent">%<?php echo $discountPercent; ?></span>
                                    <span class="label">İNDİRİM</span>
                                </div>
                            <?php endif; ?>
                            <?php if(!$inStock): ?>
                                <div class="badge exhausted">TÜKENDİ</div>
                            <?php endif; ?>
                        </div>

                        <div class="card-img">
                            <a href="urun-detay.php?id=<?php echo $prod['id']; ?>">
                                <img src="uploads/urunler/<?php echo $rawImg; ?>" alt="<?php echo $prod['urun_adi']; ?>" onerror="this.src='https://placehold.co/300x300?text=No+Image'">
                            </a>
                        </div>

                        <div class="card-details">
                            <h3 class="title"><a href="urun-detay.php?id=<?php echo $prod['id']; ?>"><?php echo $prod['urun_adi']; ?></a></h3>
                            
                            <div class="price-area">
                                <?php if($showPrice): ?>
                                    <?php if($hasDiscount): ?>
                                        <div class="old-price"><?php echo number_format($priceInDefault, 2, ',', '.'); ?> <?php echo $defSembol; ?> <?php echo $kdvLabel; ?></div>
                                        <div class="current-price"><?php echo number_format($discountInDefault, 2, ',', '.'); ?> <?php echo $defSembol; ?> <?php echo $kdvLabel; ?></div>
                                    <?php else: ?>
                                        <div class="empty-space"></div>
                                        <div class="current-price"><?php echo number_format($priceInDefault, 2, ',', '.'); ?> <?php echo $defSembol; ?> <?php echo $kdvLabel; ?></div>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <div class="login-alert"><i class="fa-solid fa-lock"></i> <?php echo $lockMsg; ?></div>
                                <?php endif; ?>
                            </div>

                            <?php if($showPrice && $inStock && !$isVariant): ?>
                                <form method="POST" action="">
                                    <input type="hidden" name="add_to_cart" value="1">
                                    <input type="hidden" name="urun_id" value="<?php echo $prod['id']; ?>">
                                    <div class="qty-row">
                                        <button type="button" onclick="changeQty(this, -<?php echo $step; ?>)">-</button>
                                        <input type="text" name="miktar" value="<?php echo $step; ?>" readonly data-step="<?php echo $step; ?>">
                                        <button type="button" onclick="changeQty(this, <?php echo $step; ?>)">+</button>
                                        <span class="unit-label"><?php echo $unitName; ?></span>
                                    </div>
                                    <div class="action-area">
                                        <button type="submit" class="btn-block btn-add-cart">
                                            <i class="fa-solid <?php echo $tema['kart_ikon']; ?>"></i> SEPETE EKLE
                                        </button>
                                    </div>
                                </form>
                            <?php else: ?>
                                <?php if($isVariant): ?>
                                    <div class="variant-info"><i class="fa-solid fa-list"></i> Seçenekli Ürün</div>
                                <?php else: ?>
                                    <div class="qty-placeholder"></div>
                                <?php endif; ?>

                                <div class="action-area">
                                    <?php if(!$showPrice): ?>
                                        <a href="<?php echo $btnLink; ?>" class="btn-block btn-login" style="display:flex; justify-content:center; align-items:center; gap:8px;">
                                            <i class="fa-solid fa-user-lock"></i> <?php echo $btnText; ?>
                                        </a>
                                    <?php elseif(!$inStock): ?>
                                        <button type="button" class="btn-block btn-disabled" disabled>STOK YOK</button>
                                    <?php elseif($isVariant): ?>
                                        <a href="urun-detay.php?id=<?php echo $prod['id']; ?>" class="btn-block btn-options">SEÇENEKLER</a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- SEPET BİLDİRİM TOAST (POPUP) -->
<div id="cartToast" class="cart-toast">
    <div class="toast-content">
        <i class="fa-solid fa-circle-check"></i>
        <div class="toast-msg">Ürün sepete eklendi!</div>
    </div>
    <div class="toast-actions">
        <a href="sepet.php" class="btn-toast-go">Sepete Git</a>
        <button type="button" class="btn-toast-continue" onclick="closeToast()">Devam Et</button>
    </div>
</div>

<footer class="site-footer">
    <div class="container">
        &copy; <?php echo date("Y"); ?> Tüm Hakları Saklıdır.
    </div>
</footer>

<script>
    function changeQty(btn, change) {
        let input = btn.parentElement.querySelector('input');
        let step = parseFloat(input.getAttribute('data-step'));
        let val = parseFloat(input.value);
        let newVal = val + change;
        newVal = Math.round(newVal * 1000) / 1000;
        if(newVal < step) newVal = step;
        input.value = newVal;
    }
    function toggleSub(btn) {
        let subMenu = btn.parentElement.nextElementSibling;
        if(subMenu && subMenu.classList.contains('cat-sub')) {
            subMenu.classList.toggle('show');
            btn.classList.toggle('rotate');
        }
    }

    // --- TOAST (POPUP) MANTIĞI ---
    function closeToast() {
        document.getElementById('cartToast').classList.remove('show');
    }

    document.addEventListener("DOMContentLoaded", function() {
        const urlParams = new URLSearchParams(window.location.search);
        
        // Eğer URL'de add=success parametresi varsa toast'ı göster
        if (urlParams.get('add') === 'success') {
            const toast = document.getElementById('cartToast');
            toast.classList.add('show');

            // URL'yi temizle (sayfa yenilendiğinde tekrar çıkmasın diye)
            const newUrl = window.location.pathname + window.location.search.replace(/[?&]add=success/, '').replace(/^&/, '?');
            window.history.replaceState({}, document.title, newUrl);

            // 5 saniye sonra otomatik kapat
            setTimeout(() => {
                if(toast) toast.classList.remove('show');
            }, 5000);
        }
    });
</script>

<style>
.kdv-tag { font-size: 0.75rem; font-weight: 400; color: #9ca3af; margin-left: 4px; vertical-align: middle; }
.current-price .kdv-tag { font-size: 0.85rem; color: #bbb; }
.login-alert { color: #ef4444; font-size: 0.9rem; font-weight: 500; display: flex; flex-direction: column; align-items: center; gap: 5px; }
.login-alert i { font-size: 1.2rem; }
</style>

</body>
</html>