<?php
require_once 'private/config.php';

// Zaten giriş yapmışsa yönlendir
if (isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'member') {
    header("Location: uye-panel.php");
    exit;
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    if (empty($email) || empty($password)) {
        $error = "Lütfen e-posta ve şifrenizi giriniz.";
    } else {
        try {
            $stmt = $db->prepare("SELECT * FROM uyeler WHERE email = :email");
            $stmt->execute(['email' => $email]);
            $uye = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($uye) {
                if (password_verify($password, $uye['sifre'])) {
                    if ($uye['durum'] == 1) {
                        // Giriş Başarılı
                        $_SESSION['user_id'] = $uye['id'];
                        $_SESSION['user_name'] = $uye['ad_soyad'];
                        $_SESSION['user_role'] = 'member'; // Üye rolü
                        
                        // Giriş sonrası anasayfaya veya geldiği yere yönlendir
                        header("Location: uye-panel.php");
                        exit;
                    } else {
                        $error = "Hesabınız pasif durumdadır. Lütfen iletişime geçiniz.";
                    }
                } else {
                    $error = "Hatalı şifre girdiniz.";
                }
            } else {
                $error = "Bu e-posta adresiyle kayıtlı bir hesap bulunamadı.";
            }
        } catch (PDOException $e) {
            $error = "Sistemsel bir hata oluştu.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Üye Girişi | E-Ticaret</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/uye-giris.css">
</head>
<body>

<div class="login-wrapper">
    <div class="login-card">
        <div class="card-header">
            <div class="logo-area">
                <i class="fa-solid fa-user-circle"></i>
            </div>
            <h2>Hoş Geldiniz</h2>
            <p>Alışverişe devam etmek için giriş yapın.</p>
        </div>

        <?php if($error): ?>
            <div class="alert-error">
                <i class="fa-solid fa-circle-exclamation"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="input-group">
                <label>E-Posta Adresi</label>
                <div class="input-field">
                    <i class="fa-solid fa-envelope"></i>
                    <input type="email" name="email" required placeholder="ornek@mail.com">
                </div>
            </div>

            <div class="input-group">
                <label>Şifre</label>
                <div class="input-field">
                    <i class="fa-solid fa-lock"></i>
                    <input type="password" name="password" required placeholder="******">
                </div>
                <div class="forgot-pass">
                    <a href="#">Şifremi Unuttum</a>
                </div>
            </div>

            <button type="submit" class="btn-login">Giriş Yap <i class="fa-solid fa-arrow-right"></i></button>
        </form>

        <div class="card-footer">
            Hesabınız yok mu? <a href="uye-kayit.php">Hemen Kayıt Olun</a>
        </div>
        
        <div class="back-to-home">
            <a href="index.php"><i class="fa-solid fa-arrow-left"></i> Anasayfaya Dön</a>
        </div>
    </div>
</div>

</body>
</html>