<?php
require_once 'private/config.php';

if (isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'member') {
    header("Location: uye-panel.php");
    exit;
}

$message = "";
$messageType = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $ad_soyad = trim($_POST['ad_soyad']);
    $email = trim($_POST['email']);
    $telefon = trim($_POST['telefon']);
    $pass1 = $_POST['pass1'];
    $pass2 = $_POST['pass2'];

    if (empty($ad_soyad) || empty($email) || empty($pass1)) {
        $message = "Lütfen zorunlu alanları doldurunuz.";
        $messageType = "error";
    } elseif ($pass1 !== $pass2) {
        $message = "Şifreler birbiriyle uyuşmuyor.";
        $messageType = "error";
    } else {
        $check = $db->prepare("SELECT id FROM uyeler WHERE email = ?");
        $check->execute([$email]);
        
        if ($check->rowCount() > 0) {
            $message = "Bu e-posta adresi zaten kayıtlı.";
            $messageType = "error";
        } else {
            try {
                $hashPass = password_hash($pass1, PASSWORD_DEFAULT);
                // Üyeler direkt aktif (durum=1) olarak kaydedilir
                $sql = "INSERT INTO uyeler (ad_soyad, email, telefon, sifre, durum) VALUES (?, ?, ?, ?, 1)"; 
                $stmt = $db->prepare($sql);
                $insert = $stmt->execute([$ad_soyad, $email, $telefon, $hashPass]);

                if ($insert) {
                    $message = "Kayıt işleminiz başarıyla tamamlandı! Giriş yapabilirsiniz.";
                    $messageType = "success";
                } else {
                    $message = "Kayıt sırasında bir hata oluştu.";
                    $messageType = "error";
                }
            } catch (PDOException $e) {
                $message = "Veritabanı hatası: " . $e->getMessage();
                $messageType = "error";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hemen Kayıt Ol | E-Ticaret</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/uye-kayit.css">
</head>
<body>

<div class="reg-container">
    <div class="reg-card">
        <div class="card-header">
            <h2>Kayıt Ol</h2>
            <p>Hızlı ve güvenli alışveriş için hemen hesabınızı oluşturun.</p>
        </div>

        <?php if($message): ?>
            <div class="alert-box <?php echo $messageType; ?>">
                <?php if($messageType == 'success'): ?>
                    <i class="fa-solid fa-circle-check"></i>
                <?php else: ?>
                    <i class="fa-solid fa-circle-exclamation"></i>
                <?php endif; ?>
                <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <?php if($messageType !== 'success'): ?>
        <form method="POST" action="" class="reg-form">
            
            <div class="form-group">
                <label>Adınız ve Soyadınız *</label>
                <input type="text" name="ad_soyad" required placeholder="Örn: Ahmet Yılmaz">
            </div>

            <div class="form-group">
                <label>E-Posta Adresiniz *</label>
                <input type="email" name="email" required placeholder="Giriş için kullanılacak">
            </div>
            
            <div class="form-group">
                <label>Telefon Numaranız</label>
                <input type="text" name="telefon" placeholder="05XX XXX XX XX">
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label>Şifreniz *</label>
                    <input type="password" name="pass1" required placeholder="En az 6 karakter">
                </div>
                <div class="form-group">
                    <label>Şifre Tekrar *</label>
                    <input type="password" name="pass2" required placeholder="Şifrenizi doğrulayın">
                </div>
            </div>

            <button type="submit" class="btn-register">Ücretsiz Kayıt Ol</button>
        </form>
        <?php else: ?>
            <div class="success-actions">
                <a href="uye-giris.php" class="btn-login-link">Giriş Yap</a>
            </div>
        <?php endif; ?>
        
        <div class="bottom-link">
            Zaten bir hesabınız var mı? <a href="uye-giris.php">Giriş Yapın</a>
        </div>
        
        <div class="back-to-home" style="text-align: center; margin-top:15px;">
            <a href="index.php" style="color: #6b7280; font-size: 0.85rem; text-decoration: none;"><i class="fa-solid fa-arrow-left"></i> Anasayfaya Dön</a>
        </div>
    </div>
</div>

</body>
</html>