<?php
require_once 'private/config.php';

// Güvenlik: Sadece Normal Üyeler Girebilir
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'member') {
    header("Location: uye-giris.php");
    exit;
}

$uye_id = $_SESSION['user_id'];
$active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'dashboard';
$message = "";
$messageType = "";

// --- İŞLEM 1: PROFİL GÜNCELLEME ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'update_profile') {
    $ad_soyad = trim($_POST['ad_soyad']);
    $telefon = trim($_POST['telefon']);
    $il = trim($_POST['il']);
    $ilce = trim($_POST['ilce']);
    $adres = trim($_POST['adres']);
    
    // Şifre değişimi varsa
    $pass_sql = "";
    $params = [$ad_soyad, $telefon, $il, $ilce, $adres];
    
    if (!empty($_POST['new_password'])) {
        $pass_sql = ", sifre = ?";
        $params[] = password_hash($_POST['new_password'], PASSWORD_DEFAULT);
    }
    
    $params[] = $uye_id; // WHERE şartı için

    $sql = "UPDATE uyeler SET ad_soyad=?, telefon=?, il=?, ilce=?, adres=? $pass_sql WHERE id=?";
    $stmt = $db->prepare($sql);
    
    if ($stmt->execute($params)) {
        $message = "Bilgileriniz başarıyla güncellendi.";
        $messageType = "success";
        $_SESSION['user_name'] = $ad_soyad; // Session'ı da güncelle
    } else {
        $message = "Güncelleme sırasında hata oluştu.";
        $messageType = "error";
    }
}

// --- İŞLEM 2: SİPARİŞ İPTALİ (15 GÜN KURALI) ---
if (isset($_GET['cancel_order'])) {
    $order_id = intval($_GET['cancel_order']);
    
    // Siparişi çek (uye_id ile güvenliği sağla)
    $stmt = $db->prepare("SELECT siparis_tarihi, durum FROM siparisler WHERE id = ? AND uye_id = ?");
    $stmt->execute([$order_id, $uye_id]);
    $order = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($order) {
        $orderDate = new DateTime($order['siparis_tarihi']);
        $now = new DateTime();
        $interval = $now->diff($orderDate);
        $days = $interval->days;

        // Kural: 15 günü geçmemiş ve kargoya verilmemiş olmalı
        if ($days <= 15 && ($order['durum'] == 'Bekliyor' || $order['durum'] == 'Hazırlanıyor')) {
            $upd = $db->prepare("UPDATE siparisler SET durum = 'İptal' WHERE id = ?");
            $upd->execute([$order_id]);
            $message = "Siparişiniz iptal edildi.";
            $messageType = "success";
        } else {
            $message = "Bu sipariş iptal edilemez (Süre dolmuş veya kargoya verilmiş olabilir).";
            $messageType = "error";
        }
    }
}

// --- VERİLERİ ÇEK ---
// 1. Üye Bilgileri
$uye = $db->query("SELECT * FROM uyeler WHERE id = $uye_id")->fetch(PDO::FETCH_ASSOC);

// 2. Siparişler (uye_id'ye göre)
$orders = $db->query("SELECT * FROM siparisler WHERE uye_id = $uye_id ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

// 3. İstatistikler
$totalOrders = count($orders);
$activeOrders = 0;
foreach($orders as $o) {
    if($o['durum'] != 'İptal' && $o['durum'] != 'Tamamlandı') {
        $activeOrders++;
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hesabım | E-Ticaret</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/uye-panel.css">
</head>
<body>

<header class="panel-header">
    <div class="container">
        <div class="brand">
            <i class="fa-solid fa-user-circle"></i> Hesabım
        </div>
        <div class="user-actions">
            <span>Merhaba, <b><?php echo $uye['ad_soyad']; ?></b></span>
            <a href="urun-liste.php" class="btn-home"><i class="fa-solid fa-store"></i> Alışverişe Devam</a>
            <a href="uye-cikis.php" class="btn-logout"><i class="fa-solid fa-power-off"></i> Çıkış</a>
        </div>
    </div>
</header>

<div class="container main-layout">
    
    <!-- Sidebar Menü -->
    <aside class="sidebar">
        <div class="profile-summary">
            <div class="avatar-circle"><?php echo strtoupper(substr($uye['ad_soyad'], 0, 1)); ?></div>
            <h3><?php echo $uye['ad_soyad']; ?></h3>
            <p><?php echo $uye['email']; ?></p>
        </div>
        <nav class="menu">
            <a href="?tab=dashboard" class="<?php echo $active_tab=='dashboard'?'active':''; ?>">
                <i class="fa-solid fa-house-user"></i> Panelim
            </a>
            <a href="?tab=orders" class="<?php echo $active_tab=='orders'?'active':''; ?>">
                <i class="fa-solid fa-box-open"></i> Siparişlerim
            </a>
            <a href="?tab=profile" class="<?php echo $active_tab=='profile'?'active':''; ?>">
                <i class="fa-solid fa-user-pen"></i> Hesap Bilgilerim
            </a>
        </nav>
    </aside>

    <!-- İçerik Alanı -->
    <main class="content">
        
        <?php if($message): ?>
            <div class="alert-box <?php echo $messageType; ?>">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <!-- TAB: DASHBOARD -->
        <?php if($active_tab == 'dashboard'): ?>
            <div class="content-header">
                <h2>Hoş Geldiniz</h2>
                <p>Hesap özetinizi ve son işlemlerinizi buradan takip edebilirsiniz.</p>
            </div>
            
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="icon blue"><i class="fa-solid fa-boxes-stacked"></i></div>
                    <div class="info">
                        <h3><?php echo $totalOrders; ?></h3>
                        <p>Toplam Siparişiniz</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="icon green"><i class="fa-solid fa-truck-fast"></i></div>
                    <div class="info">
                        <h3><?php echo $activeOrders; ?></h3>
                        <p>Devam Eden Siparişiniz</p>
                    </div>
                </div>
            </div>

            <div class="recent-orders mt-30">
                <h3>Son Siparişleriniz</h3>
                <?php if(empty($orders)): ?>
                    <p class="empty-msg">Henüz sipariş vermediniz. <a href="urun-liste.php">Hemen alışverişe başlayın.</a></p>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="panel-table">
                            <thead>
                                <tr>
                                    <th>Sipariş No</th>
                                    <th>Tarih</th>
                                    <th>Tutar</th>
                                    <th>Durum</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $count = 0;
                                foreach($orders as $order): 
                                    if($count >= 3) break; $count++;
                                ?>
                                <tr>
                                    <td>#<?php echo $order['siparis_kodu']; ?></td>
                                    <td><?php echo date('d.m.Y', strtotime($order['siparis_tarihi'])); ?></td>
                                    <td><?php echo number_format($order['toplam_tutar'], 2, ',', '.'); ?> ₺</td>
                                    <td><span class="status-badge <?php echo strtolower($order['durum']); ?>"><?php echo $order['durum']; ?></span></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <!-- TAB: SİPARİŞLER -->
        <?php if($active_tab == 'orders'): ?>
            <div class="content-header">
                <h2>Tüm Siparişlerim</h2>
            </div>
            <div class="panel-card">
                <div class="table-responsive">
                    <table class="panel-table">
                        <thead>
                            <tr>
                                <th>Sipariş Kodu</th>
                                <th>Sipariş Tarihi</th>
                                <th>Tutar</th>
                                <th>Durum</th>
                                <th>Kargo Bilgileri</th>
                                <th>İşlem</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($orders as $order): 
                                // 15 Gün Kontrolü
                                $orderDate = new DateTime($order['siparis_tarihi']);
                                $now = new DateTime();
                                $interval = $now->diff($orderDate);
                                $days = $interval->days;
                                $isCancelable = ($days <= 15 && ($order['durum'] == 'Bekliyor' || $order['durum'] == 'Hazırlanıyor'));
                            ?>
                            <tr>
                                <td><strong>#<?php echo $order['siparis_kodu']; ?></strong></td>
                                <td>
                                    <?php echo date('d.m.Y', strtotime($order['siparis_tarihi'])); ?><br>
                                    <span class="sub-text"><?php echo date('H:i', strtotime($order['siparis_tarihi'])); ?></span>
                                </td>
                                <td><strong><?php echo number_format($order['toplam_tutar'], 2, ',', '.'); ?> ₺</strong></td>
                                <td><span class="status-badge <?php echo strtolower($order['durum']); ?>"><?php echo $order['durum']; ?></span></td>
                                <td>
                                    <?php if($order['kargo_firma']): ?>
                                        <div class="cargo-box">
                                            <strong><i class="fa-solid fa-truck"></i> <?php echo $order['kargo_firma']; ?></strong>
                                            <span>Takip No: <?php echo $order['kargo_takip_no']; ?></span>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">Bekleniyor</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($isCancelable): ?>
                                        <a href="?tab=orders&cancel_order=<?php echo $order['id']; ?>" class="btn-cancel" onclick="return confirm('Bu siparişi iptal etmek istediğinize emin misiniz?')">
                                            İptal Et
                                        </a>
                                    <?php elseif($order['durum'] == 'İptal'): ?>
                                        <span class="text-danger">İptal Edildi</span>
                                    <?php else: ?>
                                        <button class="btn-detail" disabled title="Süre doldu veya kargoya verildi">Detay</button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php if(empty($orders)): ?>
                                <tr><td colspan="6" class="text-center p-20">Siparişiniz bulunmamaktadır.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="info-footer">
                    <i class="fa-solid fa-circle-info"></i> Tüketici hakları gereği siparişlerinizi oluşturulduktan sonraki <strong>15 gün</strong> içerisinde, kargoya verilmeden önce panel üzerinden iptal edebilirsiniz.
                </div>
            </div>
        <?php endif; ?>

        <!-- TAB: PROFİL -->
        <?php if($active_tab == 'profile'): ?>
            <div class="content-header">
                <h2>Hesap Bilgilerim</h2>
            </div>
            <div class="panel-card form-card">
                <form method="POST" action="">
                    <input type="hidden" name="action" value="update_profile">
                    
                    <div class="form-row">
                        <div class="form-group col-2">
                            <label>Adınız ve Soyadınız</label>
                            <input type="text" name="ad_soyad" value="<?php echo $uye['ad_soyad']; ?>" required>
                        </div>
                        <div class="form-group col">
                            <label>E-Posta Adresi (Değiştirilemez)</label>
                            <input type="email" value="<?php echo $uye['email']; ?>" disabled class="input-disabled" title="E-posta adresi değiştirilemez.">
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col">
                            <label>Telefon</label>
                            <input type="text" name="telefon" value="<?php echo $uye['telefon']; ?>">
                        </div>
                    </div>

                    <div class="form-section-title mt-20">Adres Bilgileri</div>
                    <div class="form-row">
                        <div class="form-group col">
                            <label>İl</label>
                            <input type="text" name="il" value="<?php echo $uye['il']; ?>">
                        </div>
                        <div class="form-group col">
                            <label>İlçe</label>
                            <input type="text" name="ilce" value="<?php echo $uye['ilce']; ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Açık Adres</label>
                        <textarea name="adres" rows="3"><?php echo $uye['adres']; ?></textarea>
                    </div>

                    <div class="form-section-title mt-20">Şifre Değiştir (İsteğe Bağlı)</div>
                    <div class="form-group">
                        <label>Yeni Şifre</label>
                        <input type="password" name="new_password" placeholder="Sadece değiştirmek istiyorsanız doldurun">
                    </div>

                    <button type="submit" class="btn-save">Bilgilerimi Kaydet</button>
                </form>
            </div>
        <?php endif; ?>

    </main>
</div>

</body>
</html>